/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentruntime.model.BedrockAgentRuntimeRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.FlowInput;
import software.amazon.awssdk.services.bedrockagentruntime.model.FlowInputsCopier;
import software.amazon.awssdk.services.bedrockagentruntime.model.ModelPerformanceConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartFlowExecutionRequest
extends BedrockAgentRuntimeRequest
implements ToCopyableBuilder<Builder, StartFlowExecutionRequest> {
    private static final SdkField<String> FLOW_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("flowIdentifier").getter(StartFlowExecutionRequest.getter(StartFlowExecutionRequest::flowIdentifier)).setter(StartFlowExecutionRequest.setter(Builder::flowIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("flowIdentifier").build()}).build();
    private static final SdkField<String> FLOW_ALIAS_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("flowAliasIdentifier").getter(StartFlowExecutionRequest.getter(StartFlowExecutionRequest::flowAliasIdentifier)).setter(StartFlowExecutionRequest.setter(Builder::flowAliasIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("flowAliasIdentifier").build()}).build();
    private static final SdkField<String> FLOW_EXECUTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("flowExecutionName").getter(StartFlowExecutionRequest.getter(StartFlowExecutionRequest::flowExecutionName)).setter(StartFlowExecutionRequest.setter(Builder::flowExecutionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowExecutionName").build()}).build();
    private static final SdkField<List<FlowInput>> INPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("inputs").getter(StartFlowExecutionRequest.getter(StartFlowExecutionRequest::inputs)).setter(StartFlowExecutionRequest.setter(Builder::inputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FlowInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ModelPerformanceConfiguration> MODEL_PERFORMANCE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("modelPerformanceConfiguration").getter(StartFlowExecutionRequest.getter(StartFlowExecutionRequest::modelPerformanceConfiguration)).setter(StartFlowExecutionRequest.setter(Builder::modelPerformanceConfiguration)).constructor(ModelPerformanceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelPerformanceConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_IDENTIFIER_FIELD, FLOW_ALIAS_IDENTIFIER_FIELD, FLOW_EXECUTION_NAME_FIELD, INPUTS_FIELD, MODEL_PERFORMANCE_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartFlowExecutionRequest.memberNameToFieldInitializer();
    private final String flowIdentifier;
    private final String flowAliasIdentifier;
    private final String flowExecutionName;
    private final List<FlowInput> inputs;
    private final ModelPerformanceConfiguration modelPerformanceConfiguration;

    private StartFlowExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.flowIdentifier = builder.flowIdentifier;
        this.flowAliasIdentifier = builder.flowAliasIdentifier;
        this.flowExecutionName = builder.flowExecutionName;
        this.inputs = builder.inputs;
        this.modelPerformanceConfiguration = builder.modelPerformanceConfiguration;
    }

    public final String flowIdentifier() {
        return this.flowIdentifier;
    }

    public final String flowAliasIdentifier() {
        return this.flowAliasIdentifier;
    }

    public final String flowExecutionName() {
        return this.flowExecutionName;
    }

    public final boolean hasInputs() {
        return this.inputs != null && !(this.inputs instanceof SdkAutoConstructList);
    }

    public final List<FlowInput> inputs() {
        return this.inputs;
    }

    public final ModelPerformanceConfiguration modelPerformanceConfiguration() {
        return this.modelPerformanceConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.flowIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowAliasIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowExecutionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputs() ? this.inputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.modelPerformanceConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartFlowExecutionRequest)) {
            return false;
        }
        StartFlowExecutionRequest other = (StartFlowExecutionRequest)((Object)obj);
        return Objects.equals(this.flowIdentifier(), other.flowIdentifier()) && Objects.equals(this.flowAliasIdentifier(), other.flowAliasIdentifier()) && Objects.equals(this.flowExecutionName(), other.flowExecutionName()) && this.hasInputs() == other.hasInputs() && Objects.equals(this.inputs(), other.inputs()) && Objects.equals(this.modelPerformanceConfiguration(), other.modelPerformanceConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"StartFlowExecutionRequest").add("FlowIdentifier", (Object)this.flowIdentifier()).add("FlowAliasIdentifier", (Object)this.flowAliasIdentifier()).add("FlowExecutionName", (Object)this.flowExecutionName()).add("Inputs", this.hasInputs() ? this.inputs() : null).add("ModelPerformanceConfiguration", (Object)this.modelPerformanceConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "flowIdentifier": {
                return Optional.ofNullable(clazz.cast(this.flowIdentifier()));
            }
            case "flowAliasIdentifier": {
                return Optional.ofNullable(clazz.cast(this.flowAliasIdentifier()));
            }
            case "flowExecutionName": {
                return Optional.ofNullable(clazz.cast(this.flowExecutionName()));
            }
            case "inputs": {
                return Optional.ofNullable(clazz.cast(this.inputs()));
            }
            case "modelPerformanceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.modelPerformanceConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("flowIdentifier", FLOW_IDENTIFIER_FIELD);
        map.put("flowAliasIdentifier", FLOW_ALIAS_IDENTIFIER_FIELD);
        map.put("flowExecutionName", FLOW_EXECUTION_NAME_FIELD);
        map.put("inputs", INPUTS_FIELD);
        map.put("modelPerformanceConfiguration", MODEL_PERFORMANCE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartFlowExecutionRequest, T> g) {
        return obj -> g.apply((StartFlowExecutionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentRuntimeRequest.BuilderImpl
    implements Builder {
        private String flowIdentifier;
        private String flowAliasIdentifier;
        private String flowExecutionName;
        private List<FlowInput> inputs = DefaultSdkAutoConstructList.getInstance();
        private ModelPerformanceConfiguration modelPerformanceConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(StartFlowExecutionRequest model) {
            super(model);
            this.flowIdentifier(model.flowIdentifier);
            this.flowAliasIdentifier(model.flowAliasIdentifier);
            this.flowExecutionName(model.flowExecutionName);
            this.inputs(model.inputs);
            this.modelPerformanceConfiguration(model.modelPerformanceConfiguration);
        }

        public final String getFlowIdentifier() {
            return this.flowIdentifier;
        }

        public final void setFlowIdentifier(String flowIdentifier) {
            this.flowIdentifier = flowIdentifier;
        }

        @Override
        public final Builder flowIdentifier(String flowIdentifier) {
            this.flowIdentifier = flowIdentifier;
            return this;
        }

        public final String getFlowAliasIdentifier() {
            return this.flowAliasIdentifier;
        }

        public final void setFlowAliasIdentifier(String flowAliasIdentifier) {
            this.flowAliasIdentifier = flowAliasIdentifier;
        }

        @Override
        public final Builder flowAliasIdentifier(String flowAliasIdentifier) {
            this.flowAliasIdentifier = flowAliasIdentifier;
            return this;
        }

        public final String getFlowExecutionName() {
            return this.flowExecutionName;
        }

        public final void setFlowExecutionName(String flowExecutionName) {
            this.flowExecutionName = flowExecutionName;
        }

        @Override
        public final Builder flowExecutionName(String flowExecutionName) {
            this.flowExecutionName = flowExecutionName;
            return this;
        }

        public final List<FlowInput.Builder> getInputs() {
            List<FlowInput.Builder> result = FlowInputsCopier.copyToBuilder(this.inputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputs(Collection<FlowInput.BuilderImpl> inputs) {
            this.inputs = FlowInputsCopier.copyFromBuilder(inputs);
        }

        @Override
        public final Builder inputs(Collection<FlowInput> inputs) {
            this.inputs = FlowInputsCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(FlowInput ... inputs) {
            this.inputs(Arrays.asList(inputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(Consumer<FlowInput.Builder> ... inputs) {
            this.inputs(Stream.of(inputs).map(c -> (FlowInput)((FlowInput.Builder)FlowInput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ModelPerformanceConfiguration.Builder getModelPerformanceConfiguration() {
            return this.modelPerformanceConfiguration != null ? this.modelPerformanceConfiguration.toBuilder() : null;
        }

        public final void setModelPerformanceConfiguration(ModelPerformanceConfiguration.BuilderImpl modelPerformanceConfiguration) {
            this.modelPerformanceConfiguration = modelPerformanceConfiguration != null ? modelPerformanceConfiguration.build() : null;
        }

        @Override
        public final Builder modelPerformanceConfiguration(ModelPerformanceConfiguration modelPerformanceConfiguration) {
            this.modelPerformanceConfiguration = modelPerformanceConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartFlowExecutionRequest build() {
            return new StartFlowExecutionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentRuntimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartFlowExecutionRequest> {
        public Builder flowIdentifier(String var1);

        public Builder flowAliasIdentifier(String var1);

        public Builder flowExecutionName(String var1);

        public Builder inputs(Collection<FlowInput> var1);

        public Builder inputs(FlowInput ... var1);

        public Builder inputs(Consumer<FlowInput.Builder> ... var1);

        public Builder modelPerformanceConfiguration(ModelPerformanceConfiguration var1);

        default public Builder modelPerformanceConfiguration(Consumer<ModelPerformanceConfiguration.Builder> modelPerformanceConfiguration) {
            return this.modelPerformanceConfiguration((ModelPerformanceConfiguration)((ModelPerformanceConfiguration.Builder)ModelPerformanceConfiguration.builder().applyMutation(modelPerformanceConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

