/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockagentruntime.model.AgentTracesCopier;
import software.amazon.awssdk.services.bedrockagentruntime.model.TracePart;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NodeTraceElements
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NodeTraceElements> {
    private static final SdkField<List<TracePart>> AGENT_TRACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("agentTraces").getter(NodeTraceElements.getter(NodeTraceElements::agentTraces)).setter(NodeTraceElements.setter(Builder::agentTraces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentTraces").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TracePart::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_TRACES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NodeTraceElements.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<TracePart> agentTraces;
    private final Type type;

    private NodeTraceElements(BuilderImpl builder) {
        this.agentTraces = builder.agentTraces;
        this.type = builder.type;
    }

    public final boolean hasAgentTraces() {
        return this.agentTraces != null && !(this.agentTraces instanceof SdkAutoConstructList);
    }

    public final List<TracePart> agentTraces() {
        return this.agentTraces;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAgentTraces() ? this.agentTraces() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeTraceElements)) {
            return false;
        }
        NodeTraceElements other = (NodeTraceElements)obj;
        return this.hasAgentTraces() == other.hasAgentTraces() && Objects.equals(this.agentTraces(), other.agentTraces());
    }

    public final String toString() {
        return ToString.builder((String)"NodeTraceElements").add("AgentTraces", (Object)(this.agentTraces() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "agentTraces": {
                return Optional.ofNullable(clazz.cast(this.agentTraces()));
            }
        }
        return Optional.empty();
    }

    public static NodeTraceElements fromAgentTraces(List<TracePart> agentTraces) {
        return (NodeTraceElements)NodeTraceElements.builder().agentTraces(agentTraces).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<TracePart>>> map = new HashMap<String, SdkField<List<TracePart>>>();
        map.put("agentTraces", AGENT_TRACES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NodeTraceElements, T> g) {
        return obj -> g.apply((NodeTraceElements)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        AGENT_TRACES,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private List<TracePart> agentTraces = DefaultSdkAutoConstructList.getInstance();
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(NodeTraceElements model) {
            this.agentTraces(model.agentTraces);
        }

        public final List<TracePart.Builder> getAgentTraces() {
            List<TracePart.Builder> result = AgentTracesCopier.copyToBuilder(this.agentTraces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAgentTraces(Collection<TracePart.BuilderImpl> agentTraces) {
            List<TracePart> oldValue = this.agentTraces;
            this.agentTraces = AgentTracesCopier.copyFromBuilder(agentTraces);
            this.handleUnionValueChange(Type.AGENT_TRACES, oldValue, this.agentTraces);
        }

        @Override
        public final Builder agentTraces(Collection<TracePart> agentTraces) {
            List<TracePart> oldValue = this.agentTraces;
            this.agentTraces = AgentTracesCopier.copy(agentTraces);
            this.handleUnionValueChange(Type.AGENT_TRACES, oldValue, this.agentTraces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentTraces(TracePart ... agentTraces) {
            this.agentTraces(Arrays.asList(agentTraces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentTraces(Consumer<TracePart.Builder> ... agentTraces) {
            this.agentTraces(Stream.of(agentTraces).map(c -> (TracePart)((TracePart.Builder)TracePart.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public NodeTraceElements build() {
            return new NodeTraceElements(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NodeTraceElements> {
        public Builder agentTraces(Collection<TracePart> var1);

        public Builder agentTraces(TracePart ... var1);

        public Builder agentTraces(Consumer<TracePart.Builder> ... var1);
    }
}

