/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentruntime.model.Caller;
import software.amazon.awssdk.services.bedrockagentruntime.model.CallerChainCopier;
import software.amazon.awssdk.services.bedrockagentruntime.model.InvokeAgentResponseHandler;
import software.amazon.awssdk.services.bedrockagentruntime.model.ResponseStream;
import software.amazon.awssdk.services.bedrockagentruntime.model.Trace;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TracePart
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TracePart>,
ResponseStream {
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(TracePart.getter(TracePart::sessionId)).setter(TracePart.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()}).build();
    private static final SdkField<Trace> TRACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("trace").getter(TracePart.getter(TracePart::trace)).setter(TracePart.setter(Builder::trace)).constructor(Trace::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trace").build()}).build();
    private static final SdkField<List<Caller>> CALLER_CHAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("callerChain").getter(TracePart.getter(TracePart::callerChain)).setter(TracePart.setter(Builder::callerChain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("callerChain").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Caller::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> EVENT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("eventTime").getter(TracePart.getter(TracePart::eventTime)).setter(TracePart.setter(Builder::eventTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> COLLABORATOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("collaboratorName").getter(TracePart.getter(TracePart::collaboratorName)).setter(TracePart.setter(Builder::collaboratorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaboratorName").build()}).build();
    private static final SdkField<String> AGENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentId").getter(TracePart.getter(TracePart::agentId)).setter(TracePart.setter(Builder::agentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentId").build()}).build();
    private static final SdkField<String> AGENT_ALIAS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentAliasId").getter(TracePart.getter(TracePart::agentAliasId)).setter(TracePart.setter(Builder::agentAliasId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentAliasId").build()}).build();
    private static final SdkField<String> AGENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentVersion").getter(TracePart.getter(TracePart::agentVersion)).setter(TracePart.setter(Builder::agentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_ID_FIELD, TRACE_FIELD, CALLER_CHAIN_FIELD, EVENT_TIME_FIELD, COLLABORATOR_NAME_FIELD, AGENT_ID_FIELD, AGENT_ALIAS_ID_FIELD, AGENT_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TracePart.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String sessionId;
    private final Trace trace;
    private final List<Caller> callerChain;
    private final Instant eventTime;
    private final String collaboratorName;
    private final String agentId;
    private final String agentAliasId;
    private final String agentVersion;

    protected TracePart(BuilderImpl builder) {
        this.sessionId = builder.sessionId;
        this.trace = builder.trace;
        this.callerChain = builder.callerChain;
        this.eventTime = builder.eventTime;
        this.collaboratorName = builder.collaboratorName;
        this.agentId = builder.agentId;
        this.agentAliasId = builder.agentAliasId;
        this.agentVersion = builder.agentVersion;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final Trace trace() {
        return this.trace;
    }

    public final boolean hasCallerChain() {
        return this.callerChain != null && !(this.callerChain instanceof SdkAutoConstructList);
    }

    public final List<Caller> callerChain() {
        return this.callerChain;
    }

    public final Instant eventTime() {
        return this.eventTime;
    }

    public final String collaboratorName() {
        return this.collaboratorName;
    }

    public final String agentId() {
        return this.agentId;
    }

    public final String agentAliasId() {
        return this.agentAliasId;
    }

    public final String agentVersion() {
        return this.agentVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.trace());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCallerChain() ? this.callerChain() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.collaboratorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentAliasId());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TracePart)) {
            return false;
        }
        TracePart other = (TracePart)obj;
        return Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.trace(), other.trace()) && this.hasCallerChain() == other.hasCallerChain() && Objects.equals(this.callerChain(), other.callerChain()) && Objects.equals(this.eventTime(), other.eventTime()) && Objects.equals(this.collaboratorName(), other.collaboratorName()) && Objects.equals(this.agentId(), other.agentId()) && Objects.equals(this.agentAliasId(), other.agentAliasId()) && Objects.equals(this.agentVersion(), other.agentVersion());
    }

    public final String toString() {
        return ToString.builder((String)"TracePart").add("SessionId", (Object)this.sessionId()).add("Trace", (Object)(this.trace() == null ? null : "*** Sensitive Data Redacted ***")).add("CallerChain", this.hasCallerChain() ? this.callerChain() : null).add("EventTime", (Object)this.eventTime()).add("CollaboratorName", (Object)(this.collaboratorName() == null ? null : "*** Sensitive Data Redacted ***")).add("AgentId", (Object)this.agentId()).add("AgentAliasId", (Object)this.agentAliasId()).add("AgentVersion", (Object)this.agentVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "trace": {
                return Optional.ofNullable(clazz.cast(this.trace()));
            }
            case "callerChain": {
                return Optional.ofNullable(clazz.cast(this.callerChain()));
            }
            case "eventTime": {
                return Optional.ofNullable(clazz.cast(this.eventTime()));
            }
            case "collaboratorName": {
                return Optional.ofNullable(clazz.cast(this.collaboratorName()));
            }
            case "agentId": {
                return Optional.ofNullable(clazz.cast(this.agentId()));
            }
            case "agentAliasId": {
                return Optional.ofNullable(clazz.cast(this.agentAliasId()));
            }
            case "agentVersion": {
                return Optional.ofNullable(clazz.cast(this.agentVersion()));
            }
        }
        return Optional.empty();
    }

    public final TracePart copy(Consumer<? super Builder> modifier) {
        return (TracePart)super.copy(modifier);
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("trace", TRACE_FIELD);
        map.put("callerChain", CALLER_CHAIN_FIELD);
        map.put("eventTime", EVENT_TIME_FIELD);
        map.put("collaboratorName", COLLABORATOR_NAME_FIELD);
        map.put("agentId", AGENT_ID_FIELD);
        map.put("agentAliasId", AGENT_ALIAS_ID_FIELD);
        map.put("agentVersion", AGENT_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TracePart, T> g) {
        return obj -> g.apply((TracePart)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    @Override
    public void accept(InvokeAgentResponseHandler.Visitor visitor) {
        throw new UnsupportedOperationException();
    }

    protected static class BuilderImpl
    implements Builder {
        private String sessionId;
        private Trace trace;
        private List<Caller> callerChain = DefaultSdkAutoConstructList.getInstance();
        private Instant eventTime;
        private String collaboratorName;
        private String agentId;
        private String agentAliasId;
        private String agentVersion;

        protected BuilderImpl() {
        }

        protected BuilderImpl(TracePart model) {
            this.sessionId(model.sessionId);
            this.trace(model.trace);
            this.callerChain(model.callerChain);
            this.eventTime(model.eventTime);
            this.collaboratorName(model.collaboratorName);
            this.agentId(model.agentId);
            this.agentAliasId(model.agentAliasId);
            this.agentVersion(model.agentVersion);
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final Trace.Builder getTrace() {
            return this.trace != null ? this.trace.toBuilder() : null;
        }

        public final void setTrace(Trace.BuilderImpl trace) {
            this.trace = trace != null ? trace.build() : null;
        }

        @Override
        public final Builder trace(Trace trace) {
            this.trace = trace;
            return this;
        }

        public final List<Caller.Builder> getCallerChain() {
            List<Caller.Builder> result = CallerChainCopier.copyToBuilder(this.callerChain);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCallerChain(Collection<Caller.BuilderImpl> callerChain) {
            this.callerChain = CallerChainCopier.copyFromBuilder(callerChain);
        }

        @Override
        public final Builder callerChain(Collection<Caller> callerChain) {
            this.callerChain = CallerChainCopier.copy(callerChain);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder callerChain(Caller ... callerChain) {
            this.callerChain(Arrays.asList(callerChain));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder callerChain(Consumer<Caller.Builder> ... callerChain) {
            this.callerChain(Stream.of(callerChain).map(c -> (Caller)((Caller.Builder)Caller.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getEventTime() {
            return this.eventTime;
        }

        public final void setEventTime(Instant eventTime) {
            this.eventTime = eventTime;
        }

        @Override
        public final Builder eventTime(Instant eventTime) {
            this.eventTime = eventTime;
            return this;
        }

        public final String getCollaboratorName() {
            return this.collaboratorName;
        }

        public final void setCollaboratorName(String collaboratorName) {
            this.collaboratorName = collaboratorName;
        }

        @Override
        public final Builder collaboratorName(String collaboratorName) {
            this.collaboratorName = collaboratorName;
            return this;
        }

        public final String getAgentId() {
            return this.agentId;
        }

        public final void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        @Override
        public final Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public final String getAgentAliasId() {
            return this.agentAliasId;
        }

        public final void setAgentAliasId(String agentAliasId) {
            this.agentAliasId = agentAliasId;
        }

        @Override
        public final Builder agentAliasId(String agentAliasId) {
            this.agentAliasId = agentAliasId;
            return this;
        }

        public final String getAgentVersion() {
            return this.agentVersion;
        }

        public final void setAgentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
        }

        @Override
        public final Builder agentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            return this;
        }

        public TracePart build() {
            return new TracePart(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TracePart> {
        public Builder sessionId(String var1);

        public Builder trace(Trace var1);

        default public Builder trace(Consumer<Trace.Builder> trace) {
            return this.trace((Trace)((Trace.Builder)Trace.builder().applyMutation(trace)).build());
        }

        public Builder callerChain(Collection<Caller> var1);

        public Builder callerChain(Caller ... var1);

        public Builder callerChain(Consumer<Caller.Builder> ... var1);

        public Builder eventTime(Instant var1);

        public Builder collaboratorName(String var1);

        public Builder agentId(String var1);

        public Builder agentAliasId(String var1);

        public Builder agentVersion(String var1);
    }
}

