/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentruntime.model.FlowNodeIODataType;
import software.amazon.awssdk.services.bedrockagentruntime.model.NodeExecutionContent;
import software.amazon.awssdk.services.bedrockagentruntime.model.NodeOutputNext;
import software.amazon.awssdk.services.bedrockagentruntime.model.NodeOutputNextListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NodeOutputField
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NodeOutputField> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(NodeOutputField.getter(NodeOutputField::name)).setter(NodeOutputField.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<NodeExecutionContent> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("content").getter(NodeOutputField.getter(NodeOutputField::content)).setter(NodeOutputField.setter(Builder::content)).constructor(NodeExecutionContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()}).build();
    private static final SdkField<List<NodeOutputNext>> NEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("next").getter(NodeOutputField.getter(NodeOutputField::next)).setter(NodeOutputField.setter(Builder::next)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("next").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NodeOutputNext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(NodeOutputField.getter(NodeOutputField::typeAsString)).setter(NodeOutputField.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, CONTENT_FIELD, NEXT_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NodeOutputField.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final NodeExecutionContent content;
    private final List<NodeOutputNext> next;
    private final String type;

    private NodeOutputField(BuilderImpl builder) {
        this.name = builder.name;
        this.content = builder.content;
        this.next = builder.next;
        this.type = builder.type;
    }

    public final String name() {
        return this.name;
    }

    public final NodeExecutionContent content() {
        return this.content;
    }

    public final boolean hasNext() {
        return this.next != null && !(this.next instanceof SdkAutoConstructList);
    }

    public final List<NodeOutputNext> next() {
        return this.next;
    }

    public final FlowNodeIODataType type() {
        return FlowNodeIODataType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNext() ? this.next() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeOutputField)) {
            return false;
        }
        NodeOutputField other = (NodeOutputField)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.content(), other.content()) && this.hasNext() == other.hasNext() && Objects.equals(this.next(), other.next()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"NodeOutputField").add("Name", (Object)this.name()).add("Content", (Object)(this.content() == null ? null : "*** Sensitive Data Redacted ***")).add("Next", (Object)(this.next() == null ? null : "*** Sensitive Data Redacted ***")).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "next": {
                return Optional.ofNullable(clazz.cast(this.next()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("content", CONTENT_FIELD);
        map.put("next", NEXT_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NodeOutputField, T> g) {
        return obj -> g.apply((NodeOutputField)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private NodeExecutionContent content;
        private List<NodeOutputNext> next = DefaultSdkAutoConstructList.getInstance();
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(NodeOutputField model) {
            this.name(model.name);
            this.content(model.content);
            this.next(model.next);
            this.type(model.type);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final NodeExecutionContent.Builder getContent() {
            return this.content != null ? this.content.toBuilder() : null;
        }

        public final void setContent(NodeExecutionContent.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(NodeExecutionContent content) {
            this.content = content;
            return this;
        }

        public final List<NodeOutputNext.Builder> getNext() {
            List<NodeOutputNext.Builder> result = NodeOutputNextListCopier.copyToBuilder(this.next);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNext(Collection<NodeOutputNext.BuilderImpl> next) {
            this.next = NodeOutputNextListCopier.copyFromBuilder(next);
        }

        @Override
        public final Builder next(Collection<NodeOutputNext> next) {
            this.next = NodeOutputNextListCopier.copy(next);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder next(NodeOutputNext ... next) {
            this.next(Arrays.asList(next));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder next(Consumer<NodeOutputNext.Builder> ... next) {
            this.next(Stream.of(next).map(c -> (NodeOutputNext)((NodeOutputNext.Builder)NodeOutputNext.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FlowNodeIODataType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public NodeOutputField build() {
            return new NodeOutputField(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NodeOutputField> {
        public Builder name(String var1);

        public Builder content(NodeExecutionContent var1);

        default public Builder content(Consumer<NodeExecutionContent.Builder> content) {
            return this.content((NodeExecutionContent)((NodeExecutionContent.Builder)NodeExecutionContent.builder().applyMutation(content)).build());
        }

        public Builder next(Collection<NodeOutputNext> var1);

        public Builder next(NodeOutputNext ... var1);

        public Builder next(Consumer<NodeOutputNext.Builder> ... var1);

        public Builder type(String var1);

        public Builder type(FlowNodeIODataType var1);
    }
}

