/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FlowNodeIODataType {
    STRING("String"),
    NUMBER("Number"),
    BOOLEAN("Boolean"),
    OBJECT("Object"),
    ARRAY("Array"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FlowNodeIODataType> VALUE_MAP;
    private final String value;

    private FlowNodeIODataType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FlowNodeIODataType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FlowNodeIODataType> knownValues() {
        EnumSet<FlowNodeIODataType> knownValues = EnumSet.allOf(FlowNodeIODataType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FlowNodeIODataType.class, FlowNodeIODataType::toString);
    }
}

