/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentruntime.model.Caller;
import software.amazon.awssdk.services.bedrockagentruntime.model.CallerChainCopier;
import software.amazon.awssdk.services.bedrockagentruntime.model.InlineAgentResponseStream;
import software.amazon.awssdk.services.bedrockagentruntime.model.InvokeInlineAgentResponseHandler;
import software.amazon.awssdk.services.bedrockagentruntime.model.Trace;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InlineAgentTracePart
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InlineAgentTracePart>,
InlineAgentResponseStream {
    private static final SdkField<List<Caller>> CALLER_CHAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("callerChain").getter(InlineAgentTracePart.getter(InlineAgentTracePart::callerChain)).setter(InlineAgentTracePart.setter(Builder::callerChain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("callerChain").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Caller::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> COLLABORATOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("collaboratorName").getter(InlineAgentTracePart.getter(InlineAgentTracePart::collaboratorName)).setter(InlineAgentTracePart.setter(Builder::collaboratorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaboratorName").build()}).build();
    private static final SdkField<Instant> EVENT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("eventTime").getter(InlineAgentTracePart.getter(InlineAgentTracePart::eventTime)).setter(InlineAgentTracePart.setter(Builder::eventTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(InlineAgentTracePart.getter(InlineAgentTracePart::sessionId)).setter(InlineAgentTracePart.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()}).build();
    private static final SdkField<Trace> TRACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("trace").getter(InlineAgentTracePart.getter(InlineAgentTracePart::trace)).setter(InlineAgentTracePart.setter(Builder::trace)).constructor(Trace::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trace").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CALLER_CHAIN_FIELD, COLLABORATOR_NAME_FIELD, EVENT_TIME_FIELD, SESSION_ID_FIELD, TRACE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InlineAgentTracePart.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<Caller> callerChain;
    private final String collaboratorName;
    private final Instant eventTime;
    private final String sessionId;
    private final Trace trace;

    protected InlineAgentTracePart(BuilderImpl builder) {
        this.callerChain = builder.callerChain;
        this.collaboratorName = builder.collaboratorName;
        this.eventTime = builder.eventTime;
        this.sessionId = builder.sessionId;
        this.trace = builder.trace;
    }

    public final boolean hasCallerChain() {
        return this.callerChain != null && !(this.callerChain instanceof SdkAutoConstructList);
    }

    public final List<Caller> callerChain() {
        return this.callerChain;
    }

    public final String collaboratorName() {
        return this.collaboratorName;
    }

    public final Instant eventTime() {
        return this.eventTime;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final Trace trace() {
        return this.trace;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCallerChain() ? this.callerChain() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.collaboratorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.trace());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InlineAgentTracePart)) {
            return false;
        }
        InlineAgentTracePart other = (InlineAgentTracePart)obj;
        return this.hasCallerChain() == other.hasCallerChain() && Objects.equals(this.callerChain(), other.callerChain()) && Objects.equals(this.collaboratorName(), other.collaboratorName()) && Objects.equals(this.eventTime(), other.eventTime()) && Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.trace(), other.trace());
    }

    public final String toString() {
        return ToString.builder((String)"InlineAgentTracePart").add("CallerChain", this.hasCallerChain() ? this.callerChain() : null).add("CollaboratorName", (Object)(this.collaboratorName() == null ? null : "*** Sensitive Data Redacted ***")).add("EventTime", (Object)this.eventTime()).add("SessionId", (Object)this.sessionId()).add("Trace", (Object)(this.trace() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "callerChain": {
                return Optional.ofNullable(clazz.cast(this.callerChain()));
            }
            case "collaboratorName": {
                return Optional.ofNullable(clazz.cast(this.collaboratorName()));
            }
            case "eventTime": {
                return Optional.ofNullable(clazz.cast(this.eventTime()));
            }
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "trace": {
                return Optional.ofNullable(clazz.cast(this.trace()));
            }
        }
        return Optional.empty();
    }

    public final InlineAgentTracePart copy(Consumer<? super Builder> modifier) {
        return (InlineAgentTracePart)super.copy(modifier);
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("callerChain", CALLER_CHAIN_FIELD);
        map.put("collaboratorName", COLLABORATOR_NAME_FIELD);
        map.put("eventTime", EVENT_TIME_FIELD);
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("trace", TRACE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InlineAgentTracePart, T> g) {
        return obj -> g.apply((InlineAgentTracePart)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    @Override
    public void accept(InvokeInlineAgentResponseHandler.Visitor visitor) {
        throw new UnsupportedOperationException();
    }

    protected static class BuilderImpl
    implements Builder {
        private List<Caller> callerChain = DefaultSdkAutoConstructList.getInstance();
        private String collaboratorName;
        private Instant eventTime;
        private String sessionId;
        private Trace trace;

        protected BuilderImpl() {
        }

        protected BuilderImpl(InlineAgentTracePart model) {
            this.callerChain(model.callerChain);
            this.collaboratorName(model.collaboratorName);
            this.eventTime(model.eventTime);
            this.sessionId(model.sessionId);
            this.trace(model.trace);
        }

        public final List<Caller.Builder> getCallerChain() {
            List<Caller.Builder> result = CallerChainCopier.copyToBuilder(this.callerChain);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCallerChain(Collection<Caller.BuilderImpl> callerChain) {
            this.callerChain = CallerChainCopier.copyFromBuilder(callerChain);
        }

        @Override
        public final Builder callerChain(Collection<Caller> callerChain) {
            this.callerChain = CallerChainCopier.copy(callerChain);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder callerChain(Caller ... callerChain) {
            this.callerChain(Arrays.asList(callerChain));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder callerChain(Consumer<Caller.Builder> ... callerChain) {
            this.callerChain(Stream.of(callerChain).map(c -> (Caller)((Caller.Builder)Caller.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getCollaboratorName() {
            return this.collaboratorName;
        }

        public final void setCollaboratorName(String collaboratorName) {
            this.collaboratorName = collaboratorName;
        }

        @Override
        public final Builder collaboratorName(String collaboratorName) {
            this.collaboratorName = collaboratorName;
            return this;
        }

        public final Instant getEventTime() {
            return this.eventTime;
        }

        public final void setEventTime(Instant eventTime) {
            this.eventTime = eventTime;
        }

        @Override
        public final Builder eventTime(Instant eventTime) {
            this.eventTime = eventTime;
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final Trace.Builder getTrace() {
            return this.trace != null ? this.trace.toBuilder() : null;
        }

        public final void setTrace(Trace.BuilderImpl trace) {
            this.trace = trace != null ? trace.build() : null;
        }

        @Override
        public final Builder trace(Trace trace) {
            this.trace = trace;
            return this;
        }

        public InlineAgentTracePart build() {
            return new InlineAgentTracePart(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InlineAgentTracePart> {
        public Builder callerChain(Collection<Caller> var1);

        public Builder callerChain(Caller ... var1);

        public Builder callerChain(Consumer<Caller.Builder> ... var1);

        public Builder collaboratorName(String var1);

        public Builder eventTime(Instant var1);

        public Builder sessionId(String var1);

        public Builder trace(Trace var1);

        default public Builder trace(Consumer<Trace.Builder> trace) {
            return this.trace((Trace)((Trace.Builder)Trace.builder().applyMutation(trace)).build());
        }
    }
}

