/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentruntime.model.BedrockAgentRuntimeResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.SessionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSessionResponse
extends BedrockAgentRuntimeResponse
implements ToCopyableBuilder<Builder, UpdateSessionResponse> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(UpdateSessionResponse.getter(UpdateSessionResponse::createdAt)).setter(UpdateSessionResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedAt").getter(UpdateSessionResponse.getter(UpdateSessionResponse::lastUpdatedAt)).setter(UpdateSessionResponse.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> SESSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionArn").getter(UpdateSessionResponse.getter(UpdateSessionResponse::sessionArn)).setter(UpdateSessionResponse.setter(Builder::sessionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionArn").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(UpdateSessionResponse.getter(UpdateSessionResponse::sessionId)).setter(UpdateSessionResponse.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()}).build();
    private static final SdkField<String> SESSION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionStatus").getter(UpdateSessionResponse.getter(UpdateSessionResponse::sessionStatusAsString)).setter(UpdateSessionResponse.setter(Builder::sessionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD, SESSION_ARN_FIELD, SESSION_ID_FIELD, SESSION_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateSessionResponse.memberNameToFieldInitializer();
    private final Instant createdAt;
    private final Instant lastUpdatedAt;
    private final String sessionArn;
    private final String sessionId;
    private final String sessionStatus;

    private UpdateSessionResponse(BuilderImpl builder) {
        super(builder);
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.sessionArn = builder.sessionArn;
        this.sessionId = builder.sessionId;
        this.sessionStatus = builder.sessionStatus;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final String sessionArn() {
        return this.sessionArn;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final SessionStatus sessionStatus() {
        return SessionStatus.fromValue(this.sessionStatus);
    }

    public final String sessionStatusAsString() {
        return this.sessionStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSessionResponse)) {
            return false;
        }
        UpdateSessionResponse other = (UpdateSessionResponse)((Object)obj);
        return Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.sessionArn(), other.sessionArn()) && Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.sessionStatusAsString(), other.sessionStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateSessionResponse").add("CreatedAt", (Object)this.createdAt()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("SessionArn", (Object)this.sessionArn()).add("SessionId", (Object)this.sessionId()).add("SessionStatus", (Object)this.sessionStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "sessionArn": {
                return Optional.ofNullable(clazz.cast(this.sessionArn()));
            }
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "sessionStatus": {
                return Optional.ofNullable(clazz.cast(this.sessionStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("sessionArn", SESSION_ARN_FIELD);
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("sessionStatus", SESSION_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSessionResponse, T> g) {
        return obj -> g.apply((UpdateSessionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentRuntimeResponse.BuilderImpl
    implements Builder {
        private Instant createdAt;
        private Instant lastUpdatedAt;
        private String sessionArn;
        private String sessionId;
        private String sessionStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSessionResponse model) {
            super(model);
            this.createdAt(model.createdAt);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.sessionArn(model.sessionArn);
            this.sessionId(model.sessionId);
            this.sessionStatus(model.sessionStatus);
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getSessionArn() {
            return this.sessionArn;
        }

        public final void setSessionArn(String sessionArn) {
            this.sessionArn = sessionArn;
        }

        @Override
        public final Builder sessionArn(String sessionArn) {
            this.sessionArn = sessionArn;
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getSessionStatus() {
            return this.sessionStatus;
        }

        public final void setSessionStatus(String sessionStatus) {
            this.sessionStatus = sessionStatus;
        }

        @Override
        public final Builder sessionStatus(String sessionStatus) {
            this.sessionStatus = sessionStatus;
            return this;
        }

        @Override
        public final Builder sessionStatus(SessionStatus sessionStatus) {
            this.sessionStatus(sessionStatus == null ? null : sessionStatus.toString());
            return this;
        }

        @Override
        public UpdateSessionResponse build() {
            return new UpdateSessionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BedrockAgentRuntimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSessionResponse> {
        public Builder createdAt(Instant var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder sessionArn(String var1);

        public Builder sessionId(String var1);

        public Builder sessionStatus(String var1);

        public Builder sessionStatus(SessionStatus var1);
    }
}

