/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagentruntime.BedrockAgentRuntimeAsyncClient;
import software.amazon.awssdk.services.bedrockagentruntime.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagentruntime.model.InvocationStepSummary;
import software.amazon.awssdk.services.bedrockagentruntime.model.ListInvocationStepsRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.ListInvocationStepsResponse;

public class ListInvocationStepsPublisher
implements SdkPublisher<ListInvocationStepsResponse> {
    private final BedrockAgentRuntimeAsyncClient client;
    private final ListInvocationStepsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListInvocationStepsPublisher(BedrockAgentRuntimeAsyncClient client, ListInvocationStepsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListInvocationStepsPublisher(BedrockAgentRuntimeAsyncClient client, ListInvocationStepsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListInvocationStepsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListInvocationStepsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<InvocationStepSummary> invocationStepSummaries() {
        Function<ListInvocationStepsResponse, Iterator> getIterator = response -> {
            if (response != null && response.invocationStepSummaries() != null) {
                return response.invocationStepSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListInvocationStepsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListInvocationStepsResponseFetcher
    implements AsyncPageFetcher<ListInvocationStepsResponse> {
        private ListInvocationStepsResponseFetcher() {
        }

        public boolean hasNextPage(ListInvocationStepsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListInvocationStepsResponse> nextPage(ListInvocationStepsResponse previousPage) {
            if (previousPage == null) {
                return ListInvocationStepsPublisher.this.client.listInvocationSteps(ListInvocationStepsPublisher.this.firstRequest);
            }
            return ListInvocationStepsPublisher.this.client.listInvocationSteps((ListInvocationStepsRequest)((Object)ListInvocationStepsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

