/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockagentruntime.model.TextPrompt;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InputPrompt
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InputPrompt> {
    private static final SdkField<TextPrompt> TEXT_PROMPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("textPrompt").getter(InputPrompt.getter(InputPrompt::textPrompt)).setter(InputPrompt.setter(Builder::textPrompt)).constructor(TextPrompt::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("textPrompt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_PROMPT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InputPrompt.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final TextPrompt textPrompt;
    private final Type type;

    private InputPrompt(BuilderImpl builder) {
        this.textPrompt = builder.textPrompt;
        this.type = builder.type;
    }

    public final TextPrompt textPrompt() {
        return this.textPrompt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.textPrompt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputPrompt)) {
            return false;
        }
        InputPrompt other = (InputPrompt)obj;
        return Objects.equals(this.textPrompt(), other.textPrompt());
    }

    public final String toString() {
        return ToString.builder((String)"InputPrompt").add("TextPrompt", (Object)(this.textPrompt() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "textPrompt": {
                return Optional.ofNullable(clazz.cast(this.textPrompt()));
            }
        }
        return Optional.empty();
    }

    public static InputPrompt fromTextPrompt(TextPrompt textPrompt) {
        return (InputPrompt)InputPrompt.builder().textPrompt(textPrompt).build();
    }

    public static InputPrompt fromTextPrompt(Consumer<TextPrompt.Builder> textPrompt) {
        TextPrompt.Builder builder = TextPrompt.builder();
        textPrompt.accept(builder);
        return InputPrompt.fromTextPrompt((TextPrompt)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<TextPrompt>> map = new HashMap<String, SdkField<TextPrompt>>();
        map.put("textPrompt", TEXT_PROMPT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InputPrompt, T> g) {
        return obj -> g.apply((InputPrompt)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        TEXT_PROMPT,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private TextPrompt textPrompt;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(InputPrompt model) {
            this.textPrompt(model.textPrompt);
        }

        public final TextPrompt.Builder getTextPrompt() {
            return this.textPrompt != null ? this.textPrompt.toBuilder() : null;
        }

        public final void setTextPrompt(TextPrompt.BuilderImpl textPrompt) {
            TextPrompt oldValue = this.textPrompt;
            this.textPrompt = textPrompt != null ? textPrompt.build() : null;
            this.handleUnionValueChange(Type.TEXT_PROMPT, oldValue, this.textPrompt);
        }

        @Override
        public final Builder textPrompt(TextPrompt textPrompt) {
            TextPrompt oldValue = this.textPrompt;
            this.textPrompt = textPrompt;
            this.handleUnionValueChange(Type.TEXT_PROMPT, oldValue, this.textPrompt);
            return this;
        }

        public InputPrompt build() {
            return new InputPrompt(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InputPrompt> {
        public Builder textPrompt(TextPrompt var1);

        default public Builder textPrompt(Consumer<TextPrompt.Builder> textPrompt) {
            return this.textPrompt((TextPrompt)((TextPrompt.Builder)TextPrompt.builder().applyMutation(textPrompt)).build());
        }
    }
}

