/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentruntime.model.GuardrailTopic;
import software.amazon.awssdk.services.bedrockagentruntime.model.GuardrailTopicListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GuardrailTopicPolicyAssessment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GuardrailTopicPolicyAssessment> {
    private static final SdkField<List<GuardrailTopic>> TOPICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("topics").getter(GuardrailTopicPolicyAssessment.getter(GuardrailTopicPolicyAssessment::topics)).setter(GuardrailTopicPolicyAssessment.setter(Builder::topics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GuardrailTopic::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOPICS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("topics", TOPICS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<GuardrailTopic> topics;

    private GuardrailTopicPolicyAssessment(BuilderImpl builder) {
        this.topics = builder.topics;
    }

    public final boolean hasTopics() {
        return this.topics != null && !(this.topics instanceof SdkAutoConstructList);
    }

    public final List<GuardrailTopic> topics() {
        return this.topics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTopics() ? this.topics() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailTopicPolicyAssessment)) {
            return false;
        }
        GuardrailTopicPolicyAssessment other = (GuardrailTopicPolicyAssessment)obj;
        return this.hasTopics() == other.hasTopics() && Objects.equals(this.topics(), other.topics());
    }

    public final String toString() {
        return ToString.builder((String)"GuardrailTopicPolicyAssessment").add("Topics", (Object)(this.topics() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "topics": {
                return Optional.ofNullable(clazz.cast(this.topics()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GuardrailTopicPolicyAssessment, T> g) {
        return obj -> g.apply((GuardrailTopicPolicyAssessment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<GuardrailTopic> topics = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailTopicPolicyAssessment model) {
            this.topics(model.topics);
        }

        public final List<GuardrailTopic.Builder> getTopics() {
            List<GuardrailTopic.Builder> result = GuardrailTopicListCopier.copyToBuilder(this.topics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTopics(Collection<GuardrailTopic.BuilderImpl> topics) {
            this.topics = GuardrailTopicListCopier.copyFromBuilder(topics);
        }

        @Override
        public final Builder topics(Collection<GuardrailTopic> topics) {
            this.topics = GuardrailTopicListCopier.copy(topics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topics(GuardrailTopic ... topics) {
            this.topics(Arrays.asList(topics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topics(Consumer<GuardrailTopic.Builder> ... topics) {
            this.topics(Stream.of(topics).map(c -> (GuardrailTopic)((GuardrailTopic.Builder)GuardrailTopic.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public GuardrailTopicPolicyAssessment build() {
            return new GuardrailTopicPolicyAssessment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GuardrailTopicPolicyAssessment> {
        public Builder topics(Collection<GuardrailTopic> var1);

        public Builder topics(GuardrailTopic ... var1);

        public Builder topics(Consumer<GuardrailTopic.Builder> ... var1);
    }
}

