/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ByteContentFile
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ByteContentFile> {
    private static final SdkField<SdkBytes> DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("data").getter(ByteContentFile.getter(ByteContentFile::data)).setter(ByteContentFile.setter(Builder::data)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("data").build()}).build();
    private static final SdkField<String> MEDIA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mediaType").getter(ByteContentFile.getter(ByteContentFile::mediaType)).setter(ByteContentFile.setter(Builder::mediaType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_FIELD, MEDIA_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final SdkBytes data;
    private final String mediaType;

    private ByteContentFile(BuilderImpl builder) {
        this.data = builder.data;
        this.mediaType = builder.mediaType;
    }

    public final SdkBytes data() {
        return this.data;
    }

    public final String mediaType() {
        return this.mediaType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.data());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ByteContentFile)) {
            return false;
        }
        ByteContentFile other = (ByteContentFile)obj;
        return Objects.equals(this.data(), other.data()) && Objects.equals(this.mediaType(), other.mediaType());
    }

    public final String toString() {
        return ToString.builder((String)"ByteContentFile").add("Data", (Object)(this.data() == null ? null : "*** Sensitive Data Redacted ***")).add("MediaType", (Object)this.mediaType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "data": {
                return Optional.ofNullable(clazz.cast(this.data()));
            }
            case "mediaType": {
                return Optional.ofNullable(clazz.cast(this.mediaType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ByteContentFile, T> g) {
        return obj -> g.apply((ByteContentFile)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SdkBytes data;
        private String mediaType;

        private BuilderImpl() {
        }

        private BuilderImpl(ByteContentFile model) {
            this.data(model.data);
            this.mediaType(model.mediaType);
        }

        public final ByteBuffer getData() {
            return this.data == null ? null : this.data.asByteBuffer();
        }

        public final void setData(ByteBuffer data) {
            this.data(data == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)data));
        }

        @Override
        public final Builder data(SdkBytes data) {
            this.data = data;
            return this;
        }

        public final String getMediaType() {
            return this.mediaType;
        }

        public final void setMediaType(String mediaType) {
            this.mediaType = mediaType;
        }

        @Override
        public final Builder mediaType(String mediaType) {
            this.mediaType = mediaType;
            return this;
        }

        public ByteContentFile build() {
            return new ByteContentFile(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ByteContentFile> {
        public Builder data(SdkBytes var1);

        public Builder mediaType(String var1);
    }
}

