/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The foundation model output from the pre-processing step.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PreProcessingModelInvocationOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<PreProcessingModelInvocationOutput.Builder, PreProcessingModelInvocationOutput> {
    private static final SdkField<PreProcessingParsedResponse> PARSED_RESPONSE_FIELD = SdkField
            .<PreProcessingParsedResponse> builder(MarshallingType.SDK_POJO).memberName("parsedResponse")
            .getter(getter(PreProcessingModelInvocationOutput::parsedResponse)).setter(setter(Builder::parsedResponse))
            .constructor(PreProcessingParsedResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parsedResponse").build()).build();

    private static final SdkField<String> TRACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("traceId").getter(getter(PreProcessingModelInvocationOutput::traceId)).setter(setter(Builder::traceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("traceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARSED_RESPONSE_FIELD,
            TRACE_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final PreProcessingParsedResponse parsedResponse;

    private final String traceId;

    private PreProcessingModelInvocationOutput(BuilderImpl builder) {
        this.parsedResponse = builder.parsedResponse;
        this.traceId = builder.traceId;
    }

    /**
     * <p>
     * Details about the response from the Lambda parsing of the output of the pre-processing step.
     * </p>
     * 
     * @return Details about the response from the Lambda parsing of the output of the pre-processing step.
     */
    public final PreProcessingParsedResponse parsedResponse() {
        return parsedResponse;
    }

    /**
     * <p>
     * The unique identifier of the trace.
     * </p>
     * 
     * @return The unique identifier of the trace.
     */
    public final String traceId() {
        return traceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(parsedResponse());
        hashCode = 31 * hashCode + Objects.hashCode(traceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PreProcessingModelInvocationOutput)) {
            return false;
        }
        PreProcessingModelInvocationOutput other = (PreProcessingModelInvocationOutput) obj;
        return Objects.equals(parsedResponse(), other.parsedResponse()) && Objects.equals(traceId(), other.traceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PreProcessingModelInvocationOutput")
                .add("ParsedResponse", parsedResponse() == null ? null : "*** Sensitive Data Redacted ***")
                .add("TraceId", traceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "parsedResponse":
            return Optional.ofNullable(clazz.cast(parsedResponse()));
        case "traceId":
            return Optional.ofNullable(clazz.cast(traceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PreProcessingModelInvocationOutput, T> g) {
        return obj -> g.apply((PreProcessingModelInvocationOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PreProcessingModelInvocationOutput> {
        /**
         * <p>
         * Details about the response from the Lambda parsing of the output of the pre-processing step.
         * </p>
         * 
         * @param parsedResponse
         *        Details about the response from the Lambda parsing of the output of the pre-processing step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parsedResponse(PreProcessingParsedResponse parsedResponse);

        /**
         * <p>
         * Details about the response from the Lambda parsing of the output of the pre-processing step.
         * </p>
         * This is a convenience method that creates an instance of the {@link PreProcessingParsedResponse.Builder}
         * avoiding the need to create one manually via {@link PreProcessingParsedResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PreProcessingParsedResponse.Builder#build()} is called
         * immediately and its result is passed to {@link #parsedResponse(PreProcessingParsedResponse)}.
         * 
         * @param parsedResponse
         *        a consumer that will call methods on {@link PreProcessingParsedResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parsedResponse(PreProcessingParsedResponse)
         */
        default Builder parsedResponse(Consumer<PreProcessingParsedResponse.Builder> parsedResponse) {
            return parsedResponse(PreProcessingParsedResponse.builder().applyMutation(parsedResponse).build());
        }

        /**
         * <p>
         * The unique identifier of the trace.
         * </p>
         * 
         * @param traceId
         *        The unique identifier of the trace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder traceId(String traceId);
    }

    static final class BuilderImpl implements Builder {
        private PreProcessingParsedResponse parsedResponse;

        private String traceId;

        private BuilderImpl() {
        }

        private BuilderImpl(PreProcessingModelInvocationOutput model) {
            parsedResponse(model.parsedResponse);
            traceId(model.traceId);
        }

        public final PreProcessingParsedResponse.Builder getParsedResponse() {
            return parsedResponse != null ? parsedResponse.toBuilder() : null;
        }

        public final void setParsedResponse(PreProcessingParsedResponse.BuilderImpl parsedResponse) {
            this.parsedResponse = parsedResponse != null ? parsedResponse.build() : null;
        }

        @Override
        public final Builder parsedResponse(PreProcessingParsedResponse parsedResponse) {
            this.parsedResponse = parsedResponse;
            return this;
        }

        public final String getTraceId() {
            return traceId;
        }

        public final void setTraceId(String traceId) {
            this.traceId = traceId;
        }

        @Override
        public final Builder traceId(String traceId) {
            this.traceId = traceId;
            return this;
        }

        @Override
        public PreProcessingModelInvocationOutput build() {
            return new PreProcessingModelInvocationOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
