/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the generation configuration of the external source wrapper object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExternalSourcesGenerationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ExternalSourcesGenerationConfiguration.Builder, ExternalSourcesGenerationConfiguration> {
    private static final SdkField<PromptTemplate> PROMPT_TEMPLATE_FIELD = SdkField
            .<PromptTemplate> builder(MarshallingType.SDK_POJO).memberName("promptTemplate")
            .getter(getter(ExternalSourcesGenerationConfiguration::promptTemplate)).setter(setter(Builder::promptTemplate))
            .constructor(PromptTemplate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptTemplate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROMPT_TEMPLATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final PromptTemplate promptTemplate;

    private ExternalSourcesGenerationConfiguration(BuilderImpl builder) {
        this.promptTemplate = builder.promptTemplate;
    }

    /**
     * <p>
     * Contain the textPromptTemplate string for the external source wrapper object.
     * </p>
     * 
     * @return Contain the textPromptTemplate string for the external source wrapper object.
     */
    public final PromptTemplate promptTemplate() {
        return promptTemplate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(promptTemplate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExternalSourcesGenerationConfiguration)) {
            return false;
        }
        ExternalSourcesGenerationConfiguration other = (ExternalSourcesGenerationConfiguration) obj;
        return Objects.equals(promptTemplate(), other.promptTemplate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExternalSourcesGenerationConfiguration").add("PromptTemplate", promptTemplate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "promptTemplate":
            return Optional.ofNullable(clazz.cast(promptTemplate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExternalSourcesGenerationConfiguration, T> g) {
        return obj -> g.apply((ExternalSourcesGenerationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExternalSourcesGenerationConfiguration> {
        /**
         * <p>
         * Contain the textPromptTemplate string for the external source wrapper object.
         * </p>
         * 
         * @param promptTemplate
         *        Contain the textPromptTemplate string for the external source wrapper object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder promptTemplate(PromptTemplate promptTemplate);

        /**
         * <p>
         * Contain the textPromptTemplate string for the external source wrapper object.
         * </p>
         * This is a convenience method that creates an instance of the {@link PromptTemplate.Builder} avoiding the need
         * to create one manually via {@link PromptTemplate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PromptTemplate.Builder#build()} is called immediately and its
         * result is passed to {@link #promptTemplate(PromptTemplate)}.
         * 
         * @param promptTemplate
         *        a consumer that will call methods on {@link PromptTemplate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #promptTemplate(PromptTemplate)
         */
        default Builder promptTemplate(Consumer<PromptTemplate.Builder> promptTemplate) {
            return promptTemplate(PromptTemplate.builder().applyMutation(promptTemplate).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private PromptTemplate promptTemplate;

        private BuilderImpl() {
        }

        private BuilderImpl(ExternalSourcesGenerationConfiguration model) {
            promptTemplate(model.promptTemplate);
        }

        public final PromptTemplate.Builder getPromptTemplate() {
            return promptTemplate != null ? promptTemplate.toBuilder() : null;
        }

        public final void setPromptTemplate(PromptTemplate.BuilderImpl promptTemplate) {
            this.promptTemplate = promptTemplate != null ? promptTemplate.build() : null;
        }

        @Override
        public final Builder promptTemplate(PromptTemplate promptTemplate) {
            this.promptTemplate = promptTemplate;
            return this;
        }

        @Override
        public ExternalSourcesGenerationConfiguration build() {
            return new ExternalSourcesGenerationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
