/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RetrieveRequest extends BedrockAgentRuntimeRequest implements
        ToCopyableBuilder<RetrieveRequest.Builder, RetrieveRequest> {
    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("knowledgeBaseId").getter(getter(RetrieveRequest::knowledgeBaseId))
            .setter(setter(Builder::knowledgeBaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("knowledgeBaseId").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(RetrieveRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<KnowledgeBaseRetrievalConfiguration> RETRIEVAL_CONFIGURATION_FIELD = SdkField
            .<KnowledgeBaseRetrievalConfiguration> builder(MarshallingType.SDK_POJO).memberName("retrievalConfiguration")
            .getter(getter(RetrieveRequest::retrievalConfiguration)).setter(setter(Builder::retrievalConfiguration))
            .constructor(KnowledgeBaseRetrievalConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retrievalConfiguration").build())
            .build();

    private static final SdkField<KnowledgeBaseQuery> RETRIEVAL_QUERY_FIELD = SdkField
            .<KnowledgeBaseQuery> builder(MarshallingType.SDK_POJO).memberName("retrievalQuery")
            .getter(getter(RetrieveRequest::retrievalQuery)).setter(setter(Builder::retrievalQuery))
            .constructor(KnowledgeBaseQuery::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retrievalQuery").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KNOWLEDGE_BASE_ID_FIELD,
            NEXT_TOKEN_FIELD, RETRIEVAL_CONFIGURATION_FIELD, RETRIEVAL_QUERY_FIELD));

    private final String knowledgeBaseId;

    private final String nextToken;

    private final KnowledgeBaseRetrievalConfiguration retrievalConfiguration;

    private final KnowledgeBaseQuery retrievalQuery;

    private RetrieveRequest(BuilderImpl builder) {
        super(builder);
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.nextToken = builder.nextToken;
        this.retrievalConfiguration = builder.retrievalConfiguration;
        this.retrievalQuery = builder.retrievalQuery;
    }

    /**
     * <p>
     * The unique identifier of the knowledge base to query.
     * </p>
     * 
     * @return The unique identifier of the knowledge base to query.
     */
    public final String knowledgeBaseId() {
        return knowledgeBaseId;
    }

    /**
     * <p>
     * If there are more results than can fit in the response, the response returns a <code>nextToken</code>. Use this
     * token in the <code>nextToken</code> field of another request to retrieve the next batch of results.
     * </p>
     * 
     * @return If there are more results than can fit in the response, the response returns a <code>nextToken</code>.
     *         Use this token in the <code>nextToken</code> field of another request to retrieve the next batch of
     *         results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Contains details about how the results should be returned.
     * </p>
     * 
     * @return Contains details about how the results should be returned.
     */
    public final KnowledgeBaseRetrievalConfiguration retrievalConfiguration() {
        return retrievalConfiguration;
    }

    /**
     * <p>
     * The query to send the knowledge base.
     * </p>
     * 
     * @return The query to send the knowledge base.
     */
    public final KnowledgeBaseQuery retrievalQuery() {
        return retrievalQuery;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(retrievalConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(retrievalQuery());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetrieveRequest)) {
            return false;
        }
        RetrieveRequest other = (RetrieveRequest) obj;
        return Objects.equals(knowledgeBaseId(), other.knowledgeBaseId()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(retrievalConfiguration(), other.retrievalConfiguration())
                && Objects.equals(retrievalQuery(), other.retrievalQuery());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RetrieveRequest").add("KnowledgeBaseId", knowledgeBaseId()).add("NextToken", nextToken())
                .add("RetrievalConfiguration", retrievalConfiguration())
                .add("RetrievalQuery", retrievalQuery() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "knowledgeBaseId":
            return Optional.ofNullable(clazz.cast(knowledgeBaseId()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "retrievalConfiguration":
            return Optional.ofNullable(clazz.cast(retrievalConfiguration()));
        case "retrievalQuery":
            return Optional.ofNullable(clazz.cast(retrievalQuery()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RetrieveRequest, T> g) {
        return obj -> g.apply((RetrieveRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockAgentRuntimeRequest.Builder, SdkPojo, CopyableBuilder<Builder, RetrieveRequest> {
        /**
         * <p>
         * The unique identifier of the knowledge base to query.
         * </p>
         * 
         * @param knowledgeBaseId
         *        The unique identifier of the knowledge base to query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseId(String knowledgeBaseId);

        /**
         * <p>
         * If there are more results than can fit in the response, the response returns a <code>nextToken</code>. Use
         * this token in the <code>nextToken</code> field of another request to retrieve the next batch of results.
         * </p>
         * 
         * @param nextToken
         *        If there are more results than can fit in the response, the response returns a <code>nextToken</code>.
         *        Use this token in the <code>nextToken</code> field of another request to retrieve the next batch of
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Contains details about how the results should be returned.
         * </p>
         * 
         * @param retrievalConfiguration
         *        Contains details about how the results should be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retrievalConfiguration(KnowledgeBaseRetrievalConfiguration retrievalConfiguration);

        /**
         * <p>
         * Contains details about how the results should be returned.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link KnowledgeBaseRetrievalConfiguration.Builder} avoiding the need to create one manually via
         * {@link KnowledgeBaseRetrievalConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KnowledgeBaseRetrievalConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #retrievalConfiguration(KnowledgeBaseRetrievalConfiguration)}.
         * 
         * @param retrievalConfiguration
         *        a consumer that will call methods on {@link KnowledgeBaseRetrievalConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retrievalConfiguration(KnowledgeBaseRetrievalConfiguration)
         */
        default Builder retrievalConfiguration(Consumer<KnowledgeBaseRetrievalConfiguration.Builder> retrievalConfiguration) {
            return retrievalConfiguration(KnowledgeBaseRetrievalConfiguration.builder().applyMutation(retrievalConfiguration)
                    .build());
        }

        /**
         * <p>
         * The query to send the knowledge base.
         * </p>
         * 
         * @param retrievalQuery
         *        The query to send the knowledge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retrievalQuery(KnowledgeBaseQuery retrievalQuery);

        /**
         * <p>
         * The query to send the knowledge base.
         * </p>
         * This is a convenience method that creates an instance of the {@link KnowledgeBaseQuery.Builder} avoiding the
         * need to create one manually via {@link KnowledgeBaseQuery#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KnowledgeBaseQuery.Builder#build()} is called immediately and its
         * result is passed to {@link #retrievalQuery(KnowledgeBaseQuery)}.
         * 
         * @param retrievalQuery
         *        a consumer that will call methods on {@link KnowledgeBaseQuery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retrievalQuery(KnowledgeBaseQuery)
         */
        default Builder retrievalQuery(Consumer<KnowledgeBaseQuery.Builder> retrievalQuery) {
            return retrievalQuery(KnowledgeBaseQuery.builder().applyMutation(retrievalQuery).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockAgentRuntimeRequest.BuilderImpl implements Builder {
        private String knowledgeBaseId;

        private String nextToken;

        private KnowledgeBaseRetrievalConfiguration retrievalConfiguration;

        private KnowledgeBaseQuery retrievalQuery;

        private BuilderImpl() {
        }

        private BuilderImpl(RetrieveRequest model) {
            super(model);
            knowledgeBaseId(model.knowledgeBaseId);
            nextToken(model.nextToken);
            retrievalConfiguration(model.retrievalConfiguration);
            retrievalQuery(model.retrievalQuery);
        }

        public final String getKnowledgeBaseId() {
            return knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final KnowledgeBaseRetrievalConfiguration.Builder getRetrievalConfiguration() {
            return retrievalConfiguration != null ? retrievalConfiguration.toBuilder() : null;
        }

        public final void setRetrievalConfiguration(KnowledgeBaseRetrievalConfiguration.BuilderImpl retrievalConfiguration) {
            this.retrievalConfiguration = retrievalConfiguration != null ? retrievalConfiguration.build() : null;
        }

        @Override
        public final Builder retrievalConfiguration(KnowledgeBaseRetrievalConfiguration retrievalConfiguration) {
            this.retrievalConfiguration = retrievalConfiguration;
            return this;
        }

        public final KnowledgeBaseQuery.Builder getRetrievalQuery() {
            return retrievalQuery != null ? retrievalQuery.toBuilder() : null;
        }

        public final void setRetrievalQuery(KnowledgeBaseQuery.BuilderImpl retrievalQuery) {
            this.retrievalQuery = retrievalQuery != null ? retrievalQuery.build() : null;
        }

        @Override
        public final Builder retrievalQuery(KnowledgeBaseQuery retrievalQuery) {
            this.retrievalQuery = retrievalQuery;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RetrieveRequest build() {
            return new RetrieveRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
