/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about the resource being queried.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RetrieveAndGenerateConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<RetrieveAndGenerateConfiguration.Builder, RetrieveAndGenerateConfiguration> {
    private static final SdkField<KnowledgeBaseRetrieveAndGenerateConfiguration> KNOWLEDGE_BASE_CONFIGURATION_FIELD = SdkField
            .<KnowledgeBaseRetrieveAndGenerateConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("knowledgeBaseConfiguration")
            .getter(getter(RetrieveAndGenerateConfiguration::knowledgeBaseConfiguration))
            .setter(setter(Builder::knowledgeBaseConfiguration))
            .constructor(KnowledgeBaseRetrieveAndGenerateConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseConfiguration").build())
            .build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(RetrieveAndGenerateConfiguration::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            KNOWLEDGE_BASE_CONFIGURATION_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final KnowledgeBaseRetrieveAndGenerateConfiguration knowledgeBaseConfiguration;

    private final String type;

    private RetrieveAndGenerateConfiguration(BuilderImpl builder) {
        this.knowledgeBaseConfiguration = builder.knowledgeBaseConfiguration;
        this.type = builder.type;
    }

    /**
     * <p>
     * Contains details about the resource being queried.
     * </p>
     * 
     * @return Contains details about the resource being queried.
     */
    public final KnowledgeBaseRetrieveAndGenerateConfiguration knowledgeBaseConfiguration() {
        return knowledgeBaseConfiguration;
    }

    /**
     * <p>
     * The type of resource that is queried by the request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RetrieveAndGenerateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of resource that is queried by the request.
     * @see RetrieveAndGenerateType
     */
    public final RetrieveAndGenerateType type() {
        return RetrieveAndGenerateType.fromValue(type);
    }

    /**
     * <p>
     * The type of resource that is queried by the request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RetrieveAndGenerateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of resource that is queried by the request.
     * @see RetrieveAndGenerateType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetrieveAndGenerateConfiguration)) {
            return false;
        }
        RetrieveAndGenerateConfiguration other = (RetrieveAndGenerateConfiguration) obj;
        return Objects.equals(knowledgeBaseConfiguration(), other.knowledgeBaseConfiguration())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RetrieveAndGenerateConfiguration")
                .add("KnowledgeBaseConfiguration", knowledgeBaseConfiguration()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "knowledgeBaseConfiguration":
            return Optional.ofNullable(clazz.cast(knowledgeBaseConfiguration()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RetrieveAndGenerateConfiguration, T> g) {
        return obj -> g.apply((RetrieveAndGenerateConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RetrieveAndGenerateConfiguration> {
        /**
         * <p>
         * Contains details about the resource being queried.
         * </p>
         * 
         * @param knowledgeBaseConfiguration
         *        Contains details about the resource being queried.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseConfiguration(KnowledgeBaseRetrieveAndGenerateConfiguration knowledgeBaseConfiguration);

        /**
         * <p>
         * Contains details about the resource being queried.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link KnowledgeBaseRetrieveAndGenerateConfiguration.Builder} avoiding the need to create one manually via
         * {@link KnowledgeBaseRetrieveAndGenerateConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KnowledgeBaseRetrieveAndGenerateConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #knowledgeBaseConfiguration(KnowledgeBaseRetrieveAndGenerateConfiguration)}.
         * 
         * @param knowledgeBaseConfiguration
         *        a consumer that will call methods on {@link KnowledgeBaseRetrieveAndGenerateConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #knowledgeBaseConfiguration(KnowledgeBaseRetrieveAndGenerateConfiguration)
         */
        default Builder knowledgeBaseConfiguration(
                Consumer<KnowledgeBaseRetrieveAndGenerateConfiguration.Builder> knowledgeBaseConfiguration) {
            return knowledgeBaseConfiguration(KnowledgeBaseRetrieveAndGenerateConfiguration.builder()
                    .applyMutation(knowledgeBaseConfiguration).build());
        }

        /**
         * <p>
         * The type of resource that is queried by the request.
         * </p>
         * 
         * @param type
         *        The type of resource that is queried by the request.
         * @see RetrieveAndGenerateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetrieveAndGenerateType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of resource that is queried by the request.
         * </p>
         * 
         * @param type
         *        The type of resource that is queried by the request.
         * @see RetrieveAndGenerateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetrieveAndGenerateType
         */
        Builder type(RetrieveAndGenerateType type);
    }

    static final class BuilderImpl implements Builder {
        private KnowledgeBaseRetrieveAndGenerateConfiguration knowledgeBaseConfiguration;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(RetrieveAndGenerateConfiguration model) {
            knowledgeBaseConfiguration(model.knowledgeBaseConfiguration);
            type(model.type);
        }

        public final KnowledgeBaseRetrieveAndGenerateConfiguration.Builder getKnowledgeBaseConfiguration() {
            return knowledgeBaseConfiguration != null ? knowledgeBaseConfiguration.toBuilder() : null;
        }

        public final void setKnowledgeBaseConfiguration(
                KnowledgeBaseRetrieveAndGenerateConfiguration.BuilderImpl knowledgeBaseConfiguration) {
            this.knowledgeBaseConfiguration = knowledgeBaseConfiguration != null ? knowledgeBaseConfiguration.build() : null;
        }

        @Override
        public final Builder knowledgeBaseConfiguration(KnowledgeBaseRetrieveAndGenerateConfiguration knowledgeBaseConfiguration) {
            this.knowledgeBaseConfiguration = knowledgeBaseConfiguration;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RetrieveAndGenerateType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public RetrieveAndGenerateConfiguration build() {
            return new RetrieveAndGenerateConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
