/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configurations for how to carry out the search.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KnowledgeBaseVectorSearchConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<KnowledgeBaseVectorSearchConfiguration.Builder, KnowledgeBaseVectorSearchConfiguration> {
    private static final SdkField<Integer> NUMBER_OF_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("numberOfResults").getter(getter(KnowledgeBaseVectorSearchConfiguration::numberOfResults))
            .setter(setter(Builder::numberOfResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfResults").build()).build();

    private static final SdkField<String> OVERRIDE_SEARCH_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("overrideSearchType").getter(getter(KnowledgeBaseVectorSearchConfiguration::overrideSearchTypeAsString))
            .setter(setter(Builder::overrideSearchType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrideSearchType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUMBER_OF_RESULTS_FIELD,
            OVERRIDE_SEARCH_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer numberOfResults;

    private final String overrideSearchType;

    private KnowledgeBaseVectorSearchConfiguration(BuilderImpl builder) {
        this.numberOfResults = builder.numberOfResults;
        this.overrideSearchType = builder.overrideSearchType;
    }

    /**
     * <p>
     * The number of results to return.
     * </p>
     * <note>
     * <p>
     * The <code>numberOfResults</code> field is currently unsupported for <code>RetrieveAndGenerate</code>. Don't
     * include it in this field if you are sending a <code>RetrieveAndGenerate</code> request.
     * </p>
     * </note>
     * 
     * @return The number of results to return.</p> <note>
     *         <p>
     *         The <code>numberOfResults</code> field is currently unsupported for <code>RetrieveAndGenerate</code>.
     *         Don't include it in this field if you are sending a <code>RetrieveAndGenerate</code> request.
     *         </p>
     */
    public final Integer numberOfResults() {
        return numberOfResults;
    }

    /**
     * <p>
     * By default, Amazon Bedrock decides a search strategy for you. If you're using an Amazon OpenSearch Serverless
     * vector store that contains a filterable text field, you can specify whether to query the knowledge base with a
     * <code>HYBRID</code> search using both vector embeddings and raw text, or <code>SEMANTIC</code> search using only
     * vector embeddings. For other vector store configurations, only <code>SEMANTIC</code> search is available. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-test.html">Test a knowledge base</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #overrideSearchType} will return {@link SearchType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #overrideSearchTypeAsString}.
     * </p>
     * 
     * @return By default, Amazon Bedrock decides a search strategy for you. If you're using an Amazon OpenSearch
     *         Serverless vector store that contains a filterable text field, you can specify whether to query the
     *         knowledge base with a <code>HYBRID</code> search using both vector embeddings and raw text, or
     *         <code>SEMANTIC</code> search using only vector embeddings. For other vector store configurations, only
     *         <code>SEMANTIC</code> search is available. For more information, see <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-test.html">Test a knowledge
     *         base</a>.
     * @see SearchType
     */
    public final SearchType overrideSearchType() {
        return SearchType.fromValue(overrideSearchType);
    }

    /**
     * <p>
     * By default, Amazon Bedrock decides a search strategy for you. If you're using an Amazon OpenSearch Serverless
     * vector store that contains a filterable text field, you can specify whether to query the knowledge base with a
     * <code>HYBRID</code> search using both vector embeddings and raw text, or <code>SEMANTIC</code> search using only
     * vector embeddings. For other vector store configurations, only <code>SEMANTIC</code> search is available. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-test.html">Test a knowledge base</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #overrideSearchType} will return {@link SearchType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #overrideSearchTypeAsString}.
     * </p>
     * 
     * @return By default, Amazon Bedrock decides a search strategy for you. If you're using an Amazon OpenSearch
     *         Serverless vector store that contains a filterable text field, you can specify whether to query the
     *         knowledge base with a <code>HYBRID</code> search using both vector embeddings and raw text, or
     *         <code>SEMANTIC</code> search using only vector embeddings. For other vector store configurations, only
     *         <code>SEMANTIC</code> search is available. For more information, see <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-test.html">Test a knowledge
     *         base</a>.
     * @see SearchType
     */
    public final String overrideSearchTypeAsString() {
        return overrideSearchType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(numberOfResults());
        hashCode = 31 * hashCode + Objects.hashCode(overrideSearchTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KnowledgeBaseVectorSearchConfiguration)) {
            return false;
        }
        KnowledgeBaseVectorSearchConfiguration other = (KnowledgeBaseVectorSearchConfiguration) obj;
        return Objects.equals(numberOfResults(), other.numberOfResults())
                && Objects.equals(overrideSearchTypeAsString(), other.overrideSearchTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KnowledgeBaseVectorSearchConfiguration").add("NumberOfResults", numberOfResults())
                .add("OverrideSearchType", overrideSearchTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "numberOfResults":
            return Optional.ofNullable(clazz.cast(numberOfResults()));
        case "overrideSearchType":
            return Optional.ofNullable(clazz.cast(overrideSearchTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KnowledgeBaseVectorSearchConfiguration, T> g) {
        return obj -> g.apply((KnowledgeBaseVectorSearchConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KnowledgeBaseVectorSearchConfiguration> {
        /**
         * <p>
         * The number of results to return.
         * </p>
         * <note>
         * <p>
         * The <code>numberOfResults</code> field is currently unsupported for <code>RetrieveAndGenerate</code>. Don't
         * include it in this field if you are sending a <code>RetrieveAndGenerate</code> request.
         * </p>
         * </note>
         * 
         * @param numberOfResults
         *        The number of results to return.</p> <note>
         *        <p>
         *        The <code>numberOfResults</code> field is currently unsupported for <code>RetrieveAndGenerate</code>.
         *        Don't include it in this field if you are sending a <code>RetrieveAndGenerate</code> request.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfResults(Integer numberOfResults);

        /**
         * <p>
         * By default, Amazon Bedrock decides a search strategy for you. If you're using an Amazon OpenSearch Serverless
         * vector store that contains a filterable text field, you can specify whether to query the knowledge base with
         * a <code>HYBRID</code> search using both vector embeddings and raw text, or <code>SEMANTIC</code> search using
         * only vector embeddings. For other vector store configurations, only <code>SEMANTIC</code> search is
         * available. For more information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-test.html">Test a knowledge
         * base</a>.
         * </p>
         * 
         * @param overrideSearchType
         *        By default, Amazon Bedrock decides a search strategy for you. If you're using an Amazon OpenSearch
         *        Serverless vector store that contains a filterable text field, you can specify whether to query the
         *        knowledge base with a <code>HYBRID</code> search using both vector embeddings and raw text, or
         *        <code>SEMANTIC</code> search using only vector embeddings. For other vector store configurations, only
         *        <code>SEMANTIC</code> search is available. For more information, see <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-test.html">Test a knowledge
         *        base</a>.
         * @see SearchType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SearchType
         */
        Builder overrideSearchType(String overrideSearchType);

        /**
         * <p>
         * By default, Amazon Bedrock decides a search strategy for you. If you're using an Amazon OpenSearch Serverless
         * vector store that contains a filterable text field, you can specify whether to query the knowledge base with
         * a <code>HYBRID</code> search using both vector embeddings and raw text, or <code>SEMANTIC</code> search using
         * only vector embeddings. For other vector store configurations, only <code>SEMANTIC</code> search is
         * available. For more information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-test.html">Test a knowledge
         * base</a>.
         * </p>
         * 
         * @param overrideSearchType
         *        By default, Amazon Bedrock decides a search strategy for you. If you're using an Amazon OpenSearch
         *        Serverless vector store that contains a filterable text field, you can specify whether to query the
         *        knowledge base with a <code>HYBRID</code> search using both vector embeddings and raw text, or
         *        <code>SEMANTIC</code> search using only vector embeddings. For other vector store configurations, only
         *        <code>SEMANTIC</code> search is available. For more information, see <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-test.html">Test a knowledge
         *        base</a>.
         * @see SearchType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SearchType
         */
        Builder overrideSearchType(SearchType overrideSearchType);
    }

    static final class BuilderImpl implements Builder {
        private Integer numberOfResults;

        private String overrideSearchType;

        private BuilderImpl() {
        }

        private BuilderImpl(KnowledgeBaseVectorSearchConfiguration model) {
            numberOfResults(model.numberOfResults);
            overrideSearchType(model.overrideSearchType);
        }

        public final Integer getNumberOfResults() {
            return numberOfResults;
        }

        public final void setNumberOfResults(Integer numberOfResults) {
            this.numberOfResults = numberOfResults;
        }

        @Override
        public final Builder numberOfResults(Integer numberOfResults) {
            this.numberOfResults = numberOfResults;
            return this;
        }

        public final String getOverrideSearchType() {
            return overrideSearchType;
        }

        public final void setOverrideSearchType(String overrideSearchType) {
            this.overrideSearchType = overrideSearchType;
        }

        @Override
        public final Builder overrideSearchType(String overrideSearchType) {
            this.overrideSearchType = overrideSearchType;
            return this;
        }

        @Override
        public final Builder overrideSearchType(SearchType overrideSearchType) {
            this.overrideSearchType(overrideSearchType == null ? null : overrideSearchType.toString());
            return this;
        }

        @Override
        public KnowledgeBaseVectorSearchConfiguration build() {
            return new KnowledgeBaseVectorSearchConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
