/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the action group being invoked.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActionGroupInvocationInput implements SdkPojo, Serializable,
        ToCopyableBuilder<ActionGroupInvocationInput.Builder, ActionGroupInvocationInput> {
    private static final SdkField<String> ACTION_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionGroupName").getter(getter(ActionGroupInvocationInput::actionGroupName))
            .setter(setter(Builder::actionGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionGroupName").build()).build();

    private static final SdkField<String> API_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("apiPath").getter(getter(ActionGroupInvocationInput::apiPath)).setter(setter(Builder::apiPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiPath").build()).build();

    private static final SdkField<List<Parameter>> PARAMETERS_FIELD = SdkField
            .<List<Parameter>> builder(MarshallingType.LIST)
            .memberName("parameters")
            .getter(getter(ActionGroupInvocationInput::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Parameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Parameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<RequestBody> REQUEST_BODY_FIELD = SdkField.<RequestBody> builder(MarshallingType.SDK_POJO)
            .memberName("requestBody").getter(getter(ActionGroupInvocationInput::requestBody))
            .setter(setter(Builder::requestBody)).constructor(RequestBody::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestBody").build()).build();

    private static final SdkField<String> VERB_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("verb")
            .getter(getter(ActionGroupInvocationInput::verb)).setter(setter(Builder::verb))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("verb").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_GROUP_NAME_FIELD,
            API_PATH_FIELD, PARAMETERS_FIELD, REQUEST_BODY_FIELD, VERB_FIELD));

    private static final long serialVersionUID = 1L;

    private final String actionGroupName;

    private final String apiPath;

    private final List<Parameter> parameters;

    private final RequestBody requestBody;

    private final String verb;

    private ActionGroupInvocationInput(BuilderImpl builder) {
        this.actionGroupName = builder.actionGroupName;
        this.apiPath = builder.apiPath;
        this.parameters = builder.parameters;
        this.requestBody = builder.requestBody;
        this.verb = builder.verb;
    }

    /**
     * <p>
     * The name of the action group.
     * </p>
     * 
     * @return The name of the action group.
     */
    public final String actionGroupName() {
        return actionGroupName;
    }

    /**
     * <p>
     * The path to the API to call, based off the action group.
     * </p>
     * 
     * @return The path to the API to call, based off the action group.
     */
    public final String apiPath() {
        return apiPath;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The parameters in the Lambda input event.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return The parameters in the Lambda input event.
     */
    public final List<Parameter> parameters() {
        return parameters;
    }

    /**
     * <p>
     * The parameters in the request body for the Lambda input event.
     * </p>
     * 
     * @return The parameters in the request body for the Lambda input event.
     */
    public final RequestBody requestBody() {
        return requestBody;
    }

    /**
     * <p>
     * The API method being used, based off the action group.
     * </p>
     * 
     * @return The API method being used, based off the action group.
     */
    public final String verb() {
        return verb;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(apiPath());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(requestBody());
        hashCode = 31 * hashCode + Objects.hashCode(verb());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionGroupInvocationInput)) {
            return false;
        }
        ActionGroupInvocationInput other = (ActionGroupInvocationInput) obj;
        return Objects.equals(actionGroupName(), other.actionGroupName()) && Objects.equals(apiPath(), other.apiPath())
                && hasParameters() == other.hasParameters() && Objects.equals(parameters(), other.parameters())
                && Objects.equals(requestBody(), other.requestBody()) && Objects.equals(verb(), other.verb());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ActionGroupInvocationInput")
                .add("ActionGroupName", actionGroupName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ApiPath", apiPath() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Parameters", hasParameters() ? parameters() : null).add("RequestBody", requestBody())
                .add("Verb", verb() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actionGroupName":
            return Optional.ofNullable(clazz.cast(actionGroupName()));
        case "apiPath":
            return Optional.ofNullable(clazz.cast(apiPath()));
        case "parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "requestBody":
            return Optional.ofNullable(clazz.cast(requestBody()));
        case "verb":
            return Optional.ofNullable(clazz.cast(verb()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActionGroupInvocationInput, T> g) {
        return obj -> g.apply((ActionGroupInvocationInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActionGroupInvocationInput> {
        /**
         * <p>
         * The name of the action group.
         * </p>
         * 
         * @param actionGroupName
         *        The name of the action group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionGroupName(String actionGroupName);

        /**
         * <p>
         * The path to the API to call, based off the action group.
         * </p>
         * 
         * @param apiPath
         *        The path to the API to call, based off the action group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiPath(String apiPath);

        /**
         * <p>
         * The parameters in the Lambda input event.
         * </p>
         * 
         * @param parameters
         *        The parameters in the Lambda input event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Collection<Parameter> parameters);

        /**
         * <p>
         * The parameters in the Lambda input event.
         * </p>
         * 
         * @param parameters
         *        The parameters in the Lambda input event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Parameter... parameters);

        /**
         * <p>
         * The parameters in the Lambda input event.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.Parameter.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.bedrockagentruntime.model.Parameter#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.Parameter.Builder#build()} is called
         * immediately and its result is passed to {@link #parameters(List<Parameter>)}.
         * 
         * @param parameters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.Parameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameters(java.util.Collection<Parameter>)
         */
        Builder parameters(Consumer<Parameter.Builder>... parameters);

        /**
         * <p>
         * The parameters in the request body for the Lambda input event.
         * </p>
         * 
         * @param requestBody
         *        The parameters in the request body for the Lambda input event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestBody(RequestBody requestBody);

        /**
         * <p>
         * The parameters in the request body for the Lambda input event.
         * </p>
         * This is a convenience method that creates an instance of the {@link RequestBody.Builder} avoiding the need to
         * create one manually via {@link RequestBody#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RequestBody.Builder#build()} is called immediately and its result
         * is passed to {@link #requestBody(RequestBody)}.
         * 
         * @param requestBody
         *        a consumer that will call methods on {@link RequestBody.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #requestBody(RequestBody)
         */
        default Builder requestBody(Consumer<RequestBody.Builder> requestBody) {
            return requestBody(RequestBody.builder().applyMutation(requestBody).build());
        }

        /**
         * <p>
         * The API method being used, based off the action group.
         * </p>
         * 
         * @param verb
         *        The API method being used, based off the action group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verb(String verb);
    }

    static final class BuilderImpl implements Builder {
        private String actionGroupName;

        private String apiPath;

        private List<Parameter> parameters = DefaultSdkAutoConstructList.getInstance();

        private RequestBody requestBody;

        private String verb;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionGroupInvocationInput model) {
            actionGroupName(model.actionGroupName);
            apiPath(model.apiPath);
            parameters(model.parameters);
            requestBody(model.requestBody);
            verb(model.verb);
        }

        public final String getActionGroupName() {
            return actionGroupName;
        }

        public final void setActionGroupName(String actionGroupName) {
            this.actionGroupName = actionGroupName;
        }

        @Override
        public final Builder actionGroupName(String actionGroupName) {
            this.actionGroupName = actionGroupName;
            return this;
        }

        public final String getApiPath() {
            return apiPath;
        }

        public final void setApiPath(String apiPath) {
            this.apiPath = apiPath;
        }

        @Override
        public final Builder apiPath(String apiPath) {
            this.apiPath = apiPath;
            return this;
        }

        public final List<Parameter.Builder> getParameters() {
            List<Parameter.Builder> result = ParametersCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameters(Collection<Parameter.BuilderImpl> parameters) {
            this.parameters = ParametersCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Collection<Parameter> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Parameter... parameters) {
            parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<Parameter.Builder>... parameters) {
            parameters(Stream.of(parameters).map(c -> Parameter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final RequestBody.Builder getRequestBody() {
            return requestBody != null ? requestBody.toBuilder() : null;
        }

        public final void setRequestBody(RequestBody.BuilderImpl requestBody) {
            this.requestBody = requestBody != null ? requestBody.build() : null;
        }

        @Override
        public final Builder requestBody(RequestBody requestBody) {
            this.requestBody = requestBody;
            return this;
        }

        public final String getVerb() {
            return verb;
        }

        public final void setVerb(String verb) {
            this.verb = verb;
        }

        @Override
        public final Builder verb(String verb) {
            this.verb = verb;
            return this;
        }

        @Override
        public ActionGroupInvocationInput build() {
            return new ActionGroupInvocationInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
