/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagent.model.BedrockAgentRequest;
import software.amazon.awssdk.services.bedrockagent.model.FlowAliasConcurrencyConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.FlowAliasRoutingConfigurationCopier;
import software.amazon.awssdk.services.bedrockagent.model.FlowAliasRoutingConfigurationListItem;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateFlowAliasRequest
extends BedrockAgentRequest
implements ToCopyableBuilder<Builder, UpdateFlowAliasRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateFlowAliasRequest.getter(UpdateFlowAliasRequest::name)).setter(UpdateFlowAliasRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateFlowAliasRequest.getter(UpdateFlowAliasRequest::description)).setter(UpdateFlowAliasRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<FlowAliasRoutingConfigurationListItem>> ROUTING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("routingConfiguration").getter(UpdateFlowAliasRequest.getter(UpdateFlowAliasRequest::routingConfiguration)).setter(UpdateFlowAliasRequest.setter(Builder::routingConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routingConfiguration").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FlowAliasRoutingConfigurationListItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<FlowAliasConcurrencyConfiguration> CONCURRENCY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("concurrencyConfiguration").getter(UpdateFlowAliasRequest.getter(UpdateFlowAliasRequest::concurrencyConfiguration)).setter(UpdateFlowAliasRequest.setter(Builder::concurrencyConfiguration)).constructor(FlowAliasConcurrencyConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("concurrencyConfiguration").build()}).build();
    private static final SdkField<String> FLOW_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("flowIdentifier").getter(UpdateFlowAliasRequest.getter(UpdateFlowAliasRequest::flowIdentifier)).setter(UpdateFlowAliasRequest.setter(Builder::flowIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("flowIdentifier").build()}).build();
    private static final SdkField<String> ALIAS_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("aliasIdentifier").getter(UpdateFlowAliasRequest.getter(UpdateFlowAliasRequest::aliasIdentifier)).setter(UpdateFlowAliasRequest.setter(Builder::aliasIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("aliasIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, ROUTING_CONFIGURATION_FIELD, CONCURRENCY_CONFIGURATION_FIELD, FLOW_IDENTIFIER_FIELD, ALIAS_IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateFlowAliasRequest.memberNameToFieldInitializer();
    private final String name;
    private final String description;
    private final List<FlowAliasRoutingConfigurationListItem> routingConfiguration;
    private final FlowAliasConcurrencyConfiguration concurrencyConfiguration;
    private final String flowIdentifier;
    private final String aliasIdentifier;

    private UpdateFlowAliasRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.routingConfiguration = builder.routingConfiguration;
        this.concurrencyConfiguration = builder.concurrencyConfiguration;
        this.flowIdentifier = builder.flowIdentifier;
        this.aliasIdentifier = builder.aliasIdentifier;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasRoutingConfiguration() {
        return this.routingConfiguration != null && !(this.routingConfiguration instanceof SdkAutoConstructList);
    }

    public final List<FlowAliasRoutingConfigurationListItem> routingConfiguration() {
        return this.routingConfiguration;
    }

    public final FlowAliasConcurrencyConfiguration concurrencyConfiguration() {
        return this.concurrencyConfiguration;
    }

    public final String flowIdentifier() {
        return this.flowIdentifier;
    }

    public final String aliasIdentifier() {
        return this.aliasIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRoutingConfiguration() ? this.routingConfiguration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.concurrencyConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.aliasIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFlowAliasRequest)) {
            return false;
        }
        UpdateFlowAliasRequest other = (UpdateFlowAliasRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && this.hasRoutingConfiguration() == other.hasRoutingConfiguration() && Objects.equals(this.routingConfiguration(), other.routingConfiguration()) && Objects.equals(this.concurrencyConfiguration(), other.concurrencyConfiguration()) && Objects.equals(this.flowIdentifier(), other.flowIdentifier()) && Objects.equals(this.aliasIdentifier(), other.aliasIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateFlowAliasRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("RoutingConfiguration", this.hasRoutingConfiguration() ? this.routingConfiguration() : null).add("ConcurrencyConfiguration", (Object)this.concurrencyConfiguration()).add("FlowIdentifier", (Object)this.flowIdentifier()).add("AliasIdentifier", (Object)this.aliasIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "routingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.routingConfiguration()));
            }
            case "concurrencyConfiguration": {
                return Optional.ofNullable(clazz.cast(this.concurrencyConfiguration()));
            }
            case "flowIdentifier": {
                return Optional.ofNullable(clazz.cast(this.flowIdentifier()));
            }
            case "aliasIdentifier": {
                return Optional.ofNullable(clazz.cast(this.aliasIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("routingConfiguration", ROUTING_CONFIGURATION_FIELD);
        map.put("concurrencyConfiguration", CONCURRENCY_CONFIGURATION_FIELD);
        map.put("flowIdentifier", FLOW_IDENTIFIER_FIELD);
        map.put("aliasIdentifier", ALIAS_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateFlowAliasRequest, T> g) {
        return obj -> g.apply((UpdateFlowAliasRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private List<FlowAliasRoutingConfigurationListItem> routingConfiguration = DefaultSdkAutoConstructList.getInstance();
        private FlowAliasConcurrencyConfiguration concurrencyConfiguration;
        private String flowIdentifier;
        private String aliasIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFlowAliasRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.routingConfiguration(model.routingConfiguration);
            this.concurrencyConfiguration(model.concurrencyConfiguration);
            this.flowIdentifier(model.flowIdentifier);
            this.aliasIdentifier(model.aliasIdentifier);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<FlowAliasRoutingConfigurationListItem.Builder> getRoutingConfiguration() {
            List<FlowAliasRoutingConfigurationListItem.Builder> result = FlowAliasRoutingConfigurationCopier.copyToBuilder(this.routingConfiguration);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoutingConfiguration(Collection<FlowAliasRoutingConfigurationListItem.BuilderImpl> routingConfiguration) {
            this.routingConfiguration = FlowAliasRoutingConfigurationCopier.copyFromBuilder(routingConfiguration);
        }

        @Override
        public final Builder routingConfiguration(Collection<FlowAliasRoutingConfigurationListItem> routingConfiguration) {
            this.routingConfiguration = FlowAliasRoutingConfigurationCopier.copy(routingConfiguration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingConfiguration(FlowAliasRoutingConfigurationListItem ... routingConfiguration) {
            this.routingConfiguration(Arrays.asList(routingConfiguration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingConfiguration(Consumer<FlowAliasRoutingConfigurationListItem.Builder> ... routingConfiguration) {
            this.routingConfiguration(Stream.of(routingConfiguration).map(c -> (FlowAliasRoutingConfigurationListItem)((FlowAliasRoutingConfigurationListItem.Builder)FlowAliasRoutingConfigurationListItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final FlowAliasConcurrencyConfiguration.Builder getConcurrencyConfiguration() {
            return this.concurrencyConfiguration != null ? this.concurrencyConfiguration.toBuilder() : null;
        }

        public final void setConcurrencyConfiguration(FlowAliasConcurrencyConfiguration.BuilderImpl concurrencyConfiguration) {
            this.concurrencyConfiguration = concurrencyConfiguration != null ? concurrencyConfiguration.build() : null;
        }

        @Override
        public final Builder concurrencyConfiguration(FlowAliasConcurrencyConfiguration concurrencyConfiguration) {
            this.concurrencyConfiguration = concurrencyConfiguration;
            return this;
        }

        public final String getFlowIdentifier() {
            return this.flowIdentifier;
        }

        public final void setFlowIdentifier(String flowIdentifier) {
            this.flowIdentifier = flowIdentifier;
        }

        @Override
        public final Builder flowIdentifier(String flowIdentifier) {
            this.flowIdentifier = flowIdentifier;
            return this;
        }

        public final String getAliasIdentifier() {
            return this.aliasIdentifier;
        }

        public final void setAliasIdentifier(String aliasIdentifier) {
            this.aliasIdentifier = aliasIdentifier;
        }

        @Override
        public final Builder aliasIdentifier(String aliasIdentifier) {
            this.aliasIdentifier = aliasIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFlowAliasRequest build() {
            return new UpdateFlowAliasRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateFlowAliasRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder routingConfiguration(Collection<FlowAliasRoutingConfigurationListItem> var1);

        public Builder routingConfiguration(FlowAliasRoutingConfigurationListItem ... var1);

        public Builder routingConfiguration(Consumer<FlowAliasRoutingConfigurationListItem.Builder> ... var1);

        public Builder concurrencyConfiguration(FlowAliasConcurrencyConfiguration var1);

        default public Builder concurrencyConfiguration(Consumer<FlowAliasConcurrencyConfiguration.Builder> concurrencyConfiguration) {
            return this.concurrencyConfiguration((FlowAliasConcurrencyConfiguration)((FlowAliasConcurrencyConfiguration.Builder)FlowAliasConcurrencyConfiguration.builder().applyMutation(concurrencyConfiguration)).build());
        }

        public Builder flowIdentifier(String var1);

        public Builder aliasIdentifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

