/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagent.model.QueryGenerationContext;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QueryGenerationConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QueryGenerationConfiguration> {
    private static final SdkField<Integer> EXECUTION_TIMEOUT_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("executionTimeoutSeconds").getter(QueryGenerationConfiguration.getter(QueryGenerationConfiguration::executionTimeoutSeconds)).setter(QueryGenerationConfiguration.setter(Builder::executionTimeoutSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionTimeoutSeconds").build()}).build();
    private static final SdkField<QueryGenerationContext> GENERATION_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("generationContext").getter(QueryGenerationConfiguration.getter(QueryGenerationConfiguration::generationContext)).setter(QueryGenerationConfiguration.setter(Builder::generationContext)).constructor(QueryGenerationContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generationContext").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_TIMEOUT_SECONDS_FIELD, GENERATION_CONTEXT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = QueryGenerationConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer executionTimeoutSeconds;
    private final QueryGenerationContext generationContext;

    private QueryGenerationConfiguration(BuilderImpl builder) {
        this.executionTimeoutSeconds = builder.executionTimeoutSeconds;
        this.generationContext = builder.generationContext;
    }

    public final Integer executionTimeoutSeconds() {
        return this.executionTimeoutSeconds;
    }

    public final QueryGenerationContext generationContext() {
        return this.generationContext;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.executionTimeoutSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.generationContext());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryGenerationConfiguration)) {
            return false;
        }
        QueryGenerationConfiguration other = (QueryGenerationConfiguration)obj;
        return Objects.equals(this.executionTimeoutSeconds(), other.executionTimeoutSeconds()) && Objects.equals(this.generationContext(), other.generationContext());
    }

    public final String toString() {
        return ToString.builder((String)"QueryGenerationConfiguration").add("ExecutionTimeoutSeconds", (Object)this.executionTimeoutSeconds()).add("GenerationContext", (Object)(this.generationContext() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "executionTimeoutSeconds": {
                return Optional.ofNullable(clazz.cast(this.executionTimeoutSeconds()));
            }
            case "generationContext": {
                return Optional.ofNullable(clazz.cast(this.generationContext()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("executionTimeoutSeconds", EXECUTION_TIMEOUT_SECONDS_FIELD);
        map.put("generationContext", GENERATION_CONTEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QueryGenerationConfiguration, T> g) {
        return obj -> g.apply((QueryGenerationConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer executionTimeoutSeconds;
        private QueryGenerationContext generationContext;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryGenerationConfiguration model) {
            this.executionTimeoutSeconds(model.executionTimeoutSeconds);
            this.generationContext(model.generationContext);
        }

        public final Integer getExecutionTimeoutSeconds() {
            return this.executionTimeoutSeconds;
        }

        public final void setExecutionTimeoutSeconds(Integer executionTimeoutSeconds) {
            this.executionTimeoutSeconds = executionTimeoutSeconds;
        }

        @Override
        public final Builder executionTimeoutSeconds(Integer executionTimeoutSeconds) {
            this.executionTimeoutSeconds = executionTimeoutSeconds;
            return this;
        }

        public final QueryGenerationContext.Builder getGenerationContext() {
            return this.generationContext != null ? this.generationContext.toBuilder() : null;
        }

        public final void setGenerationContext(QueryGenerationContext.BuilderImpl generationContext) {
            this.generationContext = generationContext != null ? generationContext.build() : null;
        }

        @Override
        public final Builder generationContext(QueryGenerationContext generationContext) {
            this.generationContext = generationContext;
            return this;
        }

        public QueryGenerationConfiguration build() {
            return new QueryGenerationConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QueryGenerationConfiguration> {
        public Builder executionTimeoutSeconds(Integer var1);

        public Builder generationContext(QueryGenerationContext var1);

        default public Builder generationContext(Consumer<QueryGenerationContext.Builder> generationContext) {
            return this.generationContext((QueryGenerationContext)((QueryGenerationContext.Builder)QueryGenerationContext.builder().applyMutation(generationContext)).build());
        }
    }
}

