/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagent.model.ContentDataSourceType;
import software.amazon.awssdk.services.bedrockagent.model.CustomContent;
import software.amazon.awssdk.services.bedrockagent.model.S3Content;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DocumentContent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DocumentContent> {
    private static final SdkField<String> DATA_SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataSourceType").getter(DocumentContent.getter(DocumentContent::dataSourceTypeAsString)).setter(DocumentContent.setter(Builder::dataSourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceType").build()}).build();
    private static final SdkField<CustomContent> CUSTOM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("custom").getter(DocumentContent.getter(DocumentContent::custom)).setter(DocumentContent.setter(Builder::custom)).constructor(CustomContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("custom").build()}).build();
    private static final SdkField<S3Content> S3_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3").getter(DocumentContent.getter(DocumentContent::s3)).setter(DocumentContent.setter(Builder::s3)).constructor(S3Content::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_TYPE_FIELD, CUSTOM_FIELD, S3_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DocumentContent.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String dataSourceType;
    private final CustomContent custom;
    private final S3Content s3;

    private DocumentContent(BuilderImpl builder) {
        this.dataSourceType = builder.dataSourceType;
        this.custom = builder.custom;
        this.s3 = builder.s3;
    }

    public final ContentDataSourceType dataSourceType() {
        return ContentDataSourceType.fromValue(this.dataSourceType);
    }

    public final String dataSourceTypeAsString() {
        return this.dataSourceType;
    }

    public final CustomContent custom() {
        return this.custom;
    }

    public final S3Content s3() {
        return this.s3;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.custom());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentContent)) {
            return false;
        }
        DocumentContent other = (DocumentContent)obj;
        return Objects.equals(this.dataSourceTypeAsString(), other.dataSourceTypeAsString()) && Objects.equals(this.custom(), other.custom()) && Objects.equals(this.s3(), other.s3());
    }

    public final String toString() {
        return ToString.builder((String)"DocumentContent").add("DataSourceType", (Object)this.dataSourceTypeAsString()).add("Custom", (Object)this.custom()).add("S3", (Object)this.s3()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dataSourceType": {
                return Optional.ofNullable(clazz.cast(this.dataSourceTypeAsString()));
            }
            case "custom": {
                return Optional.ofNullable(clazz.cast(this.custom()));
            }
            case "s3": {
                return Optional.ofNullable(clazz.cast(this.s3()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataSourceType", DATA_SOURCE_TYPE_FIELD);
        map.put("custom", CUSTOM_FIELD);
        map.put("s3", S3_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DocumentContent, T> g) {
        return obj -> g.apply((DocumentContent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dataSourceType;
        private CustomContent custom;
        private S3Content s3;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentContent model) {
            this.dataSourceType(model.dataSourceType);
            this.custom(model.custom);
            this.s3(model.s3);
        }

        public final String getDataSourceType() {
            return this.dataSourceType;
        }

        public final void setDataSourceType(String dataSourceType) {
            this.dataSourceType = dataSourceType;
        }

        @Override
        public final Builder dataSourceType(String dataSourceType) {
            this.dataSourceType = dataSourceType;
            return this;
        }

        @Override
        public final Builder dataSourceType(ContentDataSourceType dataSourceType) {
            this.dataSourceType(dataSourceType == null ? null : dataSourceType.toString());
            return this;
        }

        public final CustomContent.Builder getCustom() {
            return this.custom != null ? this.custom.toBuilder() : null;
        }

        public final void setCustom(CustomContent.BuilderImpl custom) {
            this.custom = custom != null ? custom.build() : null;
        }

        @Override
        public final Builder custom(CustomContent custom) {
            this.custom = custom;
            return this;
        }

        public final S3Content.Builder getS3() {
            return this.s3 != null ? this.s3.toBuilder() : null;
        }

        public final void setS3(S3Content.BuilderImpl s3) {
            this.s3 = s3 != null ? s3.build() : null;
        }

        @Override
        public final Builder s3(S3Content s3) {
            this.s3 = s3;
            return this;
        }

        public DocumentContent build() {
            return new DocumentContent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DocumentContent> {
        public Builder dataSourceType(String var1);

        public Builder dataSourceType(ContentDataSourceType var1);

        public Builder custom(CustomContent var1);

        default public Builder custom(Consumer<CustomContent.Builder> custom) {
            return this.custom((CustomContent)((CustomContent.Builder)CustomContent.builder().applyMutation(custom)).build());
        }

        public Builder s3(S3Content var1);

        default public Builder s3(Consumer<S3Content.Builder> s3) {
            return this.s3((S3Content)((S3Content.Builder)S3Content.builder().applyMutation(s3)).build());
        }
    }
}

