/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagent.BedrockAgentAsyncClient;
import software.amazon.awssdk.services.bedrockagent.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagent.model.FlowSummary;
import software.amazon.awssdk.services.bedrockagent.model.ListFlowsRequest;
import software.amazon.awssdk.services.bedrockagent.model.ListFlowsResponse;

public class ListFlowsPublisher
implements SdkPublisher<ListFlowsResponse> {
    private final BedrockAgentAsyncClient client;
    private final ListFlowsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFlowsPublisher(BedrockAgentAsyncClient client, ListFlowsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFlowsPublisher(BedrockAgentAsyncClient client, ListFlowsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFlowsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFlowsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<FlowSummary> flowSummaries() {
        return this.flatMapIterable(response -> response.flowSummaries());
    }

    private class ListFlowsResponseFetcher
    implements AsyncPageFetcher<ListFlowsResponse> {
        private ListFlowsResponseFetcher() {
        }

        public boolean hasNextPage(ListFlowsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListFlowsResponse> nextPage(ListFlowsResponse previousPage) {
            if (previousPage == null) {
                return ListFlowsPublisher.this.client.listFlows(ListFlowsPublisher.this.firstRequest);
            }
            return ListFlowsPublisher.this.client.listFlows((ListFlowsRequest)((Object)ListFlowsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

