/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagent.BedrockAgentAsyncClient;
import software.amazon.awssdk.services.bedrockagent.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagent.model.AgentCollaboratorSummary;
import software.amazon.awssdk.services.bedrockagent.model.ListAgentCollaboratorsRequest;
import software.amazon.awssdk.services.bedrockagent.model.ListAgentCollaboratorsResponse;

public class ListAgentCollaboratorsPublisher
implements SdkPublisher<ListAgentCollaboratorsResponse> {
    private final BedrockAgentAsyncClient client;
    private final ListAgentCollaboratorsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAgentCollaboratorsPublisher(BedrockAgentAsyncClient client, ListAgentCollaboratorsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAgentCollaboratorsPublisher(BedrockAgentAsyncClient client, ListAgentCollaboratorsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAgentCollaboratorsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAgentCollaboratorsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AgentCollaboratorSummary> agentCollaboratorSummaries() {
        return this.flatMapIterable(response -> response.agentCollaboratorSummaries());
    }

    private class ListAgentCollaboratorsResponseFetcher
    implements AsyncPageFetcher<ListAgentCollaboratorsResponse> {
        private ListAgentCollaboratorsResponseFetcher() {
        }

        public boolean hasNextPage(ListAgentCollaboratorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAgentCollaboratorsResponse> nextPage(ListAgentCollaboratorsResponse previousPage) {
            if (previousPage == null) {
                return ListAgentCollaboratorsPublisher.this.client.listAgentCollaborators(ListAgentCollaboratorsPublisher.this.firstRequest);
            }
            return ListAgentCollaboratorsPublisher.this.client.listAgentCollaborators((ListAgentCollaboratorsRequest)((Object)ListAgentCollaboratorsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

