/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagent.model.SalesforceCrawlerConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.SalesforceSourceConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SalesforceDataSourceConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SalesforceDataSourceConfiguration> {
    private static final SdkField<SalesforceSourceConfiguration> SOURCE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sourceConfiguration").getter(SalesforceDataSourceConfiguration.getter(SalesforceDataSourceConfiguration::sourceConfiguration)).setter(SalesforceDataSourceConfiguration.setter(Builder::sourceConfiguration)).constructor(SalesforceSourceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceConfiguration").build()}).build();
    private static final SdkField<SalesforceCrawlerConfiguration> CRAWLER_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("crawlerConfiguration").getter(SalesforceDataSourceConfiguration.getter(SalesforceDataSourceConfiguration::crawlerConfiguration)).setter(SalesforceDataSourceConfiguration.setter(Builder::crawlerConfiguration)).constructor(SalesforceCrawlerConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("crawlerConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_CONFIGURATION_FIELD, CRAWLER_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SalesforceDataSourceConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final SalesforceSourceConfiguration sourceConfiguration;
    private final SalesforceCrawlerConfiguration crawlerConfiguration;

    private SalesforceDataSourceConfiguration(BuilderImpl builder) {
        this.sourceConfiguration = builder.sourceConfiguration;
        this.crawlerConfiguration = builder.crawlerConfiguration;
    }

    public final SalesforceSourceConfiguration sourceConfiguration() {
        return this.sourceConfiguration;
    }

    public final SalesforceCrawlerConfiguration crawlerConfiguration() {
        return this.crawlerConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.crawlerConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SalesforceDataSourceConfiguration)) {
            return false;
        }
        SalesforceDataSourceConfiguration other = (SalesforceDataSourceConfiguration)obj;
        return Objects.equals(this.sourceConfiguration(), other.sourceConfiguration()) && Objects.equals(this.crawlerConfiguration(), other.crawlerConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"SalesforceDataSourceConfiguration").add("SourceConfiguration", (Object)this.sourceConfiguration()).add("CrawlerConfiguration", (Object)this.crawlerConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sourceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.sourceConfiguration()));
            }
            case "crawlerConfiguration": {
                return Optional.ofNullable(clazz.cast(this.crawlerConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sourceConfiguration", SOURCE_CONFIGURATION_FIELD);
        map.put("crawlerConfiguration", CRAWLER_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SalesforceDataSourceConfiguration, T> g) {
        return obj -> g.apply((SalesforceDataSourceConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SalesforceSourceConfiguration sourceConfiguration;
        private SalesforceCrawlerConfiguration crawlerConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(SalesforceDataSourceConfiguration model) {
            this.sourceConfiguration(model.sourceConfiguration);
            this.crawlerConfiguration(model.crawlerConfiguration);
        }

        public final SalesforceSourceConfiguration.Builder getSourceConfiguration() {
            return this.sourceConfiguration != null ? this.sourceConfiguration.toBuilder() : null;
        }

        public final void setSourceConfiguration(SalesforceSourceConfiguration.BuilderImpl sourceConfiguration) {
            this.sourceConfiguration = sourceConfiguration != null ? sourceConfiguration.build() : null;
        }

        @Override
        public final Builder sourceConfiguration(SalesforceSourceConfiguration sourceConfiguration) {
            this.sourceConfiguration = sourceConfiguration;
            return this;
        }

        public final SalesforceCrawlerConfiguration.Builder getCrawlerConfiguration() {
            return this.crawlerConfiguration != null ? this.crawlerConfiguration.toBuilder() : null;
        }

        public final void setCrawlerConfiguration(SalesforceCrawlerConfiguration.BuilderImpl crawlerConfiguration) {
            this.crawlerConfiguration = crawlerConfiguration != null ? crawlerConfiguration.build() : null;
        }

        @Override
        public final Builder crawlerConfiguration(SalesforceCrawlerConfiguration crawlerConfiguration) {
            this.crawlerConfiguration = crawlerConfiguration;
            return this;
        }

        public SalesforceDataSourceConfiguration build() {
            return new SalesforceDataSourceConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SalesforceDataSourceConfiguration> {
        public Builder sourceConfiguration(SalesforceSourceConfiguration var1);

        default public Builder sourceConfiguration(Consumer<SalesforceSourceConfiguration.Builder> sourceConfiguration) {
            return this.sourceConfiguration((SalesforceSourceConfiguration)((SalesforceSourceConfiguration.Builder)SalesforceSourceConfiguration.builder().applyMutation(sourceConfiguration)).build());
        }

        public Builder crawlerConfiguration(SalesforceCrawlerConfiguration var1);

        default public Builder crawlerConfiguration(Consumer<SalesforceCrawlerConfiguration.Builder> crawlerConfiguration) {
            return this.crawlerConfiguration((SalesforceCrawlerConfiguration)((SalesforceCrawlerConfiguration.Builder)SalesforceCrawlerConfiguration.builder().applyMutation(crawlerConfiguration)).build());
        }
    }
}

