/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagent.model.MongoDbAtlasFieldMapping;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MongoDbAtlasConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MongoDbAtlasConfiguration> {
    private static final SdkField<String> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("endpoint").getter(MongoDbAtlasConfiguration.getter(MongoDbAtlasConfiguration::endpoint)).setter(MongoDbAtlasConfiguration.setter(Builder::endpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoint").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("databaseName").getter(MongoDbAtlasConfiguration.getter(MongoDbAtlasConfiguration::databaseName)).setter(MongoDbAtlasConfiguration.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databaseName").build()}).build();
    private static final SdkField<String> COLLECTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("collectionName").getter(MongoDbAtlasConfiguration.getter(MongoDbAtlasConfiguration::collectionName)).setter(MongoDbAtlasConfiguration.setter(Builder::collectionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collectionName").build()}).build();
    private static final SdkField<String> VECTOR_INDEX_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vectorIndexName").getter(MongoDbAtlasConfiguration.getter(MongoDbAtlasConfiguration::vectorIndexName)).setter(MongoDbAtlasConfiguration.setter(Builder::vectorIndexName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vectorIndexName").build()}).build();
    private static final SdkField<String> CREDENTIALS_SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("credentialsSecretArn").getter(MongoDbAtlasConfiguration.getter(MongoDbAtlasConfiguration::credentialsSecretArn)).setter(MongoDbAtlasConfiguration.setter(Builder::credentialsSecretArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialsSecretArn").build()}).build();
    private static final SdkField<MongoDbAtlasFieldMapping> FIELD_MAPPING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("fieldMapping").getter(MongoDbAtlasConfiguration.getter(MongoDbAtlasConfiguration::fieldMapping)).setter(MongoDbAtlasConfiguration.setter(Builder::fieldMapping)).constructor(MongoDbAtlasFieldMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldMapping").build()}).build();
    private static final SdkField<String> ENDPOINT_SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("endpointServiceName").getter(MongoDbAtlasConfiguration.getter(MongoDbAtlasConfiguration::endpointServiceName)).setter(MongoDbAtlasConfiguration.setter(Builder::endpointServiceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpointServiceName").build()}).build();
    private static final SdkField<String> TEXT_INDEX_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("textIndexName").getter(MongoDbAtlasConfiguration.getter(MongoDbAtlasConfiguration::textIndexName)).setter(MongoDbAtlasConfiguration.setter(Builder::textIndexName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("textIndexName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_FIELD, DATABASE_NAME_FIELD, COLLECTION_NAME_FIELD, VECTOR_INDEX_NAME_FIELD, CREDENTIALS_SECRET_ARN_FIELD, FIELD_MAPPING_FIELD, ENDPOINT_SERVICE_NAME_FIELD, TEXT_INDEX_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MongoDbAtlasConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String endpoint;
    private final String databaseName;
    private final String collectionName;
    private final String vectorIndexName;
    private final String credentialsSecretArn;
    private final MongoDbAtlasFieldMapping fieldMapping;
    private final String endpointServiceName;
    private final String textIndexName;

    private MongoDbAtlasConfiguration(BuilderImpl builder) {
        this.endpoint = builder.endpoint;
        this.databaseName = builder.databaseName;
        this.collectionName = builder.collectionName;
        this.vectorIndexName = builder.vectorIndexName;
        this.credentialsSecretArn = builder.credentialsSecretArn;
        this.fieldMapping = builder.fieldMapping;
        this.endpointServiceName = builder.endpointServiceName;
        this.textIndexName = builder.textIndexName;
    }

    public final String endpoint() {
        return this.endpoint;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final String collectionName() {
        return this.collectionName;
    }

    public final String vectorIndexName() {
        return this.vectorIndexName;
    }

    public final String credentialsSecretArn() {
        return this.credentialsSecretArn;
    }

    public final MongoDbAtlasFieldMapping fieldMapping() {
        return this.fieldMapping;
    }

    public final String endpointServiceName() {
        return this.endpointServiceName;
    }

    public final String textIndexName() {
        return this.textIndexName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.collectionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vectorIndexName());
        hashCode = 31 * hashCode + Objects.hashCode(this.credentialsSecretArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldMapping());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointServiceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.textIndexName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MongoDbAtlasConfiguration)) {
            return false;
        }
        MongoDbAtlasConfiguration other = (MongoDbAtlasConfiguration)obj;
        return Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.collectionName(), other.collectionName()) && Objects.equals(this.vectorIndexName(), other.vectorIndexName()) && Objects.equals(this.credentialsSecretArn(), other.credentialsSecretArn()) && Objects.equals(this.fieldMapping(), other.fieldMapping()) && Objects.equals(this.endpointServiceName(), other.endpointServiceName()) && Objects.equals(this.textIndexName(), other.textIndexName());
    }

    public final String toString() {
        return ToString.builder((String)"MongoDbAtlasConfiguration").add("Endpoint", (Object)this.endpoint()).add("DatabaseName", (Object)this.databaseName()).add("CollectionName", (Object)this.collectionName()).add("VectorIndexName", (Object)this.vectorIndexName()).add("CredentialsSecretArn", (Object)this.credentialsSecretArn()).add("FieldMapping", (Object)this.fieldMapping()).add("EndpointServiceName", (Object)this.endpointServiceName()).add("TextIndexName", (Object)this.textIndexName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "databaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "collectionName": {
                return Optional.ofNullable(clazz.cast(this.collectionName()));
            }
            case "vectorIndexName": {
                return Optional.ofNullable(clazz.cast(this.vectorIndexName()));
            }
            case "credentialsSecretArn": {
                return Optional.ofNullable(clazz.cast(this.credentialsSecretArn()));
            }
            case "fieldMapping": {
                return Optional.ofNullable(clazz.cast(this.fieldMapping()));
            }
            case "endpointServiceName": {
                return Optional.ofNullable(clazz.cast(this.endpointServiceName()));
            }
            case "textIndexName": {
                return Optional.ofNullable(clazz.cast(this.textIndexName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("endpoint", ENDPOINT_FIELD);
        map.put("databaseName", DATABASE_NAME_FIELD);
        map.put("collectionName", COLLECTION_NAME_FIELD);
        map.put("vectorIndexName", VECTOR_INDEX_NAME_FIELD);
        map.put("credentialsSecretArn", CREDENTIALS_SECRET_ARN_FIELD);
        map.put("fieldMapping", FIELD_MAPPING_FIELD);
        map.put("endpointServiceName", ENDPOINT_SERVICE_NAME_FIELD);
        map.put("textIndexName", TEXT_INDEX_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MongoDbAtlasConfiguration, T> g) {
        return obj -> g.apply((MongoDbAtlasConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String endpoint;
        private String databaseName;
        private String collectionName;
        private String vectorIndexName;
        private String credentialsSecretArn;
        private MongoDbAtlasFieldMapping fieldMapping;
        private String endpointServiceName;
        private String textIndexName;

        private BuilderImpl() {
        }

        private BuilderImpl(MongoDbAtlasConfiguration model) {
            this.endpoint(model.endpoint);
            this.databaseName(model.databaseName);
            this.collectionName(model.collectionName);
            this.vectorIndexName(model.vectorIndexName);
            this.credentialsSecretArn(model.credentialsSecretArn);
            this.fieldMapping(model.fieldMapping);
            this.endpointServiceName(model.endpointServiceName);
            this.textIndexName(model.textIndexName);
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getCollectionName() {
            return this.collectionName;
        }

        public final void setCollectionName(String collectionName) {
            this.collectionName = collectionName;
        }

        @Override
        public final Builder collectionName(String collectionName) {
            this.collectionName = collectionName;
            return this;
        }

        public final String getVectorIndexName() {
            return this.vectorIndexName;
        }

        public final void setVectorIndexName(String vectorIndexName) {
            this.vectorIndexName = vectorIndexName;
        }

        @Override
        public final Builder vectorIndexName(String vectorIndexName) {
            this.vectorIndexName = vectorIndexName;
            return this;
        }

        public final String getCredentialsSecretArn() {
            return this.credentialsSecretArn;
        }

        public final void setCredentialsSecretArn(String credentialsSecretArn) {
            this.credentialsSecretArn = credentialsSecretArn;
        }

        @Override
        public final Builder credentialsSecretArn(String credentialsSecretArn) {
            this.credentialsSecretArn = credentialsSecretArn;
            return this;
        }

        public final MongoDbAtlasFieldMapping.Builder getFieldMapping() {
            return this.fieldMapping != null ? this.fieldMapping.toBuilder() : null;
        }

        public final void setFieldMapping(MongoDbAtlasFieldMapping.BuilderImpl fieldMapping) {
            this.fieldMapping = fieldMapping != null ? fieldMapping.build() : null;
        }

        @Override
        public final Builder fieldMapping(MongoDbAtlasFieldMapping fieldMapping) {
            this.fieldMapping = fieldMapping;
            return this;
        }

        public final String getEndpointServiceName() {
            return this.endpointServiceName;
        }

        public final void setEndpointServiceName(String endpointServiceName) {
            this.endpointServiceName = endpointServiceName;
        }

        @Override
        public final Builder endpointServiceName(String endpointServiceName) {
            this.endpointServiceName = endpointServiceName;
            return this;
        }

        public final String getTextIndexName() {
            return this.textIndexName;
        }

        public final void setTextIndexName(String textIndexName) {
            this.textIndexName = textIndexName;
        }

        @Override
        public final Builder textIndexName(String textIndexName) {
            this.textIndexName = textIndexName;
            return this;
        }

        public MongoDbAtlasConfiguration build() {
            return new MongoDbAtlasConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MongoDbAtlasConfiguration> {
        public Builder endpoint(String var1);

        public Builder databaseName(String var1);

        public Builder collectionName(String var1);

        public Builder vectorIndexName(String var1);

        public Builder credentialsSecretArn(String var1);

        public Builder fieldMapping(MongoDbAtlasFieldMapping var1);

        default public Builder fieldMapping(Consumer<MongoDbAtlasFieldMapping.Builder> fieldMapping) {
            return this.fieldMapping((MongoDbAtlasFieldMapping)((MongoDbAtlasFieldMapping.Builder)MongoDbAtlasFieldMapping.builder().applyMutation(fieldMapping)).build());
        }

        public Builder endpointServiceName(String var1);

        public Builder textIndexName(String var1);
    }
}

