/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagent.model.RedshiftProvisionedAuthType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RedshiftProvisionedAuthConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RedshiftProvisionedAuthConfiguration> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(RedshiftProvisionedAuthConfiguration.getter(RedshiftProvisionedAuthConfiguration::typeAsString)).setter(RedshiftProvisionedAuthConfiguration.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> DATABASE_USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("databaseUser").getter(RedshiftProvisionedAuthConfiguration.getter(RedshiftProvisionedAuthConfiguration::databaseUser)).setter(RedshiftProvisionedAuthConfiguration.setter(Builder::databaseUser)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databaseUser").build()}).build();
    private static final SdkField<String> USERNAME_PASSWORD_SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("usernamePasswordSecretArn").getter(RedshiftProvisionedAuthConfiguration.getter(RedshiftProvisionedAuthConfiguration::usernamePasswordSecretArn)).setter(RedshiftProvisionedAuthConfiguration.setter(Builder::usernamePasswordSecretArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usernamePasswordSecretArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, DATABASE_USER_FIELD, USERNAME_PASSWORD_SECRET_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RedshiftProvisionedAuthConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String databaseUser;
    private final String usernamePasswordSecretArn;

    private RedshiftProvisionedAuthConfiguration(BuilderImpl builder) {
        this.type = builder.type;
        this.databaseUser = builder.databaseUser;
        this.usernamePasswordSecretArn = builder.usernamePasswordSecretArn;
    }

    public final RedshiftProvisionedAuthType type() {
        return RedshiftProvisionedAuthType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String databaseUser() {
        return this.databaseUser;
    }

    public final String usernamePasswordSecretArn() {
        return this.usernamePasswordSecretArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseUser());
        hashCode = 31 * hashCode + Objects.hashCode(this.usernamePasswordSecretArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftProvisionedAuthConfiguration)) {
            return false;
        }
        RedshiftProvisionedAuthConfiguration other = (RedshiftProvisionedAuthConfiguration)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.databaseUser(), other.databaseUser()) && Objects.equals(this.usernamePasswordSecretArn(), other.usernamePasswordSecretArn());
    }

    public final String toString() {
        return ToString.builder((String)"RedshiftProvisionedAuthConfiguration").add("Type", (Object)this.typeAsString()).add("DatabaseUser", (Object)this.databaseUser()).add("UsernamePasswordSecretArn", (Object)this.usernamePasswordSecretArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "databaseUser": {
                return Optional.ofNullable(clazz.cast(this.databaseUser()));
            }
            case "usernamePasswordSecretArn": {
                return Optional.ofNullable(clazz.cast(this.usernamePasswordSecretArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("type", TYPE_FIELD);
        map.put("databaseUser", DATABASE_USER_FIELD);
        map.put("usernamePasswordSecretArn", USERNAME_PASSWORD_SECRET_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RedshiftProvisionedAuthConfiguration, T> g) {
        return obj -> g.apply((RedshiftProvisionedAuthConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String databaseUser;
        private String usernamePasswordSecretArn;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftProvisionedAuthConfiguration model) {
            this.type(model.type);
            this.databaseUser(model.databaseUser);
            this.usernamePasswordSecretArn(model.usernamePasswordSecretArn);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RedshiftProvisionedAuthType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getDatabaseUser() {
            return this.databaseUser;
        }

        public final void setDatabaseUser(String databaseUser) {
            this.databaseUser = databaseUser;
        }

        @Override
        public final Builder databaseUser(String databaseUser) {
            this.databaseUser = databaseUser;
            return this;
        }

        public final String getUsernamePasswordSecretArn() {
            return this.usernamePasswordSecretArn;
        }

        public final void setUsernamePasswordSecretArn(String usernamePasswordSecretArn) {
            this.usernamePasswordSecretArn = usernamePasswordSecretArn;
        }

        @Override
        public final Builder usernamePasswordSecretArn(String usernamePasswordSecretArn) {
            this.usernamePasswordSecretArn = usernamePasswordSecretArn;
            return this;
        }

        public RedshiftProvisionedAuthConfiguration build() {
            return new RedshiftProvisionedAuthConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RedshiftProvisionedAuthConfiguration> {
        public Builder type(String var1);

        public Builder type(RedshiftProvisionedAuthType var1);

        public Builder databaseUser(String var1);

        public Builder usernamePasswordSecretArn(String var1);
    }
}

