/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagent.BedrockAgentAsyncClient;
import software.amazon.awssdk.services.bedrockagent.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagent.model.KnowledgeBaseDocumentDetail;
import software.amazon.awssdk.services.bedrockagent.model.ListKnowledgeBaseDocumentsRequest;
import software.amazon.awssdk.services.bedrockagent.model.ListKnowledgeBaseDocumentsResponse;

public class ListKnowledgeBaseDocumentsPublisher
implements SdkPublisher<ListKnowledgeBaseDocumentsResponse> {
    private final BedrockAgentAsyncClient client;
    private final ListKnowledgeBaseDocumentsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListKnowledgeBaseDocumentsPublisher(BedrockAgentAsyncClient client, ListKnowledgeBaseDocumentsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListKnowledgeBaseDocumentsPublisher(BedrockAgentAsyncClient client, ListKnowledgeBaseDocumentsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListKnowledgeBaseDocumentsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListKnowledgeBaseDocumentsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<KnowledgeBaseDocumentDetail> documentDetails() {
        Function<ListKnowledgeBaseDocumentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.documentDetails() != null) {
                return response.documentDetails().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListKnowledgeBaseDocumentsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListKnowledgeBaseDocumentsResponseFetcher
    implements AsyncPageFetcher<ListKnowledgeBaseDocumentsResponse> {
        private ListKnowledgeBaseDocumentsResponseFetcher() {
        }

        public boolean hasNextPage(ListKnowledgeBaseDocumentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListKnowledgeBaseDocumentsResponse> nextPage(ListKnowledgeBaseDocumentsResponse previousPage) {
            if (previousPage == null) {
                return ListKnowledgeBaseDocumentsPublisher.this.client.listKnowledgeBaseDocuments(ListKnowledgeBaseDocumentsPublisher.this.firstRequest);
            }
            return ListKnowledgeBaseDocumentsPublisher.this.client.listKnowledgeBaseDocuments((ListKnowledgeBaseDocumentsRequest)((Object)ListKnowledgeBaseDocumentsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

