/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ContextEnrichmentType {
    BEDROCK_FOUNDATION_MODEL("BEDROCK_FOUNDATION_MODEL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ContextEnrichmentType> VALUE_MAP;
    private final String value;

    private ContextEnrichmentType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ContextEnrichmentType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ContextEnrichmentType> knownValues() {
        EnumSet<ContextEnrichmentType> knownValues = EnumSet.allOf(ContextEnrichmentType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ContextEnrichmentType.class, ContextEnrichmentType::toString);
    }
}

