/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagent.model.BedrockAgentResponse;
import software.amazon.awssdk.services.bedrockagent.model.FlowSummariesCopier;
import software.amazon.awssdk.services.bedrockagent.model.FlowSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFlowsResponse
extends BedrockAgentResponse
implements ToCopyableBuilder<Builder, ListFlowsResponse> {
    private static final SdkField<List<FlowSummary>> FLOW_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("flowSummaries").getter(ListFlowsResponse.getter(ListFlowsResponse::flowSummaries)).setter(ListFlowsResponse.setter(Builder::flowSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FlowSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListFlowsResponse.getter(ListFlowsResponse::nextToken)).setter(ListFlowsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListFlowsResponse.memberNameToFieldInitializer();
    private final List<FlowSummary> flowSummaries;
    private final String nextToken;

    private ListFlowsResponse(BuilderImpl builder) {
        super(builder);
        this.flowSummaries = builder.flowSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasFlowSummaries() {
        return this.flowSummaries != null && !(this.flowSummaries instanceof SdkAutoConstructList);
    }

    public final List<FlowSummary> flowSummaries() {
        return this.flowSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFlowSummaries() ? this.flowSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFlowsResponse)) {
            return false;
        }
        ListFlowsResponse other = (ListFlowsResponse)((Object)obj);
        return this.hasFlowSummaries() == other.hasFlowSummaries() && Objects.equals(this.flowSummaries(), other.flowSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListFlowsResponse").add("FlowSummaries", this.hasFlowSummaries() ? this.flowSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "flowSummaries": {
                return Optional.ofNullable(clazz.cast(this.flowSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("flowSummaries", FLOW_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListFlowsResponse, T> g) {
        return obj -> g.apply((ListFlowsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentResponse.BuilderImpl
    implements Builder {
        private List<FlowSummary> flowSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFlowsResponse model) {
            super(model);
            this.flowSummaries(model.flowSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<FlowSummary.Builder> getFlowSummaries() {
            List<FlowSummary.Builder> result = FlowSummariesCopier.copyToBuilder(this.flowSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFlowSummaries(Collection<FlowSummary.BuilderImpl> flowSummaries) {
            this.flowSummaries = FlowSummariesCopier.copyFromBuilder(flowSummaries);
        }

        @Override
        public final Builder flowSummaries(Collection<FlowSummary> flowSummaries) {
            this.flowSummaries = FlowSummariesCopier.copy(flowSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flowSummaries(FlowSummary ... flowSummaries) {
            this.flowSummaries(Arrays.asList(flowSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flowSummaries(Consumer<FlowSummary.Builder> ... flowSummaries) {
            this.flowSummaries(Stream.of(flowSummaries).map(c -> (FlowSummary)((FlowSummary.Builder)FlowSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListFlowsResponse build() {
            return new ListFlowsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BedrockAgentResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFlowsResponse> {
        public Builder flowSummaries(Collection<FlowSummary> var1);

        public Builder flowSummaries(FlowSummary ... var1);

        public Builder flowSummaries(Consumer<FlowSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

