/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum KnowledgeBaseType {
    VECTOR("VECTOR"),
    KENDRA("KENDRA"),
    SQL("SQL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, KnowledgeBaseType> VALUE_MAP;
    private final String value;

    private KnowledgeBaseType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static KnowledgeBaseType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<KnowledgeBaseType> knownValues() {
        EnumSet<KnowledgeBaseType> knownValues = EnumSet.allOf(KnowledgeBaseType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(KnowledgeBaseType.class, KnowledgeBaseType::toString);
    }
}

