/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AgentCollaboration {
    SUPERVISOR("SUPERVISOR"),
    SUPERVISOR_ROUTER("SUPERVISOR_ROUTER"),
    DISABLED("DISABLED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AgentCollaboration> VALUE_MAP;
    private final String value;

    private AgentCollaboration(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AgentCollaboration fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AgentCollaboration> knownValues() {
        EnumSet<AgentCollaboration> knownValues = EnumSet.allOf(AgentCollaboration.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AgentCollaboration.class, AgentCollaboration::toString);
    }
}

