/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SharePointAuthType {
    OAUTH2_CLIENT_CREDENTIALS("OAUTH2_CLIENT_CREDENTIALS"),
    OAUTH2_SHAREPOINT_APP_ONLY_CLIENT_CREDENTIALS("OAUTH2_SHAREPOINT_APP_ONLY_CLIENT_CREDENTIALS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SharePointAuthType> VALUE_MAP;
    private final String value;

    private SharePointAuthType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SharePointAuthType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SharePointAuthType> knownValues() {
        EnumSet<SharePointAuthType> knownValues = EnumSet.allOf(SharePointAuthType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SharePointAuthType.class, SharePointAuthType::toString);
    }
}

