/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagent.model.FlowValidationDetails;
import software.amazon.awssdk.services.bedrockagent.model.FlowValidationSeverity;
import software.amazon.awssdk.services.bedrockagent.model.FlowValidationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FlowValidation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FlowValidation> {
    private static final SdkField<FlowValidationDetails> DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("details").getter(FlowValidation.getter(FlowValidation::details)).setter(FlowValidation.setter(Builder::details)).constructor(FlowValidationDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("details").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("message").getter(FlowValidation.getter(FlowValidation::message)).setter(FlowValidation.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final SdkField<String> SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("severity").getter(FlowValidation.getter(FlowValidation::severityAsString)).setter(FlowValidation.setter(Builder::severity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severity").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(FlowValidation.getter(FlowValidation::typeAsString)).setter(FlowValidation.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETAILS_FIELD, MESSAGE_FIELD, SEVERITY_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FlowValidation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final FlowValidationDetails details;
    private final String message;
    private final String severity;
    private final String type;

    private FlowValidation(BuilderImpl builder) {
        this.details = builder.details;
        this.message = builder.message;
        this.severity = builder.severity;
        this.type = builder.type;
    }

    public final FlowValidationDetails details() {
        return this.details;
    }

    public final String message() {
        return this.message;
    }

    public final FlowValidationSeverity severity() {
        return FlowValidationSeverity.fromValue(this.severity);
    }

    public final String severityAsString() {
        return this.severity;
    }

    public final FlowValidationType type() {
        return FlowValidationType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.details());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.severityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowValidation)) {
            return false;
        }
        FlowValidation other = (FlowValidation)obj;
        return Objects.equals(this.details(), other.details()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.severityAsString(), other.severityAsString()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"FlowValidation").add("Details", (Object)this.details()).add("Message", (Object)this.message()).add("Severity", (Object)this.severityAsString()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "details": {
                return Optional.ofNullable(clazz.cast(this.details()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "severity": {
                return Optional.ofNullable(clazz.cast(this.severityAsString()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("details", DETAILS_FIELD);
        map.put("message", MESSAGE_FIELD);
        map.put("severity", SEVERITY_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FlowValidation, T> g) {
        return obj -> g.apply((FlowValidation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private FlowValidationDetails details;
        private String message;
        private String severity;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(FlowValidation model) {
            this.details(model.details);
            this.message(model.message);
            this.severity(model.severity);
            this.type(model.type);
        }

        public final FlowValidationDetails.Builder getDetails() {
            return this.details != null ? this.details.toBuilder() : null;
        }

        public final void setDetails(FlowValidationDetails.BuilderImpl details) {
            this.details = details != null ? details.build() : null;
        }

        @Override
        public final Builder details(FlowValidationDetails details) {
            this.details = details;
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getSeverity() {
            return this.severity;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        @Override
        public final Builder severity(FlowValidationSeverity severity) {
            this.severity(severity == null ? null : severity.toString());
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FlowValidationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public FlowValidation build() {
            return new FlowValidation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FlowValidation> {
        public Builder details(FlowValidationDetails var1);

        default public Builder details(Consumer<FlowValidationDetails.Builder> details) {
            return this.details((FlowValidationDetails)((FlowValidationDetails.Builder)FlowValidationDetails.builder().applyMutation(details)).build());
        }

        public Builder message(String var1);

        public Builder severity(String var1);

        public Builder severity(FlowValidationSeverity var1);

        public Builder type(String var1);

        public Builder type(FlowValidationType var1);
    }
}

