/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagent.model.BedrockAgentResponse;
import software.amazon.awssdk.services.bedrockagent.model.PromptSummariesCopier;
import software.amazon.awssdk.services.bedrockagent.model.PromptSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPromptsResponse
extends BedrockAgentResponse
implements ToCopyableBuilder<Builder, ListPromptsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListPromptsResponse.getter(ListPromptsResponse::nextToken)).setter(ListPromptsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<PromptSummary>> PROMPT_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("promptSummaries").getter(ListPromptsResponse.getter(ListPromptsResponse::promptSummaries)).setter(ListPromptsResponse.setter(Builder::promptSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PromptSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, PROMPT_SUMMARIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("promptSummaries", PROMPT_SUMMARIES_FIELD);
        }
    });
    private final String nextToken;
    private final List<PromptSummary> promptSummaries;

    private ListPromptsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.promptSummaries = builder.promptSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasPromptSummaries() {
        return this.promptSummaries != null && !(this.promptSummaries instanceof SdkAutoConstructList);
    }

    public final List<PromptSummary> promptSummaries() {
        return this.promptSummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPromptSummaries() ? this.promptSummaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPromptsResponse)) {
            return false;
        }
        ListPromptsResponse other = (ListPromptsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasPromptSummaries() == other.hasPromptSummaries() && Objects.equals(this.promptSummaries(), other.promptSummaries());
    }

    public final String toString() {
        return ToString.builder((String)"ListPromptsResponse").add("NextToken", (Object)this.nextToken()).add("PromptSummaries", this.hasPromptSummaries() ? this.promptSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "promptSummaries": {
                return Optional.ofNullable(clazz.cast(this.promptSummaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListPromptsResponse, T> g) {
        return obj -> g.apply((ListPromptsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<PromptSummary> promptSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListPromptsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.promptSummaries(model.promptSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<PromptSummary.Builder> getPromptSummaries() {
            List<PromptSummary.Builder> result = PromptSummariesCopier.copyToBuilder(this.promptSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPromptSummaries(Collection<PromptSummary.BuilderImpl> promptSummaries) {
            this.promptSummaries = PromptSummariesCopier.copyFromBuilder(promptSummaries);
        }

        @Override
        public final Builder promptSummaries(Collection<PromptSummary> promptSummaries) {
            this.promptSummaries = PromptSummariesCopier.copy(promptSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder promptSummaries(PromptSummary ... promptSummaries) {
            this.promptSummaries(Arrays.asList(promptSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder promptSummaries(Consumer<PromptSummary.Builder> ... promptSummaries) {
            this.promptSummaries(Stream.of(promptSummaries).map(c -> (PromptSummary)((PromptSummary.Builder)PromptSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListPromptsResponse build() {
            return new ListPromptsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BedrockAgentResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPromptsResponse> {
        public Builder nextToken(String var1);

        public Builder promptSummaries(Collection<PromptSummary> var1);

        public Builder promptSummaries(PromptSummary ... var1);

        public Builder promptSummaries(Consumer<PromptSummary.Builder> ... var1);
    }
}

