/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagent.model.BedrockAgentRequest;
import software.amazon.awssdk.services.bedrockagent.model.KnowledgeBaseConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.StorageConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateKnowledgeBaseRequest
extends BedrockAgentRequest
implements ToCopyableBuilder<Builder, UpdateKnowledgeBaseRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateKnowledgeBaseRequest.getter(UpdateKnowledgeBaseRequest::description)).setter(UpdateKnowledgeBaseRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<KnowledgeBaseConfiguration> KNOWLEDGE_BASE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("knowledgeBaseConfiguration").getter(UpdateKnowledgeBaseRequest.getter(UpdateKnowledgeBaseRequest::knowledgeBaseConfiguration)).setter(UpdateKnowledgeBaseRequest.setter(Builder::knowledgeBaseConfiguration)).constructor(KnowledgeBaseConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseConfiguration").build()}).build();
    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("knowledgeBaseId").getter(UpdateKnowledgeBaseRequest.getter(UpdateKnowledgeBaseRequest::knowledgeBaseId)).setter(UpdateKnowledgeBaseRequest.setter(Builder::knowledgeBaseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("knowledgeBaseId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateKnowledgeBaseRequest.getter(UpdateKnowledgeBaseRequest::name)).setter(UpdateKnowledgeBaseRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(UpdateKnowledgeBaseRequest.getter(UpdateKnowledgeBaseRequest::roleArn)).setter(UpdateKnowledgeBaseRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<StorageConfiguration> STORAGE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("storageConfiguration").getter(UpdateKnowledgeBaseRequest.getter(UpdateKnowledgeBaseRequest::storageConfiguration)).setter(UpdateKnowledgeBaseRequest.setter(Builder::storageConfiguration)).constructor(StorageConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, KNOWLEDGE_BASE_CONFIGURATION_FIELD, KNOWLEDGE_BASE_ID_FIELD, NAME_FIELD, ROLE_ARN_FIELD, STORAGE_CONFIGURATION_FIELD));
    private final String description;
    private final KnowledgeBaseConfiguration knowledgeBaseConfiguration;
    private final String knowledgeBaseId;
    private final String name;
    private final String roleArn;
    private final StorageConfiguration storageConfiguration;

    private UpdateKnowledgeBaseRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.knowledgeBaseConfiguration = builder.knowledgeBaseConfiguration;
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.name = builder.name;
        this.roleArn = builder.roleArn;
        this.storageConfiguration = builder.storageConfiguration;
    }

    public final String description() {
        return this.description;
    }

    public final KnowledgeBaseConfiguration knowledgeBaseConfiguration() {
        return this.knowledgeBaseConfiguration;
    }

    public final String knowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public final String name() {
        return this.name;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final StorageConfiguration storageConfiguration() {
        return this.storageConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateKnowledgeBaseRequest)) {
            return false;
        }
        UpdateKnowledgeBaseRequest other = (UpdateKnowledgeBaseRequest)((Object)obj);
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.knowledgeBaseConfiguration(), other.knowledgeBaseConfiguration()) && Objects.equals(this.knowledgeBaseId(), other.knowledgeBaseId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.storageConfiguration(), other.storageConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateKnowledgeBaseRequest").add("Description", (Object)this.description()).add("KnowledgeBaseConfiguration", (Object)this.knowledgeBaseConfiguration()).add("KnowledgeBaseId", (Object)this.knowledgeBaseId()).add("Name", (Object)this.name()).add("RoleArn", (Object)this.roleArn()).add("StorageConfiguration", (Object)this.storageConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "knowledgeBaseConfiguration": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseConfiguration()));
            }
            case "knowledgeBaseId": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "storageConfiguration": {
                return Optional.ofNullable(clazz.cast(this.storageConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateKnowledgeBaseRequest, T> g) {
        return obj -> g.apply((UpdateKnowledgeBaseRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentRequest.BuilderImpl
    implements Builder {
        private String description;
        private KnowledgeBaseConfiguration knowledgeBaseConfiguration;
        private String knowledgeBaseId;
        private String name;
        private String roleArn;
        private StorageConfiguration storageConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateKnowledgeBaseRequest model) {
            super(model);
            this.description(model.description);
            this.knowledgeBaseConfiguration(model.knowledgeBaseConfiguration);
            this.knowledgeBaseId(model.knowledgeBaseId);
            this.name(model.name);
            this.roleArn(model.roleArn);
            this.storageConfiguration(model.storageConfiguration);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final KnowledgeBaseConfiguration.Builder getKnowledgeBaseConfiguration() {
            return this.knowledgeBaseConfiguration != null ? this.knowledgeBaseConfiguration.toBuilder() : null;
        }

        public final void setKnowledgeBaseConfiguration(KnowledgeBaseConfiguration.BuilderImpl knowledgeBaseConfiguration) {
            this.knowledgeBaseConfiguration = knowledgeBaseConfiguration != null ? knowledgeBaseConfiguration.build() : null;
        }

        @Override
        public final Builder knowledgeBaseConfiguration(KnowledgeBaseConfiguration knowledgeBaseConfiguration) {
            this.knowledgeBaseConfiguration = knowledgeBaseConfiguration;
            return this;
        }

        public final String getKnowledgeBaseId() {
            return this.knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final StorageConfiguration.Builder getStorageConfiguration() {
            return this.storageConfiguration != null ? this.storageConfiguration.toBuilder() : null;
        }

        public final void setStorageConfiguration(StorageConfiguration.BuilderImpl storageConfiguration) {
            this.storageConfiguration = storageConfiguration != null ? storageConfiguration.build() : null;
        }

        @Override
        public final Builder storageConfiguration(StorageConfiguration storageConfiguration) {
            this.storageConfiguration = storageConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateKnowledgeBaseRequest build() {
            return new UpdateKnowledgeBaseRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BedrockAgentRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateKnowledgeBaseRequest> {
        public Builder description(String var1);

        public Builder knowledgeBaseConfiguration(KnowledgeBaseConfiguration var1);

        default public Builder knowledgeBaseConfiguration(Consumer<KnowledgeBaseConfiguration.Builder> knowledgeBaseConfiguration) {
            return this.knowledgeBaseConfiguration((KnowledgeBaseConfiguration)((KnowledgeBaseConfiguration.Builder)KnowledgeBaseConfiguration.builder().applyMutation(knowledgeBaseConfiguration)).build());
        }

        public Builder knowledgeBaseId(String var1);

        public Builder name(String var1);

        public Builder roleArn(String var1);

        public Builder storageConfiguration(StorageConfiguration var1);

        default public Builder storageConfiguration(Consumer<StorageConfiguration.Builder> storageConfiguration) {
            return this.storageConfiguration((StorageConfiguration)((StorageConfiguration.Builder)StorageConfiguration.builder().applyMutation(storageConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

