/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockagent.model.BedrockAgentRequest;
import software.amazon.awssdk.services.bedrockagent.model.PromptVariant;
import software.amazon.awssdk.services.bedrockagent.model.PromptVariantListCopier;
import software.amazon.awssdk.services.bedrockagent.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePromptRequest
extends BedrockAgentRequest
implements ToCopyableBuilder<Builder, CreatePromptRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreatePromptRequest.getter(CreatePromptRequest::clientToken)).setter(CreatePromptRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> CUSTOMER_ENCRYPTION_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customerEncryptionKeyArn").getter(CreatePromptRequest.getter(CreatePromptRequest::customerEncryptionKeyArn)).setter(CreatePromptRequest.setter(Builder::customerEncryptionKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerEncryptionKeyArn").build()}).build();
    private static final SdkField<String> DEFAULT_VARIANT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("defaultVariant").getter(CreatePromptRequest.getter(CreatePromptRequest::defaultVariant)).setter(CreatePromptRequest.setter(Builder::defaultVariant)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultVariant").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreatePromptRequest.getter(CreatePromptRequest::description)).setter(CreatePromptRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreatePromptRequest.getter(CreatePromptRequest::name)).setter(CreatePromptRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreatePromptRequest.getter(CreatePromptRequest::tags)).setter(CreatePromptRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<PromptVariant>> VARIANTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("variants").getter(CreatePromptRequest.getter(CreatePromptRequest::variants)).setter(CreatePromptRequest.setter(Builder::variants)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variants").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PromptVariant::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, CUSTOMER_ENCRYPTION_KEY_ARN_FIELD, DEFAULT_VARIANT_FIELD, DESCRIPTION_FIELD, NAME_FIELD, TAGS_FIELD, VARIANTS_FIELD));
    private final String clientToken;
    private final String customerEncryptionKeyArn;
    private final String defaultVariant;
    private final String description;
    private final String name;
    private final Map<String, String> tags;
    private final List<PromptVariant> variants;

    private CreatePromptRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.customerEncryptionKeyArn = builder.customerEncryptionKeyArn;
        this.defaultVariant = builder.defaultVariant;
        this.description = builder.description;
        this.name = builder.name;
        this.tags = builder.tags;
        this.variants = builder.variants;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String customerEncryptionKeyArn() {
        return this.customerEncryptionKeyArn;
    }

    public final String defaultVariant() {
        return this.defaultVariant;
    }

    public final String description() {
        return this.description;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final boolean hasVariants() {
        return this.variants != null && !(this.variants instanceof SdkAutoConstructList);
    }

    public final List<PromptVariant> variants() {
        return this.variants;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerEncryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultVariant());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVariants() ? this.variants() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePromptRequest)) {
            return false;
        }
        CreatePromptRequest other = (CreatePromptRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.customerEncryptionKeyArn(), other.customerEncryptionKeyArn()) && Objects.equals(this.defaultVariant(), other.defaultVariant()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.name(), other.name()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasVariants() == other.hasVariants() && Objects.equals(this.variants(), other.variants());
    }

    public final String toString() {
        return ToString.builder((String)"CreatePromptRequest").add("ClientToken", (Object)this.clientToken()).add("CustomerEncryptionKeyArn", (Object)this.customerEncryptionKeyArn()).add("DefaultVariant", (Object)this.defaultVariant()).add("Description", (Object)this.description()).add("Name", (Object)this.name()).add("Tags", this.hasTags() ? this.tags() : null).add("Variants", (Object)(this.variants() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "customerEncryptionKeyArn": {
                return Optional.ofNullable(clazz.cast(this.customerEncryptionKeyArn()));
            }
            case "defaultVariant": {
                return Optional.ofNullable(clazz.cast(this.defaultVariant()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "variants": {
                return Optional.ofNullable(clazz.cast(this.variants()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePromptRequest, T> g) {
        return obj -> g.apply((CreatePromptRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String customerEncryptionKeyArn;
        private String defaultVariant;
        private String description;
        private String name;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private List<PromptVariant> variants = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePromptRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.customerEncryptionKeyArn(model.customerEncryptionKeyArn);
            this.defaultVariant(model.defaultVariant);
            this.description(model.description);
            this.name(model.name);
            this.tags(model.tags);
            this.variants(model.variants);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getCustomerEncryptionKeyArn() {
            return this.customerEncryptionKeyArn;
        }

        public final void setCustomerEncryptionKeyArn(String customerEncryptionKeyArn) {
            this.customerEncryptionKeyArn = customerEncryptionKeyArn;
        }

        @Override
        public final Builder customerEncryptionKeyArn(String customerEncryptionKeyArn) {
            this.customerEncryptionKeyArn = customerEncryptionKeyArn;
            return this;
        }

        public final String getDefaultVariant() {
            return this.defaultVariant;
        }

        public final void setDefaultVariant(String defaultVariant) {
            this.defaultVariant = defaultVariant;
        }

        @Override
        public final Builder defaultVariant(String defaultVariant) {
            this.defaultVariant = defaultVariant;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final List<PromptVariant.Builder> getVariants() {
            List<PromptVariant.Builder> result = PromptVariantListCopier.copyToBuilder(this.variants);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVariants(Collection<PromptVariant.BuilderImpl> variants) {
            this.variants = PromptVariantListCopier.copyFromBuilder(variants);
        }

        @Override
        public final Builder variants(Collection<PromptVariant> variants) {
            this.variants = PromptVariantListCopier.copy(variants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variants(PromptVariant ... variants) {
            this.variants(Arrays.asList(variants));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variants(Consumer<PromptVariant.Builder> ... variants) {
            this.variants(Stream.of(variants).map(c -> (PromptVariant)((PromptVariant.Builder)PromptVariant.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePromptRequest build() {
            return new CreatePromptRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BedrockAgentRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePromptRequest> {
        public Builder clientToken(String var1);

        public Builder customerEncryptionKeyArn(String var1);

        public Builder defaultVariant(String var1);

        public Builder description(String var1);

        public Builder name(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder variants(Collection<PromptVariant> var1);

        public Builder variants(PromptVariant ... var1);

        public Builder variants(Consumer<PromptVariant.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

