/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagent.model.ChunkingStrategy;
import software.amazon.awssdk.services.bedrockagent.model.FixedSizeChunkingConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChunkingConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ChunkingConfiguration> {
    private static final SdkField<String> CHUNKING_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("chunkingStrategy").getter(ChunkingConfiguration.getter(ChunkingConfiguration::chunkingStrategyAsString)).setter(ChunkingConfiguration.setter(Builder::chunkingStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("chunkingStrategy").build()}).build();
    private static final SdkField<FixedSizeChunkingConfiguration> FIXED_SIZE_CHUNKING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("fixedSizeChunkingConfiguration").getter(ChunkingConfiguration.getter(ChunkingConfiguration::fixedSizeChunkingConfiguration)).setter(ChunkingConfiguration.setter(Builder::fixedSizeChunkingConfiguration)).constructor(FixedSizeChunkingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fixedSizeChunkingConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHUNKING_STRATEGY_FIELD, FIXED_SIZE_CHUNKING_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String chunkingStrategy;
    private final FixedSizeChunkingConfiguration fixedSizeChunkingConfiguration;

    private ChunkingConfiguration(BuilderImpl builder) {
        this.chunkingStrategy = builder.chunkingStrategy;
        this.fixedSizeChunkingConfiguration = builder.fixedSizeChunkingConfiguration;
    }

    public final ChunkingStrategy chunkingStrategy() {
        return ChunkingStrategy.fromValue(this.chunkingStrategy);
    }

    public final String chunkingStrategyAsString() {
        return this.chunkingStrategy;
    }

    public final FixedSizeChunkingConfiguration fixedSizeChunkingConfiguration() {
        return this.fixedSizeChunkingConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.chunkingStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fixedSizeChunkingConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChunkingConfiguration)) {
            return false;
        }
        ChunkingConfiguration other = (ChunkingConfiguration)obj;
        return Objects.equals(this.chunkingStrategyAsString(), other.chunkingStrategyAsString()) && Objects.equals(this.fixedSizeChunkingConfiguration(), other.fixedSizeChunkingConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"ChunkingConfiguration").add("ChunkingStrategy", (Object)this.chunkingStrategyAsString()).add("FixedSizeChunkingConfiguration", (Object)this.fixedSizeChunkingConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "chunkingStrategy": {
                return Optional.ofNullable(clazz.cast(this.chunkingStrategyAsString()));
            }
            case "fixedSizeChunkingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.fixedSizeChunkingConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChunkingConfiguration, T> g) {
        return obj -> g.apply((ChunkingConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String chunkingStrategy;
        private FixedSizeChunkingConfiguration fixedSizeChunkingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ChunkingConfiguration model) {
            this.chunkingStrategy(model.chunkingStrategy);
            this.fixedSizeChunkingConfiguration(model.fixedSizeChunkingConfiguration);
        }

        public final String getChunkingStrategy() {
            return this.chunkingStrategy;
        }

        public final void setChunkingStrategy(String chunkingStrategy) {
            this.chunkingStrategy = chunkingStrategy;
        }

        @Override
        public final Builder chunkingStrategy(String chunkingStrategy) {
            this.chunkingStrategy = chunkingStrategy;
            return this;
        }

        @Override
        public final Builder chunkingStrategy(ChunkingStrategy chunkingStrategy) {
            this.chunkingStrategy(chunkingStrategy == null ? null : chunkingStrategy.toString());
            return this;
        }

        public final FixedSizeChunkingConfiguration.Builder getFixedSizeChunkingConfiguration() {
            return this.fixedSizeChunkingConfiguration != null ? this.fixedSizeChunkingConfiguration.toBuilder() : null;
        }

        public final void setFixedSizeChunkingConfiguration(FixedSizeChunkingConfiguration.BuilderImpl fixedSizeChunkingConfiguration) {
            this.fixedSizeChunkingConfiguration = fixedSizeChunkingConfiguration != null ? fixedSizeChunkingConfiguration.build() : null;
        }

        @Override
        public final Builder fixedSizeChunkingConfiguration(FixedSizeChunkingConfiguration fixedSizeChunkingConfiguration) {
            this.fixedSizeChunkingConfiguration = fixedSizeChunkingConfiguration;
            return this;
        }

        public ChunkingConfiguration build() {
            return new ChunkingConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ChunkingConfiguration> {
        public Builder chunkingStrategy(String var1);

        public Builder chunkingStrategy(ChunkingStrategy var1);

        public Builder fixedSizeChunkingConfiguration(FixedSizeChunkingConfiguration var1);

        default public Builder fixedSizeChunkingConfiguration(Consumer<FixedSizeChunkingConfiguration.Builder> fixedSizeChunkingConfiguration) {
            return this.fixedSizeChunkingConfiguration((FixedSizeChunkingConfiguration)((FixedSizeChunkingConfiguration.Builder)FixedSizeChunkingConfiguration.builder().applyMutation(fixedSizeChunkingConfiguration)).build());
        }
    }
}

