/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagent.BedrockAgentAsyncClient;
import software.amazon.awssdk.services.bedrockagent.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagent.model.AgentSummary;
import software.amazon.awssdk.services.bedrockagent.model.ListAgentsRequest;
import software.amazon.awssdk.services.bedrockagent.model.ListAgentsResponse;

public class ListAgentsPublisher
implements SdkPublisher<ListAgentsResponse> {
    private final BedrockAgentAsyncClient client;
    private final ListAgentsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAgentsPublisher(BedrockAgentAsyncClient client, ListAgentsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAgentsPublisher(BedrockAgentAsyncClient client, ListAgentsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAgentsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAgentsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AgentSummary> agentSummaries() {
        Function<ListAgentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.agentSummaries() != null) {
                return response.agentSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAgentsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAgentsResponseFetcher
    implements AsyncPageFetcher<ListAgentsResponse> {
        private ListAgentsResponseFetcher() {
        }

        public boolean hasNextPage(ListAgentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAgentsResponse> nextPage(ListAgentsResponse previousPage) {
            if (previousPage == null) {
                return ListAgentsPublisher.this.client.listAgents(ListAgentsPublisher.this.firstRequest);
            }
            return ListAgentsPublisher.this.client.listAgents((ListAgentsRequest)((Object)ListAgentsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

