/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagent.model.APISchema;
import software.amazon.awssdk.services.bedrockagent.model.ActionGroupExecutor;
import software.amazon.awssdk.services.bedrockagent.model.ActionGroupSignature;
import software.amazon.awssdk.services.bedrockagent.model.ActionGroupState;
import software.amazon.awssdk.services.bedrockagent.model.BedrockAgentRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAgentActionGroupRequest
extends BedrockAgentRequest
implements ToCopyableBuilder<Builder, CreateAgentActionGroupRequest> {
    private static final SdkField<String> AGENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentId").getter(CreateAgentActionGroupRequest.getter(CreateAgentActionGroupRequest::agentId)).setter(CreateAgentActionGroupRequest.setter(Builder::agentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("agentId").build()}).build();
    private static final SdkField<String> AGENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentVersion").getter(CreateAgentActionGroupRequest.getter(CreateAgentActionGroupRequest::agentVersion)).setter(CreateAgentActionGroupRequest.setter(Builder::agentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("agentVersion").build()}).build();
    private static final SdkField<String> ACTION_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionGroupName").getter(CreateAgentActionGroupRequest.getter(CreateAgentActionGroupRequest::actionGroupName)).setter(CreateAgentActionGroupRequest.setter(Builder::actionGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionGroupName").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateAgentActionGroupRequest.getter(CreateAgentActionGroupRequest::clientToken)).setter(CreateAgentActionGroupRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateAgentActionGroupRequest.getter(CreateAgentActionGroupRequest::description)).setter(CreateAgentActionGroupRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> PARENT_ACTION_GROUP_SIGNATURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("parentActionGroupSignature").getter(CreateAgentActionGroupRequest.getter(CreateAgentActionGroupRequest::parentActionGroupSignatureAsString)).setter(CreateAgentActionGroupRequest.setter(Builder::parentActionGroupSignature)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentActionGroupSignature").build()}).build();
    private static final SdkField<ActionGroupExecutor> ACTION_GROUP_EXECUTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("actionGroupExecutor").getter(CreateAgentActionGroupRequest.getter(CreateAgentActionGroupRequest::actionGroupExecutor)).setter(CreateAgentActionGroupRequest.setter(Builder::actionGroupExecutor)).constructor(ActionGroupExecutor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionGroupExecutor").build()}).build();
    private static final SdkField<APISchema> API_SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("apiSchema").getter(CreateAgentActionGroupRequest.getter(CreateAgentActionGroupRequest::apiSchema)).setter(CreateAgentActionGroupRequest.setter(Builder::apiSchema)).constructor(APISchema::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiSchema").build()}).build();
    private static final SdkField<String> ACTION_GROUP_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionGroupState").getter(CreateAgentActionGroupRequest.getter(CreateAgentActionGroupRequest::actionGroupStateAsString)).setter(CreateAgentActionGroupRequest.setter(Builder::actionGroupState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionGroupState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_ID_FIELD, AGENT_VERSION_FIELD, ACTION_GROUP_NAME_FIELD, CLIENT_TOKEN_FIELD, DESCRIPTION_FIELD, PARENT_ACTION_GROUP_SIGNATURE_FIELD, ACTION_GROUP_EXECUTOR_FIELD, API_SCHEMA_FIELD, ACTION_GROUP_STATE_FIELD));
    private final String agentId;
    private final String agentVersion;
    private final String actionGroupName;
    private final String clientToken;
    private final String description;
    private final String parentActionGroupSignature;
    private final ActionGroupExecutor actionGroupExecutor;
    private final APISchema apiSchema;
    private final String actionGroupState;

    private CreateAgentActionGroupRequest(BuilderImpl builder) {
        super(builder);
        this.agentId = builder.agentId;
        this.agentVersion = builder.agentVersion;
        this.actionGroupName = builder.actionGroupName;
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.parentActionGroupSignature = builder.parentActionGroupSignature;
        this.actionGroupExecutor = builder.actionGroupExecutor;
        this.apiSchema = builder.apiSchema;
        this.actionGroupState = builder.actionGroupState;
    }

    public final String agentId() {
        return this.agentId;
    }

    public final String agentVersion() {
        return this.agentVersion;
    }

    public final String actionGroupName() {
        return this.actionGroupName;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String description() {
        return this.description;
    }

    public final ActionGroupSignature parentActionGroupSignature() {
        return ActionGroupSignature.fromValue(this.parentActionGroupSignature);
    }

    public final String parentActionGroupSignatureAsString() {
        return this.parentActionGroupSignature;
    }

    public final ActionGroupExecutor actionGroupExecutor() {
        return this.actionGroupExecutor;
    }

    public final APISchema apiSchema() {
        return this.apiSchema;
    }

    public final ActionGroupState actionGroupState() {
        return ActionGroupState.fromValue(this.actionGroupState);
    }

    public final String actionGroupStateAsString() {
        return this.actionGroupState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.agentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentActionGroupSignatureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionGroupExecutor());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiSchema());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionGroupStateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAgentActionGroupRequest)) {
            return false;
        }
        CreateAgentActionGroupRequest other = (CreateAgentActionGroupRequest)((Object)obj);
        return Objects.equals(this.agentId(), other.agentId()) && Objects.equals(this.agentVersion(), other.agentVersion()) && Objects.equals(this.actionGroupName(), other.actionGroupName()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.parentActionGroupSignatureAsString(), other.parentActionGroupSignatureAsString()) && Objects.equals(this.actionGroupExecutor(), other.actionGroupExecutor()) && Objects.equals(this.apiSchema(), other.apiSchema()) && Objects.equals(this.actionGroupStateAsString(), other.actionGroupStateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAgentActionGroupRequest").add("AgentId", (Object)this.agentId()).add("AgentVersion", (Object)this.agentVersion()).add("ActionGroupName", (Object)this.actionGroupName()).add("ClientToken", (Object)this.clientToken()).add("Description", (Object)this.description()).add("ParentActionGroupSignature", (Object)this.parentActionGroupSignatureAsString()).add("ActionGroupExecutor", (Object)this.actionGroupExecutor()).add("ApiSchema", (Object)this.apiSchema()).add("ActionGroupState", (Object)this.actionGroupStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "agentId": {
                return Optional.ofNullable(clazz.cast(this.agentId()));
            }
            case "agentVersion": {
                return Optional.ofNullable(clazz.cast(this.agentVersion()));
            }
            case "actionGroupName": {
                return Optional.ofNullable(clazz.cast(this.actionGroupName()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "parentActionGroupSignature": {
                return Optional.ofNullable(clazz.cast(this.parentActionGroupSignatureAsString()));
            }
            case "actionGroupExecutor": {
                return Optional.ofNullable(clazz.cast(this.actionGroupExecutor()));
            }
            case "apiSchema": {
                return Optional.ofNullable(clazz.cast(this.apiSchema()));
            }
            case "actionGroupState": {
                return Optional.ofNullable(clazz.cast(this.actionGroupStateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAgentActionGroupRequest, T> g) {
        return obj -> g.apply((CreateAgentActionGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentRequest.BuilderImpl
    implements Builder {
        private String agentId;
        private String agentVersion;
        private String actionGroupName;
        private String clientToken;
        private String description;
        private String parentActionGroupSignature;
        private ActionGroupExecutor actionGroupExecutor;
        private APISchema apiSchema;
        private String actionGroupState;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAgentActionGroupRequest model) {
            super(model);
            this.agentId(model.agentId);
            this.agentVersion(model.agentVersion);
            this.actionGroupName(model.actionGroupName);
            this.clientToken(model.clientToken);
            this.description(model.description);
            this.parentActionGroupSignature(model.parentActionGroupSignature);
            this.actionGroupExecutor(model.actionGroupExecutor);
            this.apiSchema(model.apiSchema);
            this.actionGroupState(model.actionGroupState);
        }

        public final String getAgentId() {
            return this.agentId;
        }

        public final void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        @Override
        public final Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public final String getAgentVersion() {
            return this.agentVersion;
        }

        public final void setAgentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
        }

        @Override
        public final Builder agentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            return this;
        }

        public final String getActionGroupName() {
            return this.actionGroupName;
        }

        public final void setActionGroupName(String actionGroupName) {
            this.actionGroupName = actionGroupName;
        }

        @Override
        public final Builder actionGroupName(String actionGroupName) {
            this.actionGroupName = actionGroupName;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getParentActionGroupSignature() {
            return this.parentActionGroupSignature;
        }

        public final void setParentActionGroupSignature(String parentActionGroupSignature) {
            this.parentActionGroupSignature = parentActionGroupSignature;
        }

        @Override
        public final Builder parentActionGroupSignature(String parentActionGroupSignature) {
            this.parentActionGroupSignature = parentActionGroupSignature;
            return this;
        }

        @Override
        public final Builder parentActionGroupSignature(ActionGroupSignature parentActionGroupSignature) {
            this.parentActionGroupSignature(parentActionGroupSignature == null ? null : parentActionGroupSignature.toString());
            return this;
        }

        public final ActionGroupExecutor.Builder getActionGroupExecutor() {
            return this.actionGroupExecutor != null ? this.actionGroupExecutor.toBuilder() : null;
        }

        public final void setActionGroupExecutor(ActionGroupExecutor.BuilderImpl actionGroupExecutor) {
            this.actionGroupExecutor = actionGroupExecutor != null ? actionGroupExecutor.build() : null;
        }

        @Override
        public final Builder actionGroupExecutor(ActionGroupExecutor actionGroupExecutor) {
            this.actionGroupExecutor = actionGroupExecutor;
            return this;
        }

        public final APISchema.Builder getApiSchema() {
            return this.apiSchema != null ? this.apiSchema.toBuilder() : null;
        }

        public final void setApiSchema(APISchema.BuilderImpl apiSchema) {
            this.apiSchema = apiSchema != null ? apiSchema.build() : null;
        }

        @Override
        public final Builder apiSchema(APISchema apiSchema) {
            this.apiSchema = apiSchema;
            return this;
        }

        public final String getActionGroupState() {
            return this.actionGroupState;
        }

        public final void setActionGroupState(String actionGroupState) {
            this.actionGroupState = actionGroupState;
        }

        @Override
        public final Builder actionGroupState(String actionGroupState) {
            this.actionGroupState = actionGroupState;
            return this;
        }

        @Override
        public final Builder actionGroupState(ActionGroupState actionGroupState) {
            this.actionGroupState(actionGroupState == null ? null : actionGroupState.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAgentActionGroupRequest build() {
            return new CreateAgentActionGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BedrockAgentRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAgentActionGroupRequest> {
        public Builder agentId(String var1);

        public Builder agentVersion(String var1);

        public Builder actionGroupName(String var1);

        public Builder clientToken(String var1);

        public Builder description(String var1);

        public Builder parentActionGroupSignature(String var1);

        public Builder parentActionGroupSignature(ActionGroupSignature var1);

        public Builder actionGroupExecutor(ActionGroupExecutor var1);

        default public Builder actionGroupExecutor(Consumer<ActionGroupExecutor.Builder> actionGroupExecutor) {
            return this.actionGroupExecutor((ActionGroupExecutor)((ActionGroupExecutor.Builder)ActionGroupExecutor.builder().applyMutation(actionGroupExecutor)).build());
        }

        public Builder apiSchema(APISchema var1);

        default public Builder apiSchema(Consumer<APISchema.Builder> apiSchema) {
            return this.apiSchema((APISchema)((APISchema.Builder)APISchema.builder().applyMutation(apiSchema)).build());
        }

        public Builder actionGroupState(String var1);

        public Builder actionGroupState(ActionGroupState var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

