/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagent.model.IngestionJobStatistics;
import software.amazon.awssdk.services.bedrockagent.model.IngestionJobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IngestionJobSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IngestionJobSummary> {
    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataSourceId").getter(IngestionJobSummary.getter(IngestionJobSummary::dataSourceId)).setter(IngestionJobSummary.setter(Builder::dataSourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(IngestionJobSummary.getter(IngestionJobSummary::description)).setter(IngestionJobSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> INGESTION_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ingestionJobId").getter(IngestionJobSummary.getter(IngestionJobSummary::ingestionJobId)).setter(IngestionJobSummary.setter(Builder::ingestionJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingestionJobId").build()}).build();
    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("knowledgeBaseId").getter(IngestionJobSummary.getter(IngestionJobSummary::knowledgeBaseId)).setter(IngestionJobSummary.setter(Builder::knowledgeBaseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseId").build()}).build();
    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startedAt").getter(IngestionJobSummary.getter(IngestionJobSummary::startedAt)).setter(IngestionJobSummary.setter(Builder::startedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<IngestionJobStatistics> STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("statistics").getter(IngestionJobSummary.getter(IngestionJobSummary::statistics)).setter(IngestionJobSummary.setter(Builder::statistics)).constructor(IngestionJobStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statistics").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(IngestionJobSummary.getter(IngestionJobSummary::statusAsString)).setter(IngestionJobSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(IngestionJobSummary.getter(IngestionJobSummary::updatedAt)).setter(IngestionJobSummary.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_ID_FIELD, DESCRIPTION_FIELD, INGESTION_JOB_ID_FIELD, KNOWLEDGE_BASE_ID_FIELD, STARTED_AT_FIELD, STATISTICS_FIELD, STATUS_FIELD, UPDATED_AT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String dataSourceId;
    private final String description;
    private final String ingestionJobId;
    private final String knowledgeBaseId;
    private final Instant startedAt;
    private final IngestionJobStatistics statistics;
    private final String status;
    private final Instant updatedAt;

    private IngestionJobSummary(BuilderImpl builder) {
        this.dataSourceId = builder.dataSourceId;
        this.description = builder.description;
        this.ingestionJobId = builder.ingestionJobId;
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.startedAt = builder.startedAt;
        this.statistics = builder.statistics;
        this.status = builder.status;
        this.updatedAt = builder.updatedAt;
    }

    public final String dataSourceId() {
        return this.dataSourceId;
    }

    public final String description() {
        return this.description;
    }

    public final String ingestionJobId() {
        return this.ingestionJobId;
    }

    public final String knowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public final Instant startedAt() {
        return this.startedAt;
    }

    public final IngestionJobStatistics statistics() {
        return this.statistics;
    }

    public final IngestionJobStatus status() {
        return IngestionJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingestionJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.statistics());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IngestionJobSummary)) {
            return false;
        }
        IngestionJobSummary other = (IngestionJobSummary)obj;
        return Objects.equals(this.dataSourceId(), other.dataSourceId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.ingestionJobId(), other.ingestionJobId()) && Objects.equals(this.knowledgeBaseId(), other.knowledgeBaseId()) && Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.statistics(), other.statistics()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"IngestionJobSummary").add("DataSourceId", (Object)this.dataSourceId()).add("Description", (Object)this.description()).add("IngestionJobId", (Object)this.ingestionJobId()).add("KnowledgeBaseId", (Object)this.knowledgeBaseId()).add("StartedAt", (Object)this.startedAt()).add("Statistics", (Object)this.statistics()).add("Status", (Object)this.statusAsString()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dataSourceId": {
                return Optional.ofNullable(clazz.cast(this.dataSourceId()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ingestionJobId": {
                return Optional.ofNullable(clazz.cast(this.ingestionJobId()));
            }
            case "knowledgeBaseId": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseId()));
            }
            case "startedAt": {
                return Optional.ofNullable(clazz.cast(this.startedAt()));
            }
            case "statistics": {
                return Optional.ofNullable(clazz.cast(this.statistics()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IngestionJobSummary, T> g) {
        return obj -> g.apply((IngestionJobSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dataSourceId;
        private String description;
        private String ingestionJobId;
        private String knowledgeBaseId;
        private Instant startedAt;
        private IngestionJobStatistics statistics;
        private String status;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(IngestionJobSummary model) {
            this.dataSourceId(model.dataSourceId);
            this.description(model.description);
            this.ingestionJobId(model.ingestionJobId);
            this.knowledgeBaseId(model.knowledgeBaseId);
            this.startedAt(model.startedAt);
            this.statistics(model.statistics);
            this.status(model.status);
            this.updatedAt(model.updatedAt);
        }

        public final String getDataSourceId() {
            return this.dataSourceId;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getIngestionJobId() {
            return this.ingestionJobId;
        }

        public final void setIngestionJobId(String ingestionJobId) {
            this.ingestionJobId = ingestionJobId;
        }

        @Override
        public final Builder ingestionJobId(String ingestionJobId) {
            this.ingestionJobId = ingestionJobId;
            return this;
        }

        public final String getKnowledgeBaseId() {
            return this.knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final Instant getStartedAt() {
            return this.startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final IngestionJobStatistics.Builder getStatistics() {
            return this.statistics != null ? this.statistics.toBuilder() : null;
        }

        public final void setStatistics(IngestionJobStatistics.BuilderImpl statistics) {
            this.statistics = statistics != null ? statistics.build() : null;
        }

        @Override
        public final Builder statistics(IngestionJobStatistics statistics) {
            this.statistics = statistics;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(IngestionJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public IngestionJobSummary build() {
            return new IngestionJobSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IngestionJobSummary> {
        public Builder dataSourceId(String var1);

        public Builder description(String var1);

        public Builder ingestionJobId(String var1);

        public Builder knowledgeBaseId(String var1);

        public Builder startedAt(Instant var1);

        public Builder statistics(IngestionJobStatistics var1);

        default public Builder statistics(Consumer<IngestionJobStatistics.Builder> statistics) {
            return this.statistics((IngestionJobStatistics)((IngestionJobStatistics.Builder)IngestionJobStatistics.builder().applyMutation(statistics)).build());
        }

        public Builder status(String var1);

        public Builder status(IngestionJobStatus var1);

        public Builder updatedAt(Instant var1);
    }
}

