/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateKnowledgeBaseRequest extends BedrockAgentRequest implements
        ToCopyableBuilder<UpdateKnowledgeBaseRequest.Builder, UpdateKnowledgeBaseRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateKnowledgeBaseRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<KnowledgeBaseConfiguration> KNOWLEDGE_BASE_CONFIGURATION_FIELD = SdkField
            .<KnowledgeBaseConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("knowledgeBaseConfiguration")
            .getter(getter(UpdateKnowledgeBaseRequest::knowledgeBaseConfiguration))
            .setter(setter(Builder::knowledgeBaseConfiguration))
            .constructor(KnowledgeBaseConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseConfiguration").build())
            .build();

    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("knowledgeBaseId").getter(getter(UpdateKnowledgeBaseRequest::knowledgeBaseId))
            .setter(setter(Builder::knowledgeBaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("knowledgeBaseId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateKnowledgeBaseRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(UpdateKnowledgeBaseRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<StorageConfiguration> STORAGE_CONFIGURATION_FIELD = SdkField
            .<StorageConfiguration> builder(MarshallingType.SDK_POJO).memberName("storageConfiguration")
            .getter(getter(UpdateKnowledgeBaseRequest::storageConfiguration)).setter(setter(Builder::storageConfiguration))
            .constructor(StorageConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, KNOWLEDGE_BASE_CONFIGURATION_FIELD, KNOWLEDGE_BASE_ID_FIELD,
                    NAME_FIELD, ROLE_ARN_FIELD, STORAGE_CONFIGURATION_FIELD));

    private final String description;

    private final KnowledgeBaseConfiguration knowledgeBaseConfiguration;

    private final String knowledgeBaseId;

    private final String name;

    private final String roleArn;

    private final StorageConfiguration storageConfiguration;

    private UpdateKnowledgeBaseRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.knowledgeBaseConfiguration = builder.knowledgeBaseConfiguration;
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.name = builder.name;
        this.roleArn = builder.roleArn;
        this.storageConfiguration = builder.storageConfiguration;
    }

    /**
     * <p>
     * Specifies a new description for the knowledge base.
     * </p>
     * 
     * @return Specifies a new description for the knowledge base.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Specifies the configuration for the embeddings model used for the knowledge base. You must use the same
     * configuration as when the knowledge base was created.
     * </p>
     * 
     * @return Specifies the configuration for the embeddings model used for the knowledge base. You must use the same
     *         configuration as when the knowledge base was created.
     */
    public final KnowledgeBaseConfiguration knowledgeBaseConfiguration() {
        return knowledgeBaseConfiguration;
    }

    /**
     * <p>
     * The unique identifier of the knowledge base to update.
     * </p>
     * 
     * @return The unique identifier of the knowledge base to update.
     */
    public final String knowledgeBaseId() {
        return knowledgeBaseId;
    }

    /**
     * <p>
     * Specifies a new name for the knowledge base.
     * </p>
     * 
     * @return Specifies a new name for the knowledge base.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Specifies a different Amazon Resource Name (ARN) of the IAM role with permissions to invoke API operations on the
     * knowledge base.
     * </p>
     * 
     * @return Specifies a different Amazon Resource Name (ARN) of the IAM role with permissions to invoke API
     *         operations on the knowledge base.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * Specifies the configuration for the vector store used for the knowledge base. You must use the same configuration
     * as when the knowledge base was created.
     * </p>
     * 
     * @return Specifies the configuration for the vector store used for the knowledge base. You must use the same
     *         configuration as when the knowledge base was created.
     */
    public final StorageConfiguration storageConfiguration() {
        return storageConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(storageConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateKnowledgeBaseRequest)) {
            return false;
        }
        UpdateKnowledgeBaseRequest other = (UpdateKnowledgeBaseRequest) obj;
        return Objects.equals(description(), other.description())
                && Objects.equals(knowledgeBaseConfiguration(), other.knowledgeBaseConfiguration())
                && Objects.equals(knowledgeBaseId(), other.knowledgeBaseId()) && Objects.equals(name(), other.name())
                && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(storageConfiguration(), other.storageConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateKnowledgeBaseRequest").add("Description", description())
                .add("KnowledgeBaseConfiguration", knowledgeBaseConfiguration()).add("KnowledgeBaseId", knowledgeBaseId())
                .add("Name", name()).add("RoleArn", roleArn()).add("StorageConfiguration", storageConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "knowledgeBaseConfiguration":
            return Optional.ofNullable(clazz.cast(knowledgeBaseConfiguration()));
        case "knowledgeBaseId":
            return Optional.ofNullable(clazz.cast(knowledgeBaseId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "storageConfiguration":
            return Optional.ofNullable(clazz.cast(storageConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateKnowledgeBaseRequest, T> g) {
        return obj -> g.apply((UpdateKnowledgeBaseRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockAgentRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateKnowledgeBaseRequest> {
        /**
         * <p>
         * Specifies a new description for the knowledge base.
         * </p>
         * 
         * @param description
         *        Specifies a new description for the knowledge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Specifies the configuration for the embeddings model used for the knowledge base. You must use the same
         * configuration as when the knowledge base was created.
         * </p>
         * 
         * @param knowledgeBaseConfiguration
         *        Specifies the configuration for the embeddings model used for the knowledge base. You must use the
         *        same configuration as when the knowledge base was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseConfiguration(KnowledgeBaseConfiguration knowledgeBaseConfiguration);

        /**
         * <p>
         * Specifies the configuration for the embeddings model used for the knowledge base. You must use the same
         * configuration as when the knowledge base was created.
         * </p>
         * This is a convenience method that creates an instance of the {@link KnowledgeBaseConfiguration.Builder}
         * avoiding the need to create one manually via {@link KnowledgeBaseConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KnowledgeBaseConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #knowledgeBaseConfiguration(KnowledgeBaseConfiguration)}.
         * 
         * @param knowledgeBaseConfiguration
         *        a consumer that will call methods on {@link KnowledgeBaseConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #knowledgeBaseConfiguration(KnowledgeBaseConfiguration)
         */
        default Builder knowledgeBaseConfiguration(Consumer<KnowledgeBaseConfiguration.Builder> knowledgeBaseConfiguration) {
            return knowledgeBaseConfiguration(KnowledgeBaseConfiguration.builder().applyMutation(knowledgeBaseConfiguration)
                    .build());
        }

        /**
         * <p>
         * The unique identifier of the knowledge base to update.
         * </p>
         * 
         * @param knowledgeBaseId
         *        The unique identifier of the knowledge base to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseId(String knowledgeBaseId);

        /**
         * <p>
         * Specifies a new name for the knowledge base.
         * </p>
         * 
         * @param name
         *        Specifies a new name for the knowledge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Specifies a different Amazon Resource Name (ARN) of the IAM role with permissions to invoke API operations on
         * the knowledge base.
         * </p>
         * 
         * @param roleArn
         *        Specifies a different Amazon Resource Name (ARN) of the IAM role with permissions to invoke API
         *        operations on the knowledge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * Specifies the configuration for the vector store used for the knowledge base. You must use the same
         * configuration as when the knowledge base was created.
         * </p>
         * 
         * @param storageConfiguration
         *        Specifies the configuration for the vector store used for the knowledge base. You must use the same
         *        configuration as when the knowledge base was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageConfiguration(StorageConfiguration storageConfiguration);

        /**
         * <p>
         * Specifies the configuration for the vector store used for the knowledge base. You must use the same
         * configuration as when the knowledge base was created.
         * </p>
         * This is a convenience method that creates an instance of the {@link StorageConfiguration.Builder} avoiding
         * the need to create one manually via {@link StorageConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StorageConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #storageConfiguration(StorageConfiguration)}.
         * 
         * @param storageConfiguration
         *        a consumer that will call methods on {@link StorageConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storageConfiguration(StorageConfiguration)
         */
        default Builder storageConfiguration(Consumer<StorageConfiguration.Builder> storageConfiguration) {
            return storageConfiguration(StorageConfiguration.builder().applyMutation(storageConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockAgentRequest.BuilderImpl implements Builder {
        private String description;

        private KnowledgeBaseConfiguration knowledgeBaseConfiguration;

        private String knowledgeBaseId;

        private String name;

        private String roleArn;

        private StorageConfiguration storageConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateKnowledgeBaseRequest model) {
            super(model);
            description(model.description);
            knowledgeBaseConfiguration(model.knowledgeBaseConfiguration);
            knowledgeBaseId(model.knowledgeBaseId);
            name(model.name);
            roleArn(model.roleArn);
            storageConfiguration(model.storageConfiguration);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final KnowledgeBaseConfiguration.Builder getKnowledgeBaseConfiguration() {
            return knowledgeBaseConfiguration != null ? knowledgeBaseConfiguration.toBuilder() : null;
        }

        public final void setKnowledgeBaseConfiguration(KnowledgeBaseConfiguration.BuilderImpl knowledgeBaseConfiguration) {
            this.knowledgeBaseConfiguration = knowledgeBaseConfiguration != null ? knowledgeBaseConfiguration.build() : null;
        }

        @Override
        public final Builder knowledgeBaseConfiguration(KnowledgeBaseConfiguration knowledgeBaseConfiguration) {
            this.knowledgeBaseConfiguration = knowledgeBaseConfiguration;
            return this;
        }

        public final String getKnowledgeBaseId() {
            return knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final StorageConfiguration.Builder getStorageConfiguration() {
            return storageConfiguration != null ? storageConfiguration.toBuilder() : null;
        }

        public final void setStorageConfiguration(StorageConfiguration.BuilderImpl storageConfiguration) {
            this.storageConfiguration = storageConfiguration != null ? storageConfiguration.build() : null;
        }

        @Override
        public final Builder storageConfiguration(StorageConfiguration storageConfiguration) {
            this.storageConfiguration = storageConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateKnowledgeBaseRequest build() {
            return new UpdateKnowledgeBaseRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
