/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about the storage configuration of the knowledge base in Amazon RDS. For more information, see <a
 * href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-rds.html">Create a vector index in
 * Amazon RDS</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RdsConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<RdsConfiguration.Builder, RdsConfiguration> {
    private static final SdkField<String> CREDENTIALS_SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("credentialsSecretArn").getter(getter(RdsConfiguration::credentialsSecretArn))
            .setter(setter(Builder::credentialsSecretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialsSecretArn").build())
            .build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("databaseName").getter(getter(RdsConfiguration::databaseName)).setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databaseName").build()).build();

    private static final SdkField<RdsFieldMapping> FIELD_MAPPING_FIELD = SdkField
            .<RdsFieldMapping> builder(MarshallingType.SDK_POJO).memberName("fieldMapping")
            .getter(getter(RdsConfiguration::fieldMapping)).setter(setter(Builder::fieldMapping))
            .constructor(RdsFieldMapping::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldMapping").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceArn").getter(getter(RdsConfiguration::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tableName").getter(getter(RdsConfiguration::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREDENTIALS_SECRET_ARN_FIELD,
            DATABASE_NAME_FIELD, FIELD_MAPPING_FIELD, RESOURCE_ARN_FIELD, TABLE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String credentialsSecretArn;

    private final String databaseName;

    private final RdsFieldMapping fieldMapping;

    private final String resourceArn;

    private final String tableName;

    private RdsConfiguration(BuilderImpl builder) {
        this.credentialsSecretArn = builder.credentialsSecretArn;
        this.databaseName = builder.databaseName;
        this.fieldMapping = builder.fieldMapping;
        this.resourceArn = builder.resourceArn;
        this.tableName = builder.tableName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the secret that you created in Secrets Manager that is linked to your Amazon
     * RDS database.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the secret that you created in Secrets Manager that is linked to your
     *         Amazon RDS database.
     */
    public final String credentialsSecretArn() {
        return credentialsSecretArn;
    }

    /**
     * <p>
     * The name of your Amazon RDS database.
     * </p>
     * 
     * @return The name of your Amazon RDS database.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * Contains the names of the fields to which to map information about the vector store.
     * </p>
     * 
     * @return Contains the names of the fields to which to map information about the vector store.
     */
    public final RdsFieldMapping fieldMapping() {
        return fieldMapping;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the vector store.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the vector store.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The name of the table in the database.
     * </p>
     * 
     * @return The name of the table in the database.
     */
    public final String tableName() {
        return tableName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(credentialsSecretArn());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(fieldMapping());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RdsConfiguration)) {
            return false;
        }
        RdsConfiguration other = (RdsConfiguration) obj;
        return Objects.equals(credentialsSecretArn(), other.credentialsSecretArn())
                && Objects.equals(databaseName(), other.databaseName()) && Objects.equals(fieldMapping(), other.fieldMapping())
                && Objects.equals(resourceArn(), other.resourceArn()) && Objects.equals(tableName(), other.tableName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RdsConfiguration").add("CredentialsSecretArn", credentialsSecretArn())
                .add("DatabaseName", databaseName()).add("FieldMapping", fieldMapping()).add("ResourceArn", resourceArn())
                .add("TableName", tableName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "credentialsSecretArn":
            return Optional.ofNullable(clazz.cast(credentialsSecretArn()));
        case "databaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "fieldMapping":
            return Optional.ofNullable(clazz.cast(fieldMapping()));
        case "resourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "tableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RdsConfiguration, T> g) {
        return obj -> g.apply((RdsConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RdsConfiguration> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the secret that you created in Secrets Manager that is linked to your
         * Amazon RDS database.
         * </p>
         * 
         * @param credentialsSecretArn
         *        The Amazon Resource Name (ARN) of the secret that you created in Secrets Manager that is linked to
         *        your Amazon RDS database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentialsSecretArn(String credentialsSecretArn);

        /**
         * <p>
         * The name of your Amazon RDS database.
         * </p>
         * 
         * @param databaseName
         *        The name of your Amazon RDS database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * Contains the names of the fields to which to map information about the vector store.
         * </p>
         * 
         * @param fieldMapping
         *        Contains the names of the fields to which to map information about the vector store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldMapping(RdsFieldMapping fieldMapping);

        /**
         * <p>
         * Contains the names of the fields to which to map information about the vector store.
         * </p>
         * This is a convenience method that creates an instance of the {@link RdsFieldMapping.Builder} avoiding the
         * need to create one manually via {@link RdsFieldMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RdsFieldMapping.Builder#build()} is called immediately and its
         * result is passed to {@link #fieldMapping(RdsFieldMapping)}.
         * 
         * @param fieldMapping
         *        a consumer that will call methods on {@link RdsFieldMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldMapping(RdsFieldMapping)
         */
        default Builder fieldMapping(Consumer<RdsFieldMapping.Builder> fieldMapping) {
            return fieldMapping(RdsFieldMapping.builder().applyMutation(fieldMapping).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the vector store.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the vector store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The name of the table in the database.
         * </p>
         * 
         * @param tableName
         *        The name of the table in the database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);
    }

    static final class BuilderImpl implements Builder {
        private String credentialsSecretArn;

        private String databaseName;

        private RdsFieldMapping fieldMapping;

        private String resourceArn;

        private String tableName;

        private BuilderImpl() {
        }

        private BuilderImpl(RdsConfiguration model) {
            credentialsSecretArn(model.credentialsSecretArn);
            databaseName(model.databaseName);
            fieldMapping(model.fieldMapping);
            resourceArn(model.resourceArn);
            tableName(model.tableName);
        }

        public final String getCredentialsSecretArn() {
            return credentialsSecretArn;
        }

        public final void setCredentialsSecretArn(String credentialsSecretArn) {
            this.credentialsSecretArn = credentialsSecretArn;
        }

        @Override
        public final Builder credentialsSecretArn(String credentialsSecretArn) {
            this.credentialsSecretArn = credentialsSecretArn;
            return this;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final RdsFieldMapping.Builder getFieldMapping() {
            return fieldMapping != null ? fieldMapping.toBuilder() : null;
        }

        public final void setFieldMapping(RdsFieldMapping.BuilderImpl fieldMapping) {
            this.fieldMapping = fieldMapping != null ? fieldMapping.build() : null;
        }

        @Override
        public final Builder fieldMapping(RdsFieldMapping fieldMapping) {
            this.fieldMapping = fieldMapping;
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getTableName() {
            return tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        @Override
        public RdsConfiguration build() {
            return new RdsConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
