/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListIngestionJobsResponse extends BedrockAgentResponse implements
        ToCopyableBuilder<ListIngestionJobsResponse.Builder, ListIngestionJobsResponse> {
    private static final SdkField<List<IngestionJobSummary>> INGESTION_JOB_SUMMARIES_FIELD = SdkField
            .<List<IngestionJobSummary>> builder(MarshallingType.LIST)
            .memberName("ingestionJobSummaries")
            .getter(getter(ListIngestionJobsResponse::ingestionJobSummaries))
            .setter(setter(Builder::ingestionJobSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingestionJobSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IngestionJobSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(IngestionJobSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListIngestionJobsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INGESTION_JOB_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<IngestionJobSummary> ingestionJobSummaries;

    private final String nextToken;

    private ListIngestionJobsResponse(BuilderImpl builder) {
        super(builder);
        this.ingestionJobSummaries = builder.ingestionJobSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the IngestionJobSummaries property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasIngestionJobSummaries() {
        return ingestionJobSummaries != null && !(ingestionJobSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of objects, each of which contains information about an ingestion job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIngestionJobSummaries} method.
     * </p>
     * 
     * @return A list of objects, each of which contains information about an ingestion job.
     */
    public final List<IngestionJobSummary> ingestionJobSummaries() {
        return ingestionJobSummaries;
    }

    /**
     * <p>
     * If the total number of results is greater than the <code>maxResults</code> value provided in the request, use
     * this token when making another request in the <code>nextToken</code> field to return the next batch of results.
     * </p>
     * 
     * @return If the total number of results is greater than the <code>maxResults</code> value provided in the request,
     *         use this token when making another request in the <code>nextToken</code> field to return the next batch
     *         of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasIngestionJobSummaries() ? ingestionJobSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIngestionJobsResponse)) {
            return false;
        }
        ListIngestionJobsResponse other = (ListIngestionJobsResponse) obj;
        return hasIngestionJobSummaries() == other.hasIngestionJobSummaries()
                && Objects.equals(ingestionJobSummaries(), other.ingestionJobSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListIngestionJobsResponse")
                .add("IngestionJobSummaries", hasIngestionJobSummaries() ? ingestionJobSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ingestionJobSummaries":
            return Optional.ofNullable(clazz.cast(ingestionJobSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListIngestionJobsResponse, T> g) {
        return obj -> g.apply((ListIngestionJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockAgentResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListIngestionJobsResponse> {
        /**
         * <p>
         * A list of objects, each of which contains information about an ingestion job.
         * </p>
         * 
         * @param ingestionJobSummaries
         *        A list of objects, each of which contains information about an ingestion job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingestionJobSummaries(Collection<IngestionJobSummary> ingestionJobSummaries);

        /**
         * <p>
         * A list of objects, each of which contains information about an ingestion job.
         * </p>
         * 
         * @param ingestionJobSummaries
         *        A list of objects, each of which contains information about an ingestion job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingestionJobSummaries(IngestionJobSummary... ingestionJobSummaries);

        /**
         * <p>
         * A list of objects, each of which contains information about an ingestion job.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagent.model.IngestionJobSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.bedrockagent.model.IngestionJobSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagent.model.IngestionJobSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #ingestionJobSummaries(List<IngestionJobSummary>)}.
         * 
         * @param ingestionJobSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagent.model.IngestionJobSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ingestionJobSummaries(java.util.Collection<IngestionJobSummary>)
         */
        Builder ingestionJobSummaries(Consumer<IngestionJobSummary.Builder>... ingestionJobSummaries);

        /**
         * <p>
         * If the total number of results is greater than the <code>maxResults</code> value provided in the request, use
         * this token when making another request in the <code>nextToken</code> field to return the next batch of
         * results.
         * </p>
         * 
         * @param nextToken
         *        If the total number of results is greater than the <code>maxResults</code> value provided in the
         *        request, use this token when making another request in the <code>nextToken</code> field to return the
         *        next batch of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends BedrockAgentResponse.BuilderImpl implements Builder {
        private List<IngestionJobSummary> ingestionJobSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIngestionJobsResponse model) {
            super(model);
            ingestionJobSummaries(model.ingestionJobSummaries);
            nextToken(model.nextToken);
        }

        public final List<IngestionJobSummary.Builder> getIngestionJobSummaries() {
            List<IngestionJobSummary.Builder> result = IngestionJobSummariesCopier.copyToBuilder(this.ingestionJobSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIngestionJobSummaries(Collection<IngestionJobSummary.BuilderImpl> ingestionJobSummaries) {
            this.ingestionJobSummaries = IngestionJobSummariesCopier.copyFromBuilder(ingestionJobSummaries);
        }

        @Override
        public final Builder ingestionJobSummaries(Collection<IngestionJobSummary> ingestionJobSummaries) {
            this.ingestionJobSummaries = IngestionJobSummariesCopier.copy(ingestionJobSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ingestionJobSummaries(IngestionJobSummary... ingestionJobSummaries) {
            ingestionJobSummaries(Arrays.asList(ingestionJobSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ingestionJobSummaries(Consumer<IngestionJobSummary.Builder>... ingestionJobSummaries) {
            ingestionJobSummaries(Stream.of(ingestionJobSummaries)
                    .map(c -> IngestionJobSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListIngestionJobsResponse build() {
            return new ListIngestionJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
