/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about an alias of an agent.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AgentAlias implements SdkPojo, Serializable, ToCopyableBuilder<AgentAlias.Builder, AgentAlias> {
    private static final SdkField<String> AGENT_ALIAS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentAliasArn").getter(getter(AgentAlias::agentAliasArn)).setter(setter(Builder::agentAliasArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentAliasArn").build()).build();

    private static final SdkField<List<AgentAliasHistoryEvent>> AGENT_ALIAS_HISTORY_EVENTS_FIELD = SdkField
            .<List<AgentAliasHistoryEvent>> builder(MarshallingType.LIST)
            .memberName("agentAliasHistoryEvents")
            .getter(getter(AgentAlias::agentAliasHistoryEvents))
            .setter(setter(Builder::agentAliasHistoryEvents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentAliasHistoryEvents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AgentAliasHistoryEvent> builder(MarshallingType.SDK_POJO)
                                            .constructor(AgentAliasHistoryEvent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> AGENT_ALIAS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentAliasId").getter(getter(AgentAlias::agentAliasId)).setter(setter(Builder::agentAliasId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentAliasId").build()).build();

    private static final SdkField<String> AGENT_ALIAS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentAliasName").getter(getter(AgentAlias::agentAliasName)).setter(setter(Builder::agentAliasName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentAliasName").build()).build();

    private static final SdkField<String> AGENT_ALIAS_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentAliasStatus").getter(getter(AgentAlias::agentAliasStatusAsString))
            .setter(setter(Builder::agentAliasStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentAliasStatus").build()).build();

    private static final SdkField<String> AGENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentId").getter(getter(AgentAlias::agentId)).setter(setter(Builder::agentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentId").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientToken").getter(getter(AgentAlias::clientToken)).setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(AgentAlias::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(AgentAlias::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<AgentAliasRoutingConfigurationListItem>> ROUTING_CONFIGURATION_FIELD = SdkField
            .<List<AgentAliasRoutingConfigurationListItem>> builder(MarshallingType.LIST)
            .memberName("routingConfiguration")
            .getter(getter(AgentAlias::routingConfiguration))
            .setter(setter(Builder::routingConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routingConfiguration").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AgentAliasRoutingConfigurationListItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(AgentAliasRoutingConfigurationListItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(AgentAlias::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_ALIAS_ARN_FIELD,
            AGENT_ALIAS_HISTORY_EVENTS_FIELD, AGENT_ALIAS_ID_FIELD, AGENT_ALIAS_NAME_FIELD, AGENT_ALIAS_STATUS_FIELD,
            AGENT_ID_FIELD, CLIENT_TOKEN_FIELD, CREATED_AT_FIELD, DESCRIPTION_FIELD, ROUTING_CONFIGURATION_FIELD,
            UPDATED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String agentAliasArn;

    private final List<AgentAliasHistoryEvent> agentAliasHistoryEvents;

    private final String agentAliasId;

    private final String agentAliasName;

    private final String agentAliasStatus;

    private final String agentId;

    private final String clientToken;

    private final Instant createdAt;

    private final String description;

    private final List<AgentAliasRoutingConfigurationListItem> routingConfiguration;

    private final Instant updatedAt;

    private AgentAlias(BuilderImpl builder) {
        this.agentAliasArn = builder.agentAliasArn;
        this.agentAliasHistoryEvents = builder.agentAliasHistoryEvents;
        this.agentAliasId = builder.agentAliasId;
        this.agentAliasName = builder.agentAliasName;
        this.agentAliasStatus = builder.agentAliasStatus;
        this.agentId = builder.agentId;
        this.clientToken = builder.clientToken;
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.routingConfiguration = builder.routingConfiguration;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the alias of the agent.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the alias of the agent.
     */
    public final String agentAliasArn() {
        return agentAliasArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the AgentAliasHistoryEvents property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAgentAliasHistoryEvents() {
        return agentAliasHistoryEvents != null && !(agentAliasHistoryEvents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains details about the history of the alias.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAgentAliasHistoryEvents} method.
     * </p>
     * 
     * @return Contains details about the history of the alias.
     */
    public final List<AgentAliasHistoryEvent> agentAliasHistoryEvents() {
        return agentAliasHistoryEvents;
    }

    /**
     * <p>
     * The unique identifier of the alias of the agent.
     * </p>
     * 
     * @return The unique identifier of the alias of the agent.
     */
    public final String agentAliasId() {
        return agentAliasId;
    }

    /**
     * <p>
     * The name of the alias of the agent.
     * </p>
     * 
     * @return The name of the alias of the agent.
     */
    public final String agentAliasName() {
        return agentAliasName;
    }

    /**
     * <p>
     * The status of the alias of the agent and whether it is ready for use. The following statuses are possible:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CREATING – The agent alias is being created.
     * </p>
     * </li>
     * <li>
     * <p>
     * PREPARED – The agent alias is finished being created or updated and is ready to be invoked.
     * </p>
     * </li>
     * <li>
     * <p>
     * FAILED – The agent alias API operation failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * UPDATING – The agent alias is being updated.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETING – The agent alias is being deleted.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #agentAliasStatus}
     * will return {@link AgentAliasStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #agentAliasStatusAsString}.
     * </p>
     * 
     * @return The status of the alias of the agent and whether it is ready for use. The following statuses are
     *         possible:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         CREATING – The agent alias is being created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PREPARED – The agent alias is finished being created or updated and is ready to be invoked.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FAILED – The agent alias API operation failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UPDATING – The agent alias is being updated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETING – The agent alias is being deleted.
     *         </p>
     *         </li>
     * @see AgentAliasStatus
     */
    public final AgentAliasStatus agentAliasStatus() {
        return AgentAliasStatus.fromValue(agentAliasStatus);
    }

    /**
     * <p>
     * The status of the alias of the agent and whether it is ready for use. The following statuses are possible:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CREATING – The agent alias is being created.
     * </p>
     * </li>
     * <li>
     * <p>
     * PREPARED – The agent alias is finished being created or updated and is ready to be invoked.
     * </p>
     * </li>
     * <li>
     * <p>
     * FAILED – The agent alias API operation failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * UPDATING – The agent alias is being updated.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETING – The agent alias is being deleted.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #agentAliasStatus}
     * will return {@link AgentAliasStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #agentAliasStatusAsString}.
     * </p>
     * 
     * @return The status of the alias of the agent and whether it is ready for use. The following statuses are
     *         possible:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         CREATING – The agent alias is being created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PREPARED – The agent alias is finished being created or updated and is ready to be invoked.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FAILED – The agent alias API operation failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UPDATING – The agent alias is being updated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETING – The agent alias is being deleted.
     *         </p>
     *         </li>
     * @see AgentAliasStatus
     */
    public final String agentAliasStatusAsString() {
        return agentAliasStatus;
    }

    /**
     * <p>
     * The unique identifier of the agent.
     * </p>
     * 
     * @return The unique identifier of the agent.
     */
    public final String agentId() {
        return agentId;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If this token
     * matches a previous request, Amazon Bedrock ignores the request, but does not return an error. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * idempotency</a>.
     * </p>
     * 
     * @return A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If
     *         this token matches a previous request, Amazon Bedrock ignores the request, but does not return an error.
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *         idempotency</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The time at which the alias of the agent was created.
     * </p>
     * 
     * @return The time at which the alias of the agent was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The description of the alias of the agent.
     * </p>
     * 
     * @return The description of the alias of the agent.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the RoutingConfiguration property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRoutingConfiguration() {
        return routingConfiguration != null && !(routingConfiguration instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains details about the routing configuration of the alias.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRoutingConfiguration} method.
     * </p>
     * 
     * @return Contains details about the routing configuration of the alias.
     */
    public final List<AgentAliasRoutingConfigurationListItem> routingConfiguration() {
        return routingConfiguration;
    }

    /**
     * <p>
     * The time at which the alias was last updated.
     * </p>
     * 
     * @return The time at which the alias was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(agentAliasArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasAgentAliasHistoryEvents() ? agentAliasHistoryEvents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(agentAliasId());
        hashCode = 31 * hashCode + Objects.hashCode(agentAliasName());
        hashCode = 31 * hashCode + Objects.hashCode(agentAliasStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(agentId());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasRoutingConfiguration() ? routingConfiguration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentAlias)) {
            return false;
        }
        AgentAlias other = (AgentAlias) obj;
        return Objects.equals(agentAliasArn(), other.agentAliasArn())
                && hasAgentAliasHistoryEvents() == other.hasAgentAliasHistoryEvents()
                && Objects.equals(agentAliasHistoryEvents(), other.agentAliasHistoryEvents())
                && Objects.equals(agentAliasId(), other.agentAliasId())
                && Objects.equals(agentAliasName(), other.agentAliasName())
                && Objects.equals(agentAliasStatusAsString(), other.agentAliasStatusAsString())
                && Objects.equals(agentId(), other.agentId()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(description(), other.description())
                && hasRoutingConfiguration() == other.hasRoutingConfiguration()
                && Objects.equals(routingConfiguration(), other.routingConfiguration())
                && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AgentAlias").add("AgentAliasArn", agentAliasArn())
                .add("AgentAliasHistoryEvents", hasAgentAliasHistoryEvents() ? agentAliasHistoryEvents() : null)
                .add("AgentAliasId", agentAliasId()).add("AgentAliasName", agentAliasName())
                .add("AgentAliasStatus", agentAliasStatusAsString()).add("AgentId", agentId()).add("ClientToken", clientToken())
                .add("CreatedAt", createdAt()).add("Description", description())
                .add("RoutingConfiguration", hasRoutingConfiguration() ? routingConfiguration() : null)
                .add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentAliasArn":
            return Optional.ofNullable(clazz.cast(agentAliasArn()));
        case "agentAliasHistoryEvents":
            return Optional.ofNullable(clazz.cast(agentAliasHistoryEvents()));
        case "agentAliasId":
            return Optional.ofNullable(clazz.cast(agentAliasId()));
        case "agentAliasName":
            return Optional.ofNullable(clazz.cast(agentAliasName()));
        case "agentAliasStatus":
            return Optional.ofNullable(clazz.cast(agentAliasStatusAsString()));
        case "agentId":
            return Optional.ofNullable(clazz.cast(agentId()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "routingConfiguration":
            return Optional.ofNullable(clazz.cast(routingConfiguration()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AgentAlias, T> g) {
        return obj -> g.apply((AgentAlias) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AgentAlias> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the alias of the agent.
         * </p>
         * 
         * @param agentAliasArn
         *        The Amazon Resource Name (ARN) of the alias of the agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentAliasArn(String agentAliasArn);

        /**
         * <p>
         * Contains details about the history of the alias.
         * </p>
         * 
         * @param agentAliasHistoryEvents
         *        Contains details about the history of the alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentAliasHistoryEvents(Collection<AgentAliasHistoryEvent> agentAliasHistoryEvents);

        /**
         * <p>
         * Contains details about the history of the alias.
         * </p>
         * 
         * @param agentAliasHistoryEvents
         *        Contains details about the history of the alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentAliasHistoryEvents(AgentAliasHistoryEvent... agentAliasHistoryEvents);

        /**
         * <p>
         * Contains details about the history of the alias.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagent.model.AgentAliasHistoryEvent.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.bedrockagent.model.AgentAliasHistoryEvent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagent.model.AgentAliasHistoryEvent.Builder#build()} is called
         * immediately and its result is passed to {@link #agentAliasHistoryEvents(List<AgentAliasHistoryEvent>)}.
         * 
         * @param agentAliasHistoryEvents
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagent.model.AgentAliasHistoryEvent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #agentAliasHistoryEvents(java.util.Collection<AgentAliasHistoryEvent>)
         */
        Builder agentAliasHistoryEvents(Consumer<AgentAliasHistoryEvent.Builder>... agentAliasHistoryEvents);

        /**
         * <p>
         * The unique identifier of the alias of the agent.
         * </p>
         * 
         * @param agentAliasId
         *        The unique identifier of the alias of the agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentAliasId(String agentAliasId);

        /**
         * <p>
         * The name of the alias of the agent.
         * </p>
         * 
         * @param agentAliasName
         *        The name of the alias of the agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentAliasName(String agentAliasName);

        /**
         * <p>
         * The status of the alias of the agent and whether it is ready for use. The following statuses are possible:
         * </p>
         * <ul>
         * <li>
         * <p>
         * CREATING – The agent alias is being created.
         * </p>
         * </li>
         * <li>
         * <p>
         * PREPARED – The agent alias is finished being created or updated and is ready to be invoked.
         * </p>
         * </li>
         * <li>
         * <p>
         * FAILED – The agent alias API operation failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * UPDATING – The agent alias is being updated.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETING – The agent alias is being deleted.
         * </p>
         * </li>
         * </ul>
         * 
         * @param agentAliasStatus
         *        The status of the alias of the agent and whether it is ready for use. The following statuses are
         *        possible:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        CREATING – The agent alias is being created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PREPARED – The agent alias is finished being created or updated and is ready to be invoked.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FAILED – The agent alias API operation failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UPDATING – The agent alias is being updated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETING – The agent alias is being deleted.
         *        </p>
         *        </li>
         * @see AgentAliasStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgentAliasStatus
         */
        Builder agentAliasStatus(String agentAliasStatus);

        /**
         * <p>
         * The status of the alias of the agent and whether it is ready for use. The following statuses are possible:
         * </p>
         * <ul>
         * <li>
         * <p>
         * CREATING – The agent alias is being created.
         * </p>
         * </li>
         * <li>
         * <p>
         * PREPARED – The agent alias is finished being created or updated and is ready to be invoked.
         * </p>
         * </li>
         * <li>
         * <p>
         * FAILED – The agent alias API operation failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * UPDATING – The agent alias is being updated.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETING – The agent alias is being deleted.
         * </p>
         * </li>
         * </ul>
         * 
         * @param agentAliasStatus
         *        The status of the alias of the agent and whether it is ready for use. The following statuses are
         *        possible:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        CREATING – The agent alias is being created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PREPARED – The agent alias is finished being created or updated and is ready to be invoked.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FAILED – The agent alias API operation failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UPDATING – The agent alias is being updated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETING – The agent alias is being deleted.
         *        </p>
         *        </li>
         * @see AgentAliasStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgentAliasStatus
         */
        Builder agentAliasStatus(AgentAliasStatus agentAliasStatus);

        /**
         * <p>
         * The unique identifier of the agent.
         * </p>
         * 
         * @param agentId
         *        The unique identifier of the agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentId(String agentId);

        /**
         * <p>
         * A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If this
         * token matches a previous request, Amazon Bedrock ignores the request, but does not return an error. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If
         *        this token matches a previous request, Amazon Bedrock ignores the request, but does not return an
         *        error. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         *        idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The time at which the alias of the agent was created.
         * </p>
         * 
         * @param createdAt
         *        The time at which the alias of the agent was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The description of the alias of the agent.
         * </p>
         * 
         * @param description
         *        The description of the alias of the agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Contains details about the routing configuration of the alias.
         * </p>
         * 
         * @param routingConfiguration
         *        Contains details about the routing configuration of the alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingConfiguration(Collection<AgentAliasRoutingConfigurationListItem> routingConfiguration);

        /**
         * <p>
         * Contains details about the routing configuration of the alias.
         * </p>
         * 
         * @param routingConfiguration
         *        Contains details about the routing configuration of the alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingConfiguration(AgentAliasRoutingConfigurationListItem... routingConfiguration);

        /**
         * <p>
         * Contains details about the routing configuration of the alias.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagent.model.AgentAliasRoutingConfigurationListItem.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.bedrockagent.model.AgentAliasRoutingConfigurationListItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagent.model.AgentAliasRoutingConfigurationListItem.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #routingConfiguration(List<AgentAliasRoutingConfigurationListItem>)}.
         * 
         * @param routingConfiguration
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagent.model.AgentAliasRoutingConfigurationListItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routingConfiguration(java.util.Collection<AgentAliasRoutingConfigurationListItem>)
         */
        Builder routingConfiguration(Consumer<AgentAliasRoutingConfigurationListItem.Builder>... routingConfiguration);

        /**
         * <p>
         * The time at which the alias was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The time at which the alias was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private String agentAliasArn;

        private List<AgentAliasHistoryEvent> agentAliasHistoryEvents = DefaultSdkAutoConstructList.getInstance();

        private String agentAliasId;

        private String agentAliasName;

        private String agentAliasStatus;

        private String agentId;

        private String clientToken;

        private Instant createdAt;

        private String description;

        private List<AgentAliasRoutingConfigurationListItem> routingConfiguration = DefaultSdkAutoConstructList.getInstance();

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(AgentAlias model) {
            agentAliasArn(model.agentAliasArn);
            agentAliasHistoryEvents(model.agentAliasHistoryEvents);
            agentAliasId(model.agentAliasId);
            agentAliasName(model.agentAliasName);
            agentAliasStatus(model.agentAliasStatus);
            agentId(model.agentId);
            clientToken(model.clientToken);
            createdAt(model.createdAt);
            description(model.description);
            routingConfiguration(model.routingConfiguration);
            updatedAt(model.updatedAt);
        }

        public final String getAgentAliasArn() {
            return agentAliasArn;
        }

        public final void setAgentAliasArn(String agentAliasArn) {
            this.agentAliasArn = agentAliasArn;
        }

        @Override
        public final Builder agentAliasArn(String agentAliasArn) {
            this.agentAliasArn = agentAliasArn;
            return this;
        }

        public final List<AgentAliasHistoryEvent.Builder> getAgentAliasHistoryEvents() {
            List<AgentAliasHistoryEvent.Builder> result = AgentAliasHistoryEventsCopier
                    .copyToBuilder(this.agentAliasHistoryEvents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAgentAliasHistoryEvents(Collection<AgentAliasHistoryEvent.BuilderImpl> agentAliasHistoryEvents) {
            this.agentAliasHistoryEvents = AgentAliasHistoryEventsCopier.copyFromBuilder(agentAliasHistoryEvents);
        }

        @Override
        public final Builder agentAliasHistoryEvents(Collection<AgentAliasHistoryEvent> agentAliasHistoryEvents) {
            this.agentAliasHistoryEvents = AgentAliasHistoryEventsCopier.copy(agentAliasHistoryEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentAliasHistoryEvents(AgentAliasHistoryEvent... agentAliasHistoryEvents) {
            agentAliasHistoryEvents(Arrays.asList(agentAliasHistoryEvents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentAliasHistoryEvents(Consumer<AgentAliasHistoryEvent.Builder>... agentAliasHistoryEvents) {
            agentAliasHistoryEvents(Stream.of(agentAliasHistoryEvents)
                    .map(c -> AgentAliasHistoryEvent.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getAgentAliasId() {
            return agentAliasId;
        }

        public final void setAgentAliasId(String agentAliasId) {
            this.agentAliasId = agentAliasId;
        }

        @Override
        public final Builder agentAliasId(String agentAliasId) {
            this.agentAliasId = agentAliasId;
            return this;
        }

        public final String getAgentAliasName() {
            return agentAliasName;
        }

        public final void setAgentAliasName(String agentAliasName) {
            this.agentAliasName = agentAliasName;
        }

        @Override
        public final Builder agentAliasName(String agentAliasName) {
            this.agentAliasName = agentAliasName;
            return this;
        }

        public final String getAgentAliasStatus() {
            return agentAliasStatus;
        }

        public final void setAgentAliasStatus(String agentAliasStatus) {
            this.agentAliasStatus = agentAliasStatus;
        }

        @Override
        public final Builder agentAliasStatus(String agentAliasStatus) {
            this.agentAliasStatus = agentAliasStatus;
            return this;
        }

        @Override
        public final Builder agentAliasStatus(AgentAliasStatus agentAliasStatus) {
            this.agentAliasStatus(agentAliasStatus == null ? null : agentAliasStatus.toString());
            return this;
        }

        public final String getAgentId() {
            return agentId;
        }

        public final void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        @Override
        public final Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<AgentAliasRoutingConfigurationListItem.Builder> getRoutingConfiguration() {
            List<AgentAliasRoutingConfigurationListItem.Builder> result = AgentAliasRoutingConfigurationCopier
                    .copyToBuilder(this.routingConfiguration);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoutingConfiguration(
                Collection<AgentAliasRoutingConfigurationListItem.BuilderImpl> routingConfiguration) {
            this.routingConfiguration = AgentAliasRoutingConfigurationCopier.copyFromBuilder(routingConfiguration);
        }

        @Override
        public final Builder routingConfiguration(Collection<AgentAliasRoutingConfigurationListItem> routingConfiguration) {
            this.routingConfiguration = AgentAliasRoutingConfigurationCopier.copy(routingConfiguration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingConfiguration(AgentAliasRoutingConfigurationListItem... routingConfiguration) {
            routingConfiguration(Arrays.asList(routingConfiguration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingConfiguration(
                Consumer<AgentAliasRoutingConfigurationListItem.Builder>... routingConfiguration) {
            routingConfiguration(Stream.of(routingConfiguration)
                    .map(c -> AgentAliasRoutingConfigurationListItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public AgentAlias build() {
            return new AgentAlias(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
