/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A mapping of Bedrock Knowledge Base fields to RDS column names
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RdsFieldMapping implements SdkPojo, Serializable, ToCopyableBuilder<RdsFieldMapping.Builder, RdsFieldMapping> {
    private static final SdkField<String> PRIMARY_KEY_FIELD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("primaryKeyField").getter(getter(RdsFieldMapping::primaryKeyField))
            .setter(setter(Builder::primaryKeyField))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("primaryKeyField").build()).build();

    private static final SdkField<String> VECTOR_FIELD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vectorField").getter(getter(RdsFieldMapping::vectorField)).setter(setter(Builder::vectorField))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vectorField").build()).build();

    private static final SdkField<String> TEXT_FIELD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("textField").getter(getter(RdsFieldMapping::textField)).setter(setter(Builder::textField))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("textField").build()).build();

    private static final SdkField<String> METADATA_FIELD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("metadataField").getter(getter(RdsFieldMapping::metadataField)).setter(setter(Builder::metadataField))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadataField").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIMARY_KEY_FIELD_FIELD,
            VECTOR_FIELD_FIELD, TEXT_FIELD_FIELD, METADATA_FIELD_FIELD));

    private static final long serialVersionUID = 1L;

    private final String primaryKeyField;

    private final String vectorField;

    private final String textField;

    private final String metadataField;

    private RdsFieldMapping(BuilderImpl builder) {
        this.primaryKeyField = builder.primaryKeyField;
        this.vectorField = builder.vectorField;
        this.textField = builder.textField;
        this.metadataField = builder.metadataField;
    }

    /**
     * Returns the value of the PrimaryKeyField property for this object.
     * 
     * @return The value of the PrimaryKeyField property for this object.
     */
    public final String primaryKeyField() {
        return primaryKeyField;
    }

    /**
     * Returns the value of the VectorField property for this object.
     * 
     * @return The value of the VectorField property for this object.
     */
    public final String vectorField() {
        return vectorField;
    }

    /**
     * Returns the value of the TextField property for this object.
     * 
     * @return The value of the TextField property for this object.
     */
    public final String textField() {
        return textField;
    }

    /**
     * Returns the value of the MetadataField property for this object.
     * 
     * @return The value of the MetadataField property for this object.
     */
    public final String metadataField() {
        return metadataField;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(primaryKeyField());
        hashCode = 31 * hashCode + Objects.hashCode(vectorField());
        hashCode = 31 * hashCode + Objects.hashCode(textField());
        hashCode = 31 * hashCode + Objects.hashCode(metadataField());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RdsFieldMapping)) {
            return false;
        }
        RdsFieldMapping other = (RdsFieldMapping) obj;
        return Objects.equals(primaryKeyField(), other.primaryKeyField()) && Objects.equals(vectorField(), other.vectorField())
                && Objects.equals(textField(), other.textField()) && Objects.equals(metadataField(), other.metadataField());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RdsFieldMapping").add("PrimaryKeyField", primaryKeyField()).add("VectorField", vectorField())
                .add("TextField", textField()).add("MetadataField", metadataField()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "primaryKeyField":
            return Optional.ofNullable(clazz.cast(primaryKeyField()));
        case "vectorField":
            return Optional.ofNullable(clazz.cast(vectorField()));
        case "textField":
            return Optional.ofNullable(clazz.cast(textField()));
        case "metadataField":
            return Optional.ofNullable(clazz.cast(metadataField()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RdsFieldMapping, T> g) {
        return obj -> g.apply((RdsFieldMapping) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RdsFieldMapping> {
        /**
         * Sets the value of the PrimaryKeyField property for this object.
         *
         * @param primaryKeyField
         *        The new value for the PrimaryKeyField property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryKeyField(String primaryKeyField);

        /**
         * Sets the value of the VectorField property for this object.
         *
         * @param vectorField
         *        The new value for the VectorField property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vectorField(String vectorField);

        /**
         * Sets the value of the TextField property for this object.
         *
         * @param textField
         *        The new value for the TextField property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textField(String textField);

        /**
         * Sets the value of the MetadataField property for this object.
         *
         * @param metadataField
         *        The new value for the MetadataField property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataField(String metadataField);
    }

    static final class BuilderImpl implements Builder {
        private String primaryKeyField;

        private String vectorField;

        private String textField;

        private String metadataField;

        private BuilderImpl() {
        }

        private BuilderImpl(RdsFieldMapping model) {
            primaryKeyField(model.primaryKeyField);
            vectorField(model.vectorField);
            textField(model.textField);
            metadataField(model.metadataField);
        }

        public final String getPrimaryKeyField() {
            return primaryKeyField;
        }

        public final void setPrimaryKeyField(String primaryKeyField) {
            this.primaryKeyField = primaryKeyField;
        }

        @Override
        public final Builder primaryKeyField(String primaryKeyField) {
            this.primaryKeyField = primaryKeyField;
            return this;
        }

        public final String getVectorField() {
            return vectorField;
        }

        public final void setVectorField(String vectorField) {
            this.vectorField = vectorField;
        }

        @Override
        public final Builder vectorField(String vectorField) {
            this.vectorField = vectorField;
            return this;
        }

        public final String getTextField() {
            return textField;
        }

        public final void setTextField(String textField) {
            this.textField = textField;
        }

        @Override
        public final Builder textField(String textField) {
            this.textField = textField;
            return this;
        }

        public final String getMetadataField() {
            return metadataField;
        }

        public final void setMetadataField(String metadataField) {
            this.metadataField = metadataField;
        }

        @Override
        public final Builder metadataField(String metadataField) {
            this.metadataField = metadataField;
            return this;
        }

        @Override
        public RdsFieldMapping build() {
            return new RdsFieldMapping(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
