/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the configurations to use Pinecone to store knowledge base data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PineconeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<PineconeConfiguration.Builder, PineconeConfiguration> {
    private static final SdkField<String> CONNECTION_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectionString").getter(getter(PineconeConfiguration::connectionString))
            .setter(setter(Builder::connectionString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionString").build()).build();

    private static final SdkField<String> CREDENTIALS_SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("credentialsSecretArn").getter(getter(PineconeConfiguration::credentialsSecretArn))
            .setter(setter(Builder::credentialsSecretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialsSecretArn").build())
            .build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespace").getter(getter(PineconeConfiguration::namespace)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()).build();

    private static final SdkField<PineconeFieldMapping> FIELD_MAPPING_FIELD = SdkField
            .<PineconeFieldMapping> builder(MarshallingType.SDK_POJO).memberName("fieldMapping")
            .getter(getter(PineconeConfiguration::fieldMapping)).setter(setter(Builder::fieldMapping))
            .constructor(PineconeFieldMapping::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldMapping").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_STRING_FIELD,
            CREDENTIALS_SECRET_ARN_FIELD, NAMESPACE_FIELD, FIELD_MAPPING_FIELD));

    private static final long serialVersionUID = 1L;

    private final String connectionString;

    private final String credentialsSecretArn;

    private final String namespace;

    private final PineconeFieldMapping fieldMapping;

    private PineconeConfiguration(BuilderImpl builder) {
        this.connectionString = builder.connectionString;
        this.credentialsSecretArn = builder.credentialsSecretArn;
        this.namespace = builder.namespace;
        this.fieldMapping = builder.fieldMapping;
    }

    /**
     * Returns the value of the ConnectionString property for this object.
     * 
     * @return The value of the ConnectionString property for this object.
     */
    public final String connectionString() {
        return connectionString;
    }

    /**
     * Returns the value of the CredentialsSecretArn property for this object.
     * 
     * @return The value of the CredentialsSecretArn property for this object.
     */
    public final String credentialsSecretArn() {
        return credentialsSecretArn;
    }

    /**
     * Returns the value of the Namespace property for this object.
     * 
     * @return The value of the Namespace property for this object.
     */
    public final String namespace() {
        return namespace;
    }

    /**
     * Returns the value of the FieldMapping property for this object.
     * 
     * @return The value of the FieldMapping property for this object.
     */
    public final PineconeFieldMapping fieldMapping() {
        return fieldMapping;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(connectionString());
        hashCode = 31 * hashCode + Objects.hashCode(credentialsSecretArn());
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(fieldMapping());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PineconeConfiguration)) {
            return false;
        }
        PineconeConfiguration other = (PineconeConfiguration) obj;
        return Objects.equals(connectionString(), other.connectionString())
                && Objects.equals(credentialsSecretArn(), other.credentialsSecretArn())
                && Objects.equals(namespace(), other.namespace()) && Objects.equals(fieldMapping(), other.fieldMapping());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PineconeConfiguration").add("ConnectionString", connectionString())
                .add("CredentialsSecretArn", credentialsSecretArn()).add("Namespace", namespace())
                .add("FieldMapping", fieldMapping()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "connectionString":
            return Optional.ofNullable(clazz.cast(connectionString()));
        case "credentialsSecretArn":
            return Optional.ofNullable(clazz.cast(credentialsSecretArn()));
        case "namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "fieldMapping":
            return Optional.ofNullable(clazz.cast(fieldMapping()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PineconeConfiguration, T> g) {
        return obj -> g.apply((PineconeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PineconeConfiguration> {
        /**
         * Sets the value of the ConnectionString property for this object.
         *
         * @param connectionString
         *        The new value for the ConnectionString property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionString(String connectionString);

        /**
         * Sets the value of the CredentialsSecretArn property for this object.
         *
         * @param credentialsSecretArn
         *        The new value for the CredentialsSecretArn property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentialsSecretArn(String credentialsSecretArn);

        /**
         * Sets the value of the Namespace property for this object.
         *
         * @param namespace
         *        The new value for the Namespace property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * Sets the value of the FieldMapping property for this object.
         *
         * @param fieldMapping
         *        The new value for the FieldMapping property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldMapping(PineconeFieldMapping fieldMapping);

        /**
         * Sets the value of the FieldMapping property for this object.
         *
         * This is a convenience method that creates an instance of the {@link PineconeFieldMapping.Builder} avoiding
         * the need to create one manually via {@link PineconeFieldMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PineconeFieldMapping.Builder#build()} is called immediately and
         * its result is passed to {@link #fieldMapping(PineconeFieldMapping)}.
         * 
         * @param fieldMapping
         *        a consumer that will call methods on {@link PineconeFieldMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldMapping(PineconeFieldMapping)
         */
        default Builder fieldMapping(Consumer<PineconeFieldMapping.Builder> fieldMapping) {
            return fieldMapping(PineconeFieldMapping.builder().applyMutation(fieldMapping).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String connectionString;

        private String credentialsSecretArn;

        private String namespace;

        private PineconeFieldMapping fieldMapping;

        private BuilderImpl() {
        }

        private BuilderImpl(PineconeConfiguration model) {
            connectionString(model.connectionString);
            credentialsSecretArn(model.credentialsSecretArn);
            namespace(model.namespace);
            fieldMapping(model.fieldMapping);
        }

        public final String getConnectionString() {
            return connectionString;
        }

        public final void setConnectionString(String connectionString) {
            this.connectionString = connectionString;
        }

        @Override
        public final Builder connectionString(String connectionString) {
            this.connectionString = connectionString;
            return this;
        }

        public final String getCredentialsSecretArn() {
            return credentialsSecretArn;
        }

        public final void setCredentialsSecretArn(String credentialsSecretArn) {
            this.credentialsSecretArn = credentialsSecretArn;
        }

        @Override
        public final Builder credentialsSecretArn(String credentialsSecretArn) {
            this.credentialsSecretArn = credentialsSecretArn;
            return this;
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final PineconeFieldMapping.Builder getFieldMapping() {
            return fieldMapping != null ? fieldMapping.toBuilder() : null;
        }

        public final void setFieldMapping(PineconeFieldMapping.BuilderImpl fieldMapping) {
            this.fieldMapping = fieldMapping != null ? fieldMapping.build() : null;
        }

        @Override
        public final Builder fieldMapping(PineconeFieldMapping fieldMapping) {
            this.fieldMapping = fieldMapping;
            return this;
        }

        @Override
        public PineconeConfiguration build() {
            return new PineconeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
