/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Delete Action Group Request
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteAgentActionGroupRequest extends BedrockAgentRequest implements
        ToCopyableBuilder<DeleteAgentActionGroupRequest.Builder, DeleteAgentActionGroupRequest> {
    private static final SdkField<String> AGENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentId").getter(getter(DeleteAgentActionGroupRequest::agentId)).setter(setter(Builder::agentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("agentId").build()).build();

    private static final SdkField<String> AGENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentVersion").getter(getter(DeleteAgentActionGroupRequest::agentVersion))
            .setter(setter(Builder::agentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("agentVersion").build()).build();

    private static final SdkField<String> ACTION_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionGroupId").getter(getter(DeleteAgentActionGroupRequest::actionGroupId))
            .setter(setter(Builder::actionGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("actionGroupId").build()).build();

    private static final SdkField<Boolean> SKIP_RESOURCE_IN_USE_CHECK_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("skipResourceInUseCheck")
            .getter(getter(DeleteAgentActionGroupRequest::skipResourceInUseCheck))
            .setter(setter(Builder::skipResourceInUseCheck))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("skipResourceInUseCheck").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_ID_FIELD,
            AGENT_VERSION_FIELD, ACTION_GROUP_ID_FIELD, SKIP_RESOURCE_IN_USE_CHECK_FIELD));

    private final String agentId;

    private final String agentVersion;

    private final String actionGroupId;

    private final Boolean skipResourceInUseCheck;

    private DeleteAgentActionGroupRequest(BuilderImpl builder) {
        super(builder);
        this.agentId = builder.agentId;
        this.agentVersion = builder.agentVersion;
        this.actionGroupId = builder.actionGroupId;
        this.skipResourceInUseCheck = builder.skipResourceInUseCheck;
    }

    /**
     * <p>
     * Id generated at the server side when an Agent is created
     * </p>
     * 
     * @return Id generated at the server side when an Agent is created
     */
    public final String agentId() {
        return agentId;
    }

    /**
     * <p>
     * Draft Version of the Agent.
     * </p>
     * 
     * @return Draft Version of the Agent.
     */
    public final String agentVersion() {
        return agentVersion;
    }

    /**
     * <p>
     * Id generated at the server side when an Agent ActionGroup is created
     * </p>
     * 
     * @return Id generated at the server side when an Agent ActionGroup is created
     */
    public final String actionGroupId() {
        return actionGroupId;
    }

    /**
     * <p>
     * Skips checking if resource is in use when set to true. Defaults to false
     * </p>
     * 
     * @return Skips checking if resource is in use when set to true. Defaults to false
     */
    public final Boolean skipResourceInUseCheck() {
        return skipResourceInUseCheck;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(agentId());
        hashCode = 31 * hashCode + Objects.hashCode(agentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(actionGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(skipResourceInUseCheck());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAgentActionGroupRequest)) {
            return false;
        }
        DeleteAgentActionGroupRequest other = (DeleteAgentActionGroupRequest) obj;
        return Objects.equals(agentId(), other.agentId()) && Objects.equals(agentVersion(), other.agentVersion())
                && Objects.equals(actionGroupId(), other.actionGroupId())
                && Objects.equals(skipResourceInUseCheck(), other.skipResourceInUseCheck());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteAgentActionGroupRequest").add("AgentId", agentId()).add("AgentVersion", agentVersion())
                .add("ActionGroupId", actionGroupId()).add("SkipResourceInUseCheck", skipResourceInUseCheck()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentId":
            return Optional.ofNullable(clazz.cast(agentId()));
        case "agentVersion":
            return Optional.ofNullable(clazz.cast(agentVersion()));
        case "actionGroupId":
            return Optional.ofNullable(clazz.cast(actionGroupId()));
        case "skipResourceInUseCheck":
            return Optional.ofNullable(clazz.cast(skipResourceInUseCheck()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteAgentActionGroupRequest, T> g) {
        return obj -> g.apply((DeleteAgentActionGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockAgentRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteAgentActionGroupRequest> {
        /**
         * <p>
         * Id generated at the server side when an Agent is created
         * </p>
         * 
         * @param agentId
         *        Id generated at the server side when an Agent is created
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentId(String agentId);

        /**
         * <p>
         * Draft Version of the Agent.
         * </p>
         * 
         * @param agentVersion
         *        Draft Version of the Agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentVersion(String agentVersion);

        /**
         * <p>
         * Id generated at the server side when an Agent ActionGroup is created
         * </p>
         * 
         * @param actionGroupId
         *        Id generated at the server side when an Agent ActionGroup is created
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionGroupId(String actionGroupId);

        /**
         * <p>
         * Skips checking if resource is in use when set to true. Defaults to false
         * </p>
         * 
         * @param skipResourceInUseCheck
         *        Skips checking if resource is in use when set to true. Defaults to false
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skipResourceInUseCheck(Boolean skipResourceInUseCheck);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockAgentRequest.BuilderImpl implements Builder {
        private String agentId;

        private String agentVersion;

        private String actionGroupId;

        private Boolean skipResourceInUseCheck;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAgentActionGroupRequest model) {
            super(model);
            agentId(model.agentId);
            agentVersion(model.agentVersion);
            actionGroupId(model.actionGroupId);
            skipResourceInUseCheck(model.skipResourceInUseCheck);
        }

        public final String getAgentId() {
            return agentId;
        }

        public final void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        @Override
        public final Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public final String getAgentVersion() {
            return agentVersion;
        }

        public final void setAgentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
        }

        @Override
        public final Builder agentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            return this;
        }

        public final String getActionGroupId() {
            return actionGroupId;
        }

        public final void setActionGroupId(String actionGroupId) {
            this.actionGroupId = actionGroupId;
        }

        @Override
        public final Builder actionGroupId(String actionGroupId) {
            this.actionGroupId = actionGroupId;
            return this;
        }

        public final Boolean getSkipResourceInUseCheck() {
            return skipResourceInUseCheck;
        }

        public final void setSkipResourceInUseCheck(Boolean skipResourceInUseCheck) {
            this.skipResourceInUseCheck = skipResourceInUseCheck;
        }

        @Override
        public final Builder skipResourceInUseCheck(Boolean skipResourceInUseCheck) {
            this.skipResourceInUseCheck = skipResourceInUseCheck;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteAgentActionGroupRequest build() {
            return new DeleteAgentActionGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
