/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configures chunking strategy
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChunkingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ChunkingConfiguration.Builder, ChunkingConfiguration> {
    private static final SdkField<String> CHUNKING_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("chunkingStrategy").getter(getter(ChunkingConfiguration::chunkingStrategyAsString))
            .setter(setter(Builder::chunkingStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("chunkingStrategy").build()).build();

    private static final SdkField<FixedSizeChunkingConfiguration> FIXED_SIZE_CHUNKING_CONFIGURATION_FIELD = SdkField
            .<FixedSizeChunkingConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("fixedSizeChunkingConfiguration")
            .getter(getter(ChunkingConfiguration::fixedSizeChunkingConfiguration))
            .setter(setter(Builder::fixedSizeChunkingConfiguration))
            .constructor(FixedSizeChunkingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fixedSizeChunkingConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHUNKING_STRATEGY_FIELD,
            FIXED_SIZE_CHUNKING_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String chunkingStrategy;

    private final FixedSizeChunkingConfiguration fixedSizeChunkingConfiguration;

    private ChunkingConfiguration(BuilderImpl builder) {
        this.chunkingStrategy = builder.chunkingStrategy;
        this.fixedSizeChunkingConfiguration = builder.fixedSizeChunkingConfiguration;
    }

    /**
     * Returns the value of the ChunkingStrategy property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #chunkingStrategy}
     * will return {@link ChunkingStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #chunkingStrategyAsString}.
     * </p>
     * 
     * @return The value of the ChunkingStrategy property for this object.
     * @see ChunkingStrategy
     */
    public final ChunkingStrategy chunkingStrategy() {
        return ChunkingStrategy.fromValue(chunkingStrategy);
    }

    /**
     * Returns the value of the ChunkingStrategy property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #chunkingStrategy}
     * will return {@link ChunkingStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #chunkingStrategyAsString}.
     * </p>
     * 
     * @return The value of the ChunkingStrategy property for this object.
     * @see ChunkingStrategy
     */
    public final String chunkingStrategyAsString() {
        return chunkingStrategy;
    }

    /**
     * Returns the value of the FixedSizeChunkingConfiguration property for this object.
     * 
     * @return The value of the FixedSizeChunkingConfiguration property for this object.
     */
    public final FixedSizeChunkingConfiguration fixedSizeChunkingConfiguration() {
        return fixedSizeChunkingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(chunkingStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(fixedSizeChunkingConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChunkingConfiguration)) {
            return false;
        }
        ChunkingConfiguration other = (ChunkingConfiguration) obj;
        return Objects.equals(chunkingStrategyAsString(), other.chunkingStrategyAsString())
                && Objects.equals(fixedSizeChunkingConfiguration(), other.fixedSizeChunkingConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChunkingConfiguration").add("ChunkingStrategy", chunkingStrategyAsString())
                .add("FixedSizeChunkingConfiguration", fixedSizeChunkingConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "chunkingStrategy":
            return Optional.ofNullable(clazz.cast(chunkingStrategyAsString()));
        case "fixedSizeChunkingConfiguration":
            return Optional.ofNullable(clazz.cast(fixedSizeChunkingConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChunkingConfiguration, T> g) {
        return obj -> g.apply((ChunkingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChunkingConfiguration> {
        /**
         * Sets the value of the ChunkingStrategy property for this object.
         *
         * @param chunkingStrategy
         *        The new value for the ChunkingStrategy property for this object.
         * @see ChunkingStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChunkingStrategy
         */
        Builder chunkingStrategy(String chunkingStrategy);

        /**
         * Sets the value of the ChunkingStrategy property for this object.
         *
         * @param chunkingStrategy
         *        The new value for the ChunkingStrategy property for this object.
         * @see ChunkingStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChunkingStrategy
         */
        Builder chunkingStrategy(ChunkingStrategy chunkingStrategy);

        /**
         * Sets the value of the FixedSizeChunkingConfiguration property for this object.
         *
         * @param fixedSizeChunkingConfiguration
         *        The new value for the FixedSizeChunkingConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fixedSizeChunkingConfiguration(FixedSizeChunkingConfiguration fixedSizeChunkingConfiguration);

        /**
         * Sets the value of the FixedSizeChunkingConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link FixedSizeChunkingConfiguration.Builder}
         * avoiding the need to create one manually via {@link FixedSizeChunkingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FixedSizeChunkingConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #fixedSizeChunkingConfiguration(FixedSizeChunkingConfiguration)}.
         * 
         * @param fixedSizeChunkingConfiguration
         *        a consumer that will call methods on {@link FixedSizeChunkingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fixedSizeChunkingConfiguration(FixedSizeChunkingConfiguration)
         */
        default Builder fixedSizeChunkingConfiguration(
                Consumer<FixedSizeChunkingConfiguration.Builder> fixedSizeChunkingConfiguration) {
            return fixedSizeChunkingConfiguration(FixedSizeChunkingConfiguration.builder()
                    .applyMutation(fixedSizeChunkingConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String chunkingStrategy;

        private FixedSizeChunkingConfiguration fixedSizeChunkingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ChunkingConfiguration model) {
            chunkingStrategy(model.chunkingStrategy);
            fixedSizeChunkingConfiguration(model.fixedSizeChunkingConfiguration);
        }

        public final String getChunkingStrategy() {
            return chunkingStrategy;
        }

        public final void setChunkingStrategy(String chunkingStrategy) {
            this.chunkingStrategy = chunkingStrategy;
        }

        @Override
        public final Builder chunkingStrategy(String chunkingStrategy) {
            this.chunkingStrategy = chunkingStrategy;
            return this;
        }

        @Override
        public final Builder chunkingStrategy(ChunkingStrategy chunkingStrategy) {
            this.chunkingStrategy(chunkingStrategy == null ? null : chunkingStrategy.toString());
            return this;
        }

        public final FixedSizeChunkingConfiguration.Builder getFixedSizeChunkingConfiguration() {
            return fixedSizeChunkingConfiguration != null ? fixedSizeChunkingConfiguration.toBuilder() : null;
        }

        public final void setFixedSizeChunkingConfiguration(
                FixedSizeChunkingConfiguration.BuilderImpl fixedSizeChunkingConfiguration) {
            this.fixedSizeChunkingConfiguration = fixedSizeChunkingConfiguration != null ? fixedSizeChunkingConfiguration.build()
                    : null;
        }

        @Override
        public final Builder fixedSizeChunkingConfiguration(FixedSizeChunkingConfiguration fixedSizeChunkingConfiguration) {
            this.fixedSizeChunkingConfiguration = fixedSizeChunkingConfiguration;
            return this;
        }

        @Override
        public ChunkingConfiguration build() {
            return new ChunkingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
