/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the information of an Agent Action Group
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AgentActionGroup implements SdkPojo, Serializable,
        ToCopyableBuilder<AgentActionGroup.Builder, AgentActionGroup> {
    private static final SdkField<String> AGENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentId").getter(getter(AgentActionGroup::agentId)).setter(setter(Builder::agentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentId").build()).build();

    private static final SdkField<String> AGENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentVersion").getter(getter(AgentActionGroup::agentVersion)).setter(setter(Builder::agentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentVersion").build()).build();

    private static final SdkField<String> ACTION_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionGroupId").getter(getter(AgentActionGroup::actionGroupId)).setter(setter(Builder::actionGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionGroupId").build()).build();

    private static final SdkField<String> ACTION_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionGroupName").getter(getter(AgentActionGroup::actionGroupName))
            .setter(setter(Builder::actionGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionGroupName").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientToken").getter(getter(AgentActionGroup::clientToken)).setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(AgentActionGroup::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(AgentActionGroup::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(AgentActionGroup::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> PARENT_ACTION_SIGNATURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parentActionSignature").getter(getter(AgentActionGroup::parentActionSignatureAsString))
            .setter(setter(Builder::parentActionSignature))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentActionSignature").build())
            .build();

    private static final SdkField<ActionGroupExecutor> ACTION_GROUP_EXECUTOR_FIELD = SdkField
            .<ActionGroupExecutor> builder(MarshallingType.SDK_POJO).memberName("actionGroupExecutor")
            .getter(getter(AgentActionGroup::actionGroupExecutor)).setter(setter(Builder::actionGroupExecutor))
            .constructor(ActionGroupExecutor::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionGroupExecutor").build())
            .build();

    private static final SdkField<APISchema> API_SCHEMA_FIELD = SdkField.<APISchema> builder(MarshallingType.SDK_POJO)
            .memberName("apiSchema").getter(getter(AgentActionGroup::apiSchema)).setter(setter(Builder::apiSchema))
            .constructor(APISchema::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiSchema").build()).build();

    private static final SdkField<String> ACTION_GROUP_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionGroupState").getter(getter(AgentActionGroup::actionGroupStateAsString))
            .setter(setter(Builder::actionGroupState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionGroupState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_ID_FIELD,
            AGENT_VERSION_FIELD, ACTION_GROUP_ID_FIELD, ACTION_GROUP_NAME_FIELD, CLIENT_TOKEN_FIELD, DESCRIPTION_FIELD,
            CREATED_AT_FIELD, UPDATED_AT_FIELD, PARENT_ACTION_SIGNATURE_FIELD, ACTION_GROUP_EXECUTOR_FIELD, API_SCHEMA_FIELD,
            ACTION_GROUP_STATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String agentId;

    private final String agentVersion;

    private final String actionGroupId;

    private final String actionGroupName;

    private final String clientToken;

    private final String description;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final String parentActionSignature;

    private final ActionGroupExecutor actionGroupExecutor;

    private final APISchema apiSchema;

    private final String actionGroupState;

    private AgentActionGroup(BuilderImpl builder) {
        this.agentId = builder.agentId;
        this.agentVersion = builder.agentVersion;
        this.actionGroupId = builder.actionGroupId;
        this.actionGroupName = builder.actionGroupName;
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.parentActionSignature = builder.parentActionSignature;
        this.actionGroupExecutor = builder.actionGroupExecutor;
        this.apiSchema = builder.apiSchema;
        this.actionGroupState = builder.actionGroupState;
    }

    /**
     * Returns the value of the AgentId property for this object.
     * 
     * @return The value of the AgentId property for this object.
     */
    public final String agentId() {
        return agentId;
    }

    /**
     * Returns the value of the AgentVersion property for this object.
     * 
     * @return The value of the AgentVersion property for this object.
     */
    public final String agentVersion() {
        return agentVersion;
    }

    /**
     * Returns the value of the ActionGroupId property for this object.
     * 
     * @return The value of the ActionGroupId property for this object.
     */
    public final String actionGroupId() {
        return actionGroupId;
    }

    /**
     * Returns the value of the ActionGroupName property for this object.
     * 
     * @return The value of the ActionGroupName property for this object.
     */
    public final String actionGroupName() {
        return actionGroupName;
    }

    /**
     * Returns the value of the ClientToken property for this object.
     * 
     * @return The value of the ClientToken property for this object.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * Returns the value of the Description property for this object.
     * 
     * @return The value of the Description property for this object.
     */
    public final String description() {
        return description;
    }

    /**
     * Returns the value of the CreatedAt property for this object.
     * 
     * @return The value of the CreatedAt property for this object.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * Returns the value of the UpdatedAt property for this object.
     * 
     * @return The value of the UpdatedAt property for this object.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * Returns the value of the ParentActionSignature property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #parentActionSignature} will return {@link ActionGroupSignature#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #parentActionSignatureAsString}.
     * </p>
     * 
     * @return The value of the ParentActionSignature property for this object.
     * @see ActionGroupSignature
     */
    public final ActionGroupSignature parentActionSignature() {
        return ActionGroupSignature.fromValue(parentActionSignature);
    }

    /**
     * Returns the value of the ParentActionSignature property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #parentActionSignature} will return {@link ActionGroupSignature#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #parentActionSignatureAsString}.
     * </p>
     * 
     * @return The value of the ParentActionSignature property for this object.
     * @see ActionGroupSignature
     */
    public final String parentActionSignatureAsString() {
        return parentActionSignature;
    }

    /**
     * Returns the value of the ActionGroupExecutor property for this object.
     * 
     * @return The value of the ActionGroupExecutor property for this object.
     */
    public final ActionGroupExecutor actionGroupExecutor() {
        return actionGroupExecutor;
    }

    /**
     * Returns the value of the ApiSchema property for this object.
     * 
     * @return The value of the ApiSchema property for this object.
     */
    public final APISchema apiSchema() {
        return apiSchema;
    }

    /**
     * Returns the value of the ActionGroupState property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionGroupState}
     * will return {@link ActionGroupState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #actionGroupStateAsString}.
     * </p>
     * 
     * @return The value of the ActionGroupState property for this object.
     * @see ActionGroupState
     */
    public final ActionGroupState actionGroupState() {
        return ActionGroupState.fromValue(actionGroupState);
    }

    /**
     * Returns the value of the ActionGroupState property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionGroupState}
     * will return {@link ActionGroupState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #actionGroupStateAsString}.
     * </p>
     * 
     * @return The value of the ActionGroupState property for this object.
     * @see ActionGroupState
     */
    public final String actionGroupStateAsString() {
        return actionGroupState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(agentId());
        hashCode = 31 * hashCode + Objects.hashCode(agentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(actionGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(actionGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(parentActionSignatureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(actionGroupExecutor());
        hashCode = 31 * hashCode + Objects.hashCode(apiSchema());
        hashCode = 31 * hashCode + Objects.hashCode(actionGroupStateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentActionGroup)) {
            return false;
        }
        AgentActionGroup other = (AgentActionGroup) obj;
        return Objects.equals(agentId(), other.agentId()) && Objects.equals(agentVersion(), other.agentVersion())
                && Objects.equals(actionGroupId(), other.actionGroupId())
                && Objects.equals(actionGroupName(), other.actionGroupName())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(description(), other.description())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(parentActionSignatureAsString(), other.parentActionSignatureAsString())
                && Objects.equals(actionGroupExecutor(), other.actionGroupExecutor())
                && Objects.equals(apiSchema(), other.apiSchema())
                && Objects.equals(actionGroupStateAsString(), other.actionGroupStateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AgentActionGroup").add("AgentId", agentId()).add("AgentVersion", agentVersion())
                .add("ActionGroupId", actionGroupId()).add("ActionGroupName", actionGroupName())
                .add("ClientToken", clientToken()).add("Description", description()).add("CreatedAt", createdAt())
                .add("UpdatedAt", updatedAt()).add("ParentActionSignature", parentActionSignatureAsString())
                .add("ActionGroupExecutor", actionGroupExecutor()).add("ApiSchema", apiSchema())
                .add("ActionGroupState", actionGroupStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentId":
            return Optional.ofNullable(clazz.cast(agentId()));
        case "agentVersion":
            return Optional.ofNullable(clazz.cast(agentVersion()));
        case "actionGroupId":
            return Optional.ofNullable(clazz.cast(actionGroupId()));
        case "actionGroupName":
            return Optional.ofNullable(clazz.cast(actionGroupName()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "parentActionSignature":
            return Optional.ofNullable(clazz.cast(parentActionSignatureAsString()));
        case "actionGroupExecutor":
            return Optional.ofNullable(clazz.cast(actionGroupExecutor()));
        case "apiSchema":
            return Optional.ofNullable(clazz.cast(apiSchema()));
        case "actionGroupState":
            return Optional.ofNullable(clazz.cast(actionGroupStateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AgentActionGroup, T> g) {
        return obj -> g.apply((AgentActionGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AgentActionGroup> {
        /**
         * Sets the value of the AgentId property for this object.
         *
         * @param agentId
         *        The new value for the AgentId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentId(String agentId);

        /**
         * Sets the value of the AgentVersion property for this object.
         *
         * @param agentVersion
         *        The new value for the AgentVersion property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentVersion(String agentVersion);

        /**
         * Sets the value of the ActionGroupId property for this object.
         *
         * @param actionGroupId
         *        The new value for the ActionGroupId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionGroupId(String actionGroupId);

        /**
         * Sets the value of the ActionGroupName property for this object.
         *
         * @param actionGroupName
         *        The new value for the ActionGroupName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionGroupName(String actionGroupName);

        /**
         * Sets the value of the ClientToken property for this object.
         *
         * @param clientToken
         *        The new value for the ClientToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * Sets the value of the Description property for this object.
         *
         * @param description
         *        The new value for the Description property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * Sets the value of the CreatedAt property for this object.
         *
         * @param createdAt
         *        The new value for the CreatedAt property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * Sets the value of the UpdatedAt property for this object.
         *
         * @param updatedAt
         *        The new value for the UpdatedAt property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * Sets the value of the ParentActionSignature property for this object.
         *
         * @param parentActionSignature
         *        The new value for the ParentActionSignature property for this object.
         * @see ActionGroupSignature
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionGroupSignature
         */
        Builder parentActionSignature(String parentActionSignature);

        /**
         * Sets the value of the ParentActionSignature property for this object.
         *
         * @param parentActionSignature
         *        The new value for the ParentActionSignature property for this object.
         * @see ActionGroupSignature
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionGroupSignature
         */
        Builder parentActionSignature(ActionGroupSignature parentActionSignature);

        /**
         * Sets the value of the ActionGroupExecutor property for this object.
         *
         * @param actionGroupExecutor
         *        The new value for the ActionGroupExecutor property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionGroupExecutor(ActionGroupExecutor actionGroupExecutor);

        /**
         * Sets the value of the ActionGroupExecutor property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ActionGroupExecutor.Builder} avoiding the
         * need to create one manually via {@link ActionGroupExecutor#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActionGroupExecutor.Builder#build()} is called immediately and
         * its result is passed to {@link #actionGroupExecutor(ActionGroupExecutor)}.
         * 
         * @param actionGroupExecutor
         *        a consumer that will call methods on {@link ActionGroupExecutor.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actionGroupExecutor(ActionGroupExecutor)
         */
        default Builder actionGroupExecutor(Consumer<ActionGroupExecutor.Builder> actionGroupExecutor) {
            return actionGroupExecutor(ActionGroupExecutor.builder().applyMutation(actionGroupExecutor).build());
        }

        /**
         * Sets the value of the ApiSchema property for this object.
         *
         * @param apiSchema
         *        The new value for the ApiSchema property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiSchema(APISchema apiSchema);

        /**
         * Sets the value of the ApiSchema property for this object.
         *
         * This is a convenience method that creates an instance of the {@link APISchema.Builder} avoiding the need to
         * create one manually via {@link APISchema#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link APISchema.Builder#build()} is called immediately and its result
         * is passed to {@link #apiSchema(APISchema)}.
         * 
         * @param apiSchema
         *        a consumer that will call methods on {@link APISchema.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #apiSchema(APISchema)
         */
        default Builder apiSchema(Consumer<APISchema.Builder> apiSchema) {
            return apiSchema(APISchema.builder().applyMutation(apiSchema).build());
        }

        /**
         * Sets the value of the ActionGroupState property for this object.
         *
         * @param actionGroupState
         *        The new value for the ActionGroupState property for this object.
         * @see ActionGroupState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionGroupState
         */
        Builder actionGroupState(String actionGroupState);

        /**
         * Sets the value of the ActionGroupState property for this object.
         *
         * @param actionGroupState
         *        The new value for the ActionGroupState property for this object.
         * @see ActionGroupState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionGroupState
         */
        Builder actionGroupState(ActionGroupState actionGroupState);
    }

    static final class BuilderImpl implements Builder {
        private String agentId;

        private String agentVersion;

        private String actionGroupId;

        private String actionGroupName;

        private String clientToken;

        private String description;

        private Instant createdAt;

        private Instant updatedAt;

        private String parentActionSignature;

        private ActionGroupExecutor actionGroupExecutor;

        private APISchema apiSchema;

        private String actionGroupState;

        private BuilderImpl() {
        }

        private BuilderImpl(AgentActionGroup model) {
            agentId(model.agentId);
            agentVersion(model.agentVersion);
            actionGroupId(model.actionGroupId);
            actionGroupName(model.actionGroupName);
            clientToken(model.clientToken);
            description(model.description);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            parentActionSignature(model.parentActionSignature);
            actionGroupExecutor(model.actionGroupExecutor);
            apiSchema(model.apiSchema);
            actionGroupState(model.actionGroupState);
        }

        public final String getAgentId() {
            return agentId;
        }

        public final void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        @Override
        public final Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public final String getAgentVersion() {
            return agentVersion;
        }

        public final void setAgentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
        }

        @Override
        public final Builder agentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            return this;
        }

        public final String getActionGroupId() {
            return actionGroupId;
        }

        public final void setActionGroupId(String actionGroupId) {
            this.actionGroupId = actionGroupId;
        }

        @Override
        public final Builder actionGroupId(String actionGroupId) {
            this.actionGroupId = actionGroupId;
            return this;
        }

        public final String getActionGroupName() {
            return actionGroupName;
        }

        public final void setActionGroupName(String actionGroupName) {
            this.actionGroupName = actionGroupName;
        }

        @Override
        public final Builder actionGroupName(String actionGroupName) {
            this.actionGroupName = actionGroupName;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getParentActionSignature() {
            return parentActionSignature;
        }

        public final void setParentActionSignature(String parentActionSignature) {
            this.parentActionSignature = parentActionSignature;
        }

        @Override
        public final Builder parentActionSignature(String parentActionSignature) {
            this.parentActionSignature = parentActionSignature;
            return this;
        }

        @Override
        public final Builder parentActionSignature(ActionGroupSignature parentActionSignature) {
            this.parentActionSignature(parentActionSignature == null ? null : parentActionSignature.toString());
            return this;
        }

        public final ActionGroupExecutor.Builder getActionGroupExecutor() {
            return actionGroupExecutor != null ? actionGroupExecutor.toBuilder() : null;
        }

        public final void setActionGroupExecutor(ActionGroupExecutor.BuilderImpl actionGroupExecutor) {
            this.actionGroupExecutor = actionGroupExecutor != null ? actionGroupExecutor.build() : null;
        }

        @Override
        public final Builder actionGroupExecutor(ActionGroupExecutor actionGroupExecutor) {
            this.actionGroupExecutor = actionGroupExecutor;
            return this;
        }

        public final APISchema.Builder getApiSchema() {
            return apiSchema != null ? apiSchema.toBuilder() : null;
        }

        public final void setApiSchema(APISchema.BuilderImpl apiSchema) {
            this.apiSchema = apiSchema != null ? apiSchema.build() : null;
        }

        @Override
        public final Builder apiSchema(APISchema apiSchema) {
            this.apiSchema = apiSchema;
            return this;
        }

        public final String getActionGroupState() {
            return actionGroupState;
        }

        public final void setActionGroupState(String actionGroupState) {
            this.actionGroupState = actionGroupState;
        }

        @Override
        public final Builder actionGroupState(String actionGroupState) {
            this.actionGroupState = actionGroupState;
            return this;
        }

        @Override
        public final Builder actionGroupState(ActionGroupState actionGroupState) {
            this.actionGroupState(actionGroupState == null ? null : actionGroupState.toString());
            return this;
        }

        @Override
        public AgentActionGroup build() {
            return new AgentActionGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
