/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrock.BedrockAsyncClient;
import software.amazon.awssdk.services.bedrock.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrock.model.ListProvisionedModelThroughputsRequest;
import software.amazon.awssdk.services.bedrock.model.ListProvisionedModelThroughputsResponse;
import software.amazon.awssdk.services.bedrock.model.ProvisionedModelSummary;

public class ListProvisionedModelThroughputsPublisher
implements SdkPublisher<ListProvisionedModelThroughputsResponse> {
    private final BedrockAsyncClient client;
    private final ListProvisionedModelThroughputsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListProvisionedModelThroughputsPublisher(BedrockAsyncClient client, ListProvisionedModelThroughputsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListProvisionedModelThroughputsPublisher(BedrockAsyncClient client, ListProvisionedModelThroughputsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListProvisionedModelThroughputsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListProvisionedModelThroughputsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ProvisionedModelSummary> provisionedModelSummaries() {
        return this.flatMapIterable(response -> response.provisionedModelSummaries());
    }

    private class ListProvisionedModelThroughputsResponseFetcher
    implements AsyncPageFetcher<ListProvisionedModelThroughputsResponse> {
        private ListProvisionedModelThroughputsResponseFetcher() {
        }

        public boolean hasNextPage(ListProvisionedModelThroughputsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListProvisionedModelThroughputsResponse> nextPage(ListProvisionedModelThroughputsResponse previousPage) {
            if (previousPage == null) {
                return ListProvisionedModelThroughputsPublisher.this.client.listProvisionedModelThroughputs(ListProvisionedModelThroughputsPublisher.this.firstRequest);
            }
            return ListProvisionedModelThroughputsPublisher.this.client.listProvisionedModelThroughputs((ListProvisionedModelThroughputsRequest)((Object)ListProvisionedModelThroughputsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

