/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrock.BedrockAsyncClient;
import software.amazon.awssdk.services.bedrock.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrock.model.ListModelInvocationJobsRequest;
import software.amazon.awssdk.services.bedrock.model.ListModelInvocationJobsResponse;
import software.amazon.awssdk.services.bedrock.model.ModelInvocationJobSummary;

public class ListModelInvocationJobsPublisher
implements SdkPublisher<ListModelInvocationJobsResponse> {
    private final BedrockAsyncClient client;
    private final ListModelInvocationJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListModelInvocationJobsPublisher(BedrockAsyncClient client, ListModelInvocationJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListModelInvocationJobsPublisher(BedrockAsyncClient client, ListModelInvocationJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListModelInvocationJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListModelInvocationJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ModelInvocationJobSummary> invocationJobSummaries() {
        return this.flatMapIterable(response -> response.invocationJobSummaries());
    }

    private class ListModelInvocationJobsResponseFetcher
    implements AsyncPageFetcher<ListModelInvocationJobsResponse> {
        private ListModelInvocationJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListModelInvocationJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListModelInvocationJobsResponse> nextPage(ListModelInvocationJobsResponse previousPage) {
            if (previousPage == null) {
                return ListModelInvocationJobsPublisher.this.client.listModelInvocationJobs(ListModelInvocationJobsPublisher.this.firstRequest);
            }
            return ListModelInvocationJobsPublisher.this.client.listModelInvocationJobs((ListModelInvocationJobsRequest)((Object)ListModelInvocationJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

